/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import com.google.common.collect.UnmodifiableIterator;
import gregtech.api.GTValues;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtechlite.gtlitecore.api.extension.RecipeBuilderExtKt;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.material.info.GTLiteMaterialFlags;
import gregtechlite.gtlitecore.api.unification.ore.GTLiteOrePrefix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/BouleRecipeHandler;", "", "<init>", "()V", "init", "", "processCrystallizer", "gemPrefix", "Lgregtech/api/unification/ore/OrePrefix;", "material", "Lgregtech/api/unification/material/Material;", "property", "Lgregtech/api/unification/material/properties/GemProperty;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nBouleRecipeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BouleRecipeHandler.kt\ngregtechlite/gtlitecore/loader/recipe/handler/BouleRecipeHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,128:1\n37#2:129\n36#2,3:130\n*S KotlinDebug\n*F\n+ 1 BouleRecipeHandler.kt\ngregtechlite/gtlitecore/loader/recipe/handler/BouleRecipeHandler\n*L\n104#1:129\n104#1:130,3\n*E\n"})
public final class BouleRecipeHandler {
    @NotNull
    public static final BouleRecipeHandler INSTANCE = new BouleRecipeHandler();

    private BouleRecipeHandler() {
    }

    public final void init() {
        OrePrefix.gem.addProcessingHandler(PropertyKey.GEM, INSTANCE::processCrystallizer);
    }

    private final void processCrystallizer(OrePrefix gemPrefix, Material material, GemProperty property) {
        BlastRecipeBuilder blastRecipeBuilder;
        FluidStack fluid;
        ItemStack stack;
        Object object;
        MaterialFlag[] materialFlagArray = new MaterialFlag[]{GTLiteMaterialFlags.INSTANCE.getDISABLE_CRYSTALLIZATION()};
        if (material.hasFlags(materialFlagArray)) {
            return;
        }
        materialFlagArray = new MaterialFlag[]{MaterialFlags.CRYSTALLIZABLE};
        if (!material.hasFlags(materialFlagArray) && !material.hasFlags(materialFlagArray = new MaterialFlag[]{GTLiteMaterialFlags.INSTANCE.getGENERATE_BOULE()})) {
            return;
        }
        if (material.getMaterialComponents().size() > GTLiteRecipeMaps.CRYSTALLIZATION_RECIPES.getMaxInputs() - 1 + GTLiteRecipeMaps.CRYSTALLIZATION_RECIPES.getMaxFluidInputs()) {
            return;
        }
        int componentAmount = 0;
        int temperature = 0;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
        UnmodifiableIterator unmodifiableIterator = material.getMaterialComponents().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            MaterialStack ms = (MaterialStack)unmodifiableIterator2.next();
            Material component = ms.material;
            int amount = (int)ms.amount;
            if (component.isSolid() || component.hasProperty(PropertyKey.DUST)) {
                componentAmount += amount;
                temperature += component.getBlastTemperature() * amount;
                if (inputs.size() > GTLiteRecipeMaps.CRYSTALLIZATION_RECIPES.getMaxInputs() - 1) {
                    return;
                }
                inputs.add(OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)component, (int)amount));
            } else if (component.hasProperty(PropertyKey.FLUID)) {
                componentAmount += amount;
                if (fluidInputs.size() > GTLiteRecipeMaps.CRYSTALLIZATION_RECIPES.getMaxFluidInputs()) {
                    return;
                }
                fluidInputs.add(component.getFluid(amount * 1000));
            }
            if (component.hasProperty(PropertyKey.BLAST)) continue;
            temperature += 1200 * amount;
        }
        if (componentAmount == 0) {
            return;
        }
        BlastRecipeBuilder blastRecipeBuilder2 = ((BlastRecipeBuilder)GTLiteRecipeMaps.CRYSTALLIZATION_RECIPES.recipeBuilder()).blastFurnaceTemp(temperature /= componentAmount);
        Intrinsics.checkNotNullExpressionValue((Object)blastRecipeBuilder2, (String)"blastFurnaceTemp(...)");
        BlastRecipeBuilder builder = (BlastRecipeBuilder)RecipeBuilderExtKt.EUt((RecipeBuilder)blastRecipeBuilder2, GTValues.VA[temperature <= 2800 ? 3 : 4]);
        if (componentAmount == 2) {
            FluidStack[] fluidStackArray = inputs.iterator();
            Intrinsics.checkNotNullExpressionValue(fluidStackArray, (String)"iterator(...)");
            object = fluidStackArray;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                stack = (ItemStack)e;
                stack.func_190920_e(stack.func_190916_E() * 2);
            }
            Iterator iterator = fluidInputs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            object = iterator;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                fluid = (FluidStack)e;
                fluid.amount *= 2;
            }
            componentAmount = 1;
            Intrinsics.checkNotNull((Object)builder);
            blastRecipeBuilder = (BlastRecipeBuilder)RecipeBuilderExtKt.duration((RecipeBuilder)builder, material.getMass() * (long)8);
        } else if (componentAmount % 4 != 0) {
            Iterator iterator = inputs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            object = iterator;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                stack = (ItemStack)e;
                stack.func_190920_e(stack.func_190916_E() * 4);
            }
            Iterator iterator2 = fluidInputs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            object = iterator2;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                fluid = (FluidStack)e;
                fluid.amount *= 4;
            }
            Intrinsics.checkNotNull((Object)builder);
            blastRecipeBuilder = (BlastRecipeBuilder)RecipeBuilderExtKt.duration((RecipeBuilder)builder, material.getMass() * (long)16);
        } else {
            componentAmount /= 4;
            Intrinsics.checkNotNull((Object)builder);
            blastRecipeBuilder = (BlastRecipeBuilder)RecipeBuilderExtKt.duration((RecipeBuilder)builder, material.getMass() * (long)4);
        }
        ((BlastRecipeBuilder)builder.input(GTLiteOrePrefix.seedCrystal, material, componentAmount)).output(GTLiteOrePrefix.boule, material, componentAmount);
        if (!((Collection)inputs).isEmpty()) {
            builder.inputStacks((Collection)inputs);
        }
        if (!((Collection)fluidInputs).isEmpty()) {
            Collection $this$toTypedArray$iv = fluidInputs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new FluidStack[0]);
            builder.fluidInputs(Arrays.copyOf(object, ((FluidStack[])object).length));
        }
        builder.buildAndRegister();
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).input(GTLiteOrePrefix.boule, material)).output(OrePrefix.gemExquisite, material)).output(GTLiteOrePrefix.seedCrystal, material);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        object = RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[1]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EUt(...)");
        ((SimpleRecipeBuilder)RecipeBuilderExtKt.duration(object, material.getMass() * (long)4)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder()).input(OrePrefix.gemExquisite, material)).fluidInputs(Materials.DistilledWater.getFluid(8000))).output(GTLiteOrePrefix.seedCrystal, material);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"output(...)");
        object = RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[3]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EUt(...)");
        ((SimpleRecipeBuilder)RecipeBuilderExtKt.duration(object, material.getMass() * (long)9)).buildAndRegister();
    }
}

