/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.chain;

import gregtech.api.GTValues;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.items.MetaItems;
import gregtechlite.gtlitecore.api.extension.RecipeBuilderExtKt;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.builder.NoCoilTemperatureRecipeBuilder;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/chain/NanotubesChain;", "", "<init>", "()V", "init", "", "bipyridineProcess", "palladiumBisdibenzylidieneacetoneProcess", "dichlorocyclooctadieneplatiniumProcess", "cppProcess", "cntProcess", "seaborgiumCNTProcess", "lanthanumFullereneNTProcess", "neutroniumCNTProcess", "gtlitecore"})
public final class NanotubesChain {
    @NotNull
    public static final NanotubesChain INSTANCE = new NanotubesChain();

    private NanotubesChain() {
    }

    public final void init() {
        this.bipyridineProcess();
        this.palladiumBisdibenzylidieneacetoneProcess();
        this.dichlorocyclooctadieneplatiniumProcess();
        this.cppProcess();
        this.cntProcess();
        this.seaborgiumCNTProcess();
        this.lanthanumFullereneNTProcess();
        this.neutroniumCNTProcess();
    }

    private final void bipyridineProcess() {
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.CRYOGENIC_REACTOR_RECIPES.recipeBuilder()).notConsumable(OrePrefix.dust, Materials.Thallium)).fluidInputs(GTLiteMaterials.INSTANCE.getFormaldehyde().getFluid(1000))).fluidInputs(GTLiteMaterials.INSTANCE.getAcetaldehyde().getFluid(2000))).fluidInputs(Materials.Ammonia.getFluid(1000))).fluidOutputs(GTLiteMaterials.INSTANCE.getPyridine().getFluid(1000))).fluidOutputs(Materials.Water.getFluid(3000))).fluidOutputs(Materials.Hydrogen.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[4])).duration(240)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder()).notConsumable(OrePrefix.dust, Materials.Aluminium)).fluidInputs(GTLiteMaterials.INSTANCE.getPyridine().getFluid(2000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getBipyridine(), 20)).fluidOutputs(Materials.Hydrogen.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[4])).duration(200)).buildAndRegister();
    }

    private final void palladiumBisdibenzylidieneacetoneProcess() {
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).circuitMeta(2)).input(OrePrefix.dust, Materials.Palladium)).fluidInputs(Materials.Chlorine.getFluid(2000))).output(OrePrefix.dust, Materials.PalladiumRaw, 3);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[2])).duration(50)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).fluidInputs(GTLiteMaterials.INSTANCE.getBenzaldehyde().getFluid(2000))).fluidInputs(Materials.Acetone.getFluid(1000))).fluidOutputs(GTLiteMaterials.INSTANCE.getDibenzylideneacetone().getFluid(1000))).fluidOutputs(Materials.Water.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[3])).duration(100)).buildAndRegister();
        RecipeBuilder recipeBuilder3 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.PalladiumRaw, 6)).fluidInputs(GTLiteMaterials.INSTANCE.getDibenzylideneacetone().getFluid(3000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getPalladiumBisdibenzylidieneacetone(), 64)).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getPalladiumBisdibenzylidieneacetone(), 34)).fluidOutputs(Materials.Chlorine.getFluid(4000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VA[5])).duration(80)).buildAndRegister();
    }

    private final void dichlorocyclooctadieneplatiniumProcess() {
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder()).notConsumable(OrePrefix.dust, Materials.Nickel)).fluidInputs(Materials.Butadiene.getFluid(2000))).fluidOutputs(GTLiteMaterials.INSTANCE.getCyclooctadiene().getFluid(1000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[3])).duration(80)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(GTLiteMaterials.INSTANCE.getDicyclopentadiene().getFluid(100))).fluidOutputs(GTLiteMaterials.INSTANCE.getCyclooctadiene().getFluid(100));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[3])).duration(12)).buildAndRegister();
        RecipeBuilder recipeBuilder3 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getMalonicAcid(), 11)).fluidInputs(Materials.Isoprene.getFluid(1000))).fluidOutputs(GTLiteMaterials.INSTANCE.getCyclooctadiene().getFluid(1000))).fluidOutputs(Materials.Oxygen.getFluid(4000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VA[4])).duration(60)).buildAndRegister();
        RecipeBuilder recipeBuilder4 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.CRYOGENIC_REACTOR_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Platinum)).fluidInputs(Materials.HydrochloricAcid.getFluid(2000))).fluidInputs(Materials.Chlorine.getFluid(4000))).fluidOutputs(GTLiteMaterials.INSTANCE.getHexachloroplatinicAcid().getFluid(1000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder4, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder4, GTValues.VA[2])).duration(150)).buildAndRegister();
        RecipeBuilder recipeBuilder5 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Potassium, 2)).fluidInputs(GTLiteMaterials.INSTANCE.getHexachloroplatinicAcid().getFluid(1000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getPotassiumTetrachloroplatinate(), 7)).fluidOutputs(Materials.HydrochloricAcid.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder5, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder5, GTValues.VA[3])).duration(300)).buildAndRegister();
        RecipeBuilder recipeBuilder6 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getPotassiumTetrachloroplatinate(), 7)).fluidInputs(GTLiteMaterials.INSTANCE.getCyclooctadiene().getFluid(1000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getDichlorocyclooctadieneplatinium(), 23)).output(OrePrefix.dust, Materials.RockSalt, 4);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder6, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder6, GTValues.VA[3])).duration(360)).buildAndRegister();
    }

    private final void cppProcess() {
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.CRYOGENIC_REACTOR_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Biphenyl, 22)).input(OrePrefix.dust, Materials.Iodine, 2)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getAmmoniumSulfate(), 17)).fluidInputs(Materials.SulfuricAcid.getFluid(1000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getDiiodobiphenyl(), 22)).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getAmmoniumPersulfate(), 20)).fluidOutputs(Materials.Hydrogen.getFluid(4000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[3])).duration(260)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getAmmoniumPersulfate(), 20)).fluidInputs(Materials.Hydrogen.getFluid(2000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getAmmoniumSulfate(), 17)).fluidOutputs(Materials.SulfuricAcid.getFluid(1000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[2])).duration(130)).buildAndRegister();
        RecipeBuilder recipeBuilder3 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).notConsumable(OrePrefix.dust, GTLiteMaterials.INSTANCE.getHRAMagnesium())).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getTinDichloride(), 3)).fluidInputs(Materials.Methane.getFluid(3000))).fluidInputs(Materials.Oxygen.getFluid(1000))).fluidOutputs(GTLiteMaterials.INSTANCE.getTrimethyltinChloride().getFluid(1000))).fluidOutputs(Materials.DilutedHydrochloricAcid.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VA[4])).duration(130)).buildAndRegister();
        RecipeBuilder recipeBuilder4 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).circuitMeta(1)).input(OrePrefix.dust, Materials.Silver)).fluidInputs(Materials.Chlorine.getFluid(1000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverChloride(), 2);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder4, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder4, GTValues.VA[2])).duration(60)).buildAndRegister();
        RecipeBuilder recipeBuilder5 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverOxide(), 9)).fluidInputs(GTLiteMaterials.INSTANCE.getBoronTrifluoride().getFluid(8000))).notConsumable(Materials.Benzene.getFluid(1))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverTetrafluoroborate(), 6)).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getBoronTrioxide(), 5);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder5, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder5, GTValues.VA[5])).duration(650)).buildAndRegister();
        RecipeBuilder recipeBuilder6 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).notConsumable(OrePrefix.dust, Materials.SodiumHydroxide)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverChloride(), 4)).fluidInputs(Materials.Water.getFluid(1000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverOxide(), 3)).fluidOutputs(Materials.HydrochloricAcid.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder6, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder6, GTValues.VA[3])).duration(180)).buildAndRegister();
        RecipeBuilder recipeBuilder7 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.CHEMICAL_PLANT_RECIPES.recipeBuilder()).notConsumable(OrePrefix.dust, GTLiteMaterials.INSTANCE.getBipyridine())).notConsumable(OrePrefix.dust, GTLiteMaterials.INSTANCE.getPalladiumBisdibenzylidieneacetone())).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getDichlorocyclooctadieneplatinium(), 46)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getDiiodobiphenyl(), 44)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverTetrafluoroborate(), 24)).input(OrePrefix.dust, Materials.Carbon, 8)).notConsumable(GTLiteMaterials.INSTANCE.getResorcinol().getFluid(1))).notConsumable(GTLiteMaterials.INSTANCE.getButyllithium().getFluid(1))).fluidInputs(GTLiteMaterials.INSTANCE.getTrimethyltinChloride().getFluid(4000))).output(OrePrefix.dust, Materials.PalladiumRaw, 6)).output(OrePrefix.dust, Materials.Iodine, 8)).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getSilverChloride(), 8)).output(OrePrefix.dust, Materials.Tin, 4)).fluidOutputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(10000))).fluidOutputs(GTLiteMaterials.INSTANCE.getBoronTrifluoride().getFluid(4000))).fluidOutputs(GTLiteMaterials.INSTANCE.getOctene().getFluid(3000))).fluidOutputs(Materials.HydrofluoricAcid.getFluid(4000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder7, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder7, GTValues.VA[9])).duration(200)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        RecipeBuilder recipeBuilder8 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(GTLiteMaterials.INSTANCE.getOctene().getFluid(1000))).fluidOutputs(Materials.Butadiene.getFluid(2000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder8, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder8, GTValues.VA[1])).duration(50)).buildAndRegister();
        RecipeBuilder recipeBuilder9 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder()).circuitMeta(2)).fluidInputs(GTLiteMaterials.INSTANCE.getOctene().getFluid(1000))).fluidOutputs(GTLiteMaterials.INSTANCE.getCyclooctadiene().getFluid(1000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder9, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder9, GTValues.VA[1])).duration(50)).buildAndRegister();
    }

    private final void cntProcess() {
        RecipeBuilder recipeBuilder = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plate, Materials.Rhenium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(3000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(7000))).fluidInputs(Materials.Nitrogen.getPlasma(10000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getCarbonNanotube());
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[8]))).duration(100)).temperature(993).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plateDouble, Materials.Rhenium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(12000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(28000))).fluidInputs(Materials.Nitrogen.getPlasma(40000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getCarbonNanotube(), 4)).fluidOutputs(Materials.Ammonia.getFluid(40000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[10]))).duration(25)).temperature(993).buildAndRegister();
        RecipeBuilder recipeBuilder3 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getCarbonNanotube())).output(OrePrefix.dust, Materials.Carbon, 48);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VH[2])).duration((int)(Materials.Carbon.getMass() * (long)48))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder()).circuitMeta(1)).input(OrePrefix.plate, Materials.Graphene)).output(OrePrefix.foil, Materials.Graphene, 4)).EUt(24L)).duration((int)Materials.Graphene.getMass())).buildAndRegister();
        RecipeBuilder recipeBuilder4 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_EXTRUDER_FOIL)).input(OrePrefix.dust, Materials.Graphene)).output(OrePrefix.foil, Materials.Graphene, 4)).EUt(24L);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder4, (String)"EUt(...)");
        ((SimpleRecipeBuilder)RecipeBuilderExtKt.duration(recipeBuilder4, Materials.Graphene.getMass())).buildAndRegister();
        RecipeBuilder recipeBuilder5 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder()).input(OrePrefix.foil, Materials.Graphene, 24)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getCarbonNanotube())).output(GTLiteMetaItems.INSTANCE.getCARBON_ALLOTROPE_MIXTURE());
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder5, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder5, GTValues.VA[5])).duration(100)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        RecipeBuilder recipeBuilder6 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder()).input(GTLiteMetaItems.INSTANCE.getCARBON_ALLOTROPE_MIXTURE())).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getCarbonNanotube())).output(GTLiteMetaItems.INSTANCE.getGRAPHENE_ALIGNED_CNT(), 4);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder6, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder6, GTValues.VA[8])).duration(200)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        RecipeBuilder recipeBuilder7 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder()).input(GTLiteMetaItems.INSTANCE.getGRAPHENE_ALIGNED_CNT())).output(OrePrefix.dust, Materials.Carbon, 3)).fluidOutputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(1750));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder7, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder7, GTValues.VA[3])).duration(50)).buildAndRegister();
    }

    private final void seaborgiumCNTProcess() {
        RecipeBuilder recipeBuilder = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plate, Materials.Technetium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.dust, Materials.Seaborgium)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(3000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(7000))).fluidInputs(Materials.Nitrogen.getPlasma(10000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getSeaborgiumDopedCarbonNanotube());
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[9]))).duration(100)).temperature(2876).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plateDouble, Materials.Technetium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.dust, Materials.Seaborgium)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(12000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(28000))).fluidInputs(Materials.Nitrogen.getPlasma(40000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getSeaborgiumDopedCarbonNanotube(), 4)).fluidOutputs(Materials.Ammonia.getFluid(40000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[10]))).duration(25)).temperature(6364).buildAndRegister();
    }

    private final void lanthanumFullereneNTProcess() {
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder()).circuitMeta(2)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getGeodesicPolyarene(), 2)).input(OrePrefix.dust, Materials.Lanthanum, 2)).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getLanthanumFullereneMixture(), 4);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[6])).duration(40)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder()).notConsumable(OrePrefix.lens, GTLiteMaterials.INSTANCE.getMagnetoResonatic())).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getLanthanumFullereneMixture(), 4)).fluidInputs(Materials.Nitrogen.getFluid(20000))).output(OrePrefix.dust, GTLiteMaterials.INSTANCE.getLanthanumEmbeddedFullerene(), 4)).fluidOutputs(Materials.Ammonia.getFluid(20000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[9])).duration(320)).cleanroom(CleanroomType.CLEANROOM)).buildAndRegister();
        RecipeBuilder recipeBuilder3 = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plate, Materials.Bohrium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getLanthanumEmbeddedFullerene(), 2)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(3000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(7000))).fluidInputs(Materials.Nitrogen.getPlasma(10000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getLanthanumFullereneNanotube());
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"output(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VA[10]))).duration(100)).temperature(1986).buildAndRegister();
        RecipeBuilder recipeBuilder4 = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plateDouble, Materials.Bohrium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.dust, GTLiteMaterials.INSTANCE.getLanthanumEmbeddedFullerene(), 8)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(12000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(28000))).fluidInputs(Materials.Nitrogen.getPlasma(40000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getLanthanumFullereneNanotube(), 4)).fluidOutputs(Materials.Ammonia.getFluid(40000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder4, (String)"fluidOutputs(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder4, GTValues.VA[11]))).duration(25)).temperature(7944).buildAndRegister();
    }

    private final void neutroniumCNTProcess() {
        RecipeBuilder recipeBuilder = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plate, Materials.Moscovium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.dust, Materials.Neutronium)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(3000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(7000))).fluidInputs(Materials.Nitrogen.getPlasma(10000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getNeutroniumDopedCarbonNanotube());
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[12]))).duration(100)).temperature(3302).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)GTLiteRecipeMaps.PLASMA_CVD_RECIPES.recipeBuilder()).notConsumable(OrePrefix.plateDouble, Materials.Moscovium)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.dust, Materials.Neutronium)).fluidInputs(GTLiteMaterials.INSTANCE.getAcetylene().getFluid(12000))).fluidInputs(GTLiteMaterials.INSTANCE.getCycloparaphenylene().getFluid(28000))).fluidInputs(Materials.Nitrogen.getPlasma(40000))).output(OrePrefix.ingot, GTLiteMaterials.INSTANCE.getNeutroniumDopedCarbonNanotube(), 4)).fluidOutputs(Materials.Ammonia.getFluid(40000));
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
        ((NoCoilTemperatureRecipeBuilder)((NoCoilTemperatureRecipeBuilder)((Object)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[13]))).duration(25)).temperature(8208).buildAndRegister();
    }
}

