/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.core.sound;

import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.sound.SoundManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoundManagerImpl
implements SoundManager {
    private static final SoundManagerImpl INSTANCE = new SoundManagerImpl();
    private final Object2ObjectMap<BlockPos, ISound> sounds = new Object2ObjectOpenHashMap();

    private SoundManagerImpl() {
    }

    public static SoundManagerImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public SoundEvent registerSound(String containerName, String soundName) {
        ResourceLocation location = new ResourceLocation(containerName, soundName);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(location);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }

    @Override
    public SoundEvent registerSound(String soundName) {
        String containerID = GTLiteAPI.moduleManager.getLoadedContainer().getId();
        if (containerID == null) {
            containerID = "gtlitecore";
        }
        return this.registerSound(containerID, soundName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound startTileSound(ResourceLocation soundName, float volume, BlockPos pos) {
        ISound sound = (ISound)this.sounds.get((Object)pos);
        if (sound == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c(sound)) {
            sound = new PositionedSoundRecord(soundName, SoundCategory.BLOCKS, volume, 1.0f, true, 0, ISound.AttenuationType.LINEAR, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
            this.sounds.put((Object)pos, (Object)sound);
            Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
        }
        return sound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void stopTileSound(BlockPos pos) {
        ISound sound = (ISound)this.sounds.get((Object)pos);
        if (sound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(sound);
            this.sounds.remove((Object)pos);
        }
    }
}

