/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.core.network;

import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.module.ModuleStage;
import gregtechlite.gtlitecore.api.network.ClientExecutor;
import gregtechlite.gtlitecore.api.network.NetworkHandler;
import gregtechlite.gtlitecore.api.network.NetworkPacket;
import gregtechlite.gtlitecore.api.network.ServerExecutor;
import gregtechlite.gtlitecore.core.CoreModule;
import gregtechlite.gtlitecore.core.network.PacketHandler;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class NetworkHandlerImpl
implements NetworkHandler {
    private static final NetworkHandlerImpl INSTANCE = new NetworkHandlerImpl();
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("gtlitecore");
    private final PacketHandler packetHandler;

    private NetworkHandlerImpl() {
        this.channel.register((Object)this);
        this.packetHandler = PacketHandler.getInstance();
    }

    public static NetworkHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerPacket(Class<? extends NetworkPacket> packetClass) {
        if (GTLiteAPI.moduleManager.hasPassedStage(ModuleStage.PRE_INIT)) {
            CoreModule.logger.error("Could not register packet {} as packet registration has ended!", (Object)packetClass.getName());
            return;
        }
        boolean hasServerExecutor = ServerExecutor.class.isAssignableFrom(packetClass);
        boolean hasClientExecutor = ClientExecutor.class.isAssignableFrom(packetClass);
        if (hasServerExecutor && hasClientExecutor) {
            CoreModule.logger.error("Could not register packet {}, as it is both a Server and Client executor! Only one allowed. Skipping...", (Object)packetClass.getName());
            return;
        }
        if (!hasServerExecutor && !hasClientExecutor) {
            CoreModule.logger.error("Could not register packet {}, as it does not have an executor! Must have either IServerExecutor OR IClientExecutor. Skipping...", (Object)packetClass.getName());
            return;
        }
        this.packetHandler.registerPacket(packetClass);
    }

    @Override
    public void sendToAll(NetworkPacket packet) {
        this.channel.sendToAll(this.toFMLPacket(packet));
    }

    @Override
    public void sendTo(NetworkPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(this.toFMLPacket(packet), player);
    }

    @Override
    public void sendToAllAround(NetworkPacket packet, NetworkRegistry.TargetPoint point) {
        this.channel.sendToAllAround(this.toFMLPacket(packet), point);
    }

    @Override
    public void sendToAllTracking(NetworkPacket packet, NetworkRegistry.TargetPoint point) {
        this.channel.sendToAllTracking(this.toFMLPacket(packet), point);
    }

    @Override
    public void sendToAllTracking(NetworkPacket packet, Entity entity) {
        this.channel.sendToAllTracking(this.toFMLPacket(packet), entity);
    }

    @Override
    public void sendToDimension(NetworkPacket packet, int dimensionId) {
        this.channel.sendToDimension(this.toFMLPacket(packet), dimensionId);
    }

    @Override
    public void sendToServer(NetworkPacket packet) {
        this.channel.sendToServer(this.toFMLPacket(packet));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(@NotNull FMLNetworkEvent.ClientCustomPacketEvent event) throws Exception {
        NetworkPacket packet = this.toGTPacket(event.getPacket());
        if (ClientExecutor.class.isAssignableFrom(packet.getClass())) {
            ClientExecutor executor = (ClientExecutor)((Object)packet);
            NetHandlerPlayClient handler = (NetHandlerPlayClient)event.getHandler();
            IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
            if (threadListener.func_152345_ab()) {
                executor.executeClient(handler);
            } else {
                threadListener.func_152344_a(() -> executor.executeClient(handler));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FMLNetworkEvent.ServerCustomPacketEvent event) throws Exception {
        NetworkPacket packet = this.toGTPacket(event.getPacket());
        if (ServerExecutor.class.isAssignableFrom(packet.getClass())) {
            ServerExecutor executor = (ServerExecutor)((Object)packet);
            NetHandlerPlayServer handler = (NetHandlerPlayServer)event.getHandler();
            IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
            if (threadListener.func_152345_ab()) {
                executor.executeServer(handler);
            } else {
                threadListener.func_152344_a(() -> executor.executeServer(handler));
            }
        }
    }

    @NotNull
    private FMLProxyPacket toFMLPacket(@NotNull NetworkPacket packet) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_150787_b(this.packetHandler.getPacketId(packet.getClass()));
        packet.encode(buf);
        return new FMLProxyPacket(buf, "gtlitecore");
    }

    @NotNull
    private NetworkPacket toGTPacket(@NotNull FMLProxyPacket proxyPacket) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        PacketBuffer payload = (PacketBuffer)proxyPacket.payload();
        Class<? extends NetworkPacket> clazz = this.packetHandler.getPacketClass(payload.func_150792_a());
        NetworkPacket packet = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        packet.decode(payload);
        if (payload.readableBytes() != 0) {
            GTLiteLog.logger.error("NetworkHandler failed to finish reading packet with class {} and {} bytes remaining", (Object)clazz.getName(), (Object)payload.readableBytes());
        }
        return packet;
    }
}

