/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.core.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.morphismmc.morphismlib.util.SidedLogger;
import gregtechlite.gtlitecore.api.module.CustomModule;
import gregtechlite.gtlitecore.api.module.CustomModuleContainer;
import gregtechlite.gtlitecore.api.module.Module;
import gregtechlite.gtlitecore.api.module.ModuleContainer;
import gregtechlite.gtlitecore.api.module.ModuleManager;
import gregtechlite.gtlitecore.api.module.ModuleStage;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ModuleManagerImpl
implements ModuleManager {
    public static final ModuleManagerImpl instance = new ModuleManagerImpl();
    private final Logger logger = new SidedLogger("gtlitecore-module-loader");
    private static final String MODULE_CFG_FILE_NAME = "modules.cfg";
    private static final String MODULE_CFG_CATEGORY_NAME = "modules";
    private static File configFolder;
    private Map<String, CustomModuleContainer> containers = new LinkedHashMap<String, CustomModuleContainer>();
    private final Map<ResourceLocation, CustomModule> sortedModules = new LinkedHashMap<ResourceLocation, CustomModule>();
    private final Set<CustomModule> loadedModules = new LinkedHashSet<CustomModule>();
    private CustomModuleContainer currentContainer;
    private ModuleStage currentStage = ModuleStage.C_SETUP;
    private Configuration config;

    public ModuleManagerImpl getInstance() {
        return instance;
    }

    @Override
    public boolean isModuleEnabled(@NotNull ResourceLocation namespace) {
        return this.sortedModules.containsKey(namespace);
    }

    public boolean isModuleEnabled(@NotNull CustomModule module) {
        Module annotation = module.getClass().getAnnotation(Module.class);
        String comment = this.getComment(module);
        String propertyKey = annotation.containerId() + ":" + annotation.moduleId();
        Property property = this.getConfiguration().get(MODULE_CFG_CATEGORY_NAME, propertyKey, true, comment);
        return property.getBoolean();
    }

    @Override
    public CustomModuleContainer getLoadedContainer() {
        return this.currentContainer;
    }

    @Override
    public ModuleStage getStage() {
        return this.currentStage;
    }

    @Override
    public boolean hasPassedStage(@NotNull ModuleStage stage) {
        return this.currentStage.ordinal() > stage.ordinal();
    }

    @Override
    public void registerContainer(@NotNull CustomModuleContainer container) {
        if (this.currentStage != ModuleStage.C_SETUP) {
            this.logger.error("Failed to register ModuleContainer '{}', as Module loading has already begun", (Object)container);
            return;
        }
        Preconditions.checkNotNull((Object)container);
        this.containers.put(container.getId(), container);
    }

    public void setup(@NotNull ASMDataTable dataTable, @NotNull File configDir) {
        this.discoverContainers(dataTable);
        this.containers = (Map)this.containers.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, Object2ReferenceLinkedOpenHashMap::new));
        this.currentStage = ModuleStage.M_SETUP;
        configFolder = new File(configDir, "gtlitecore");
        Map<String, List<CustomModule>> modules = this.getModules(dataTable);
        this.configureModules(modules);
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Registering Event Handlers");
            for (Class<?> eventClass : module.getEventBusSubscribers()) {
                MinecraftForge.EVENT_BUS.register(eventClass);
            }
            for (Class<?> terrainGenClass : module.getTerrainGenBusSubscribers()) {
                MinecraftForge.TERRAIN_GEN_BUS.register(terrainGenClass);
            }
            for (Class<?> oreGenClass : module.getOreGenBusSubscribers()) {
                MinecraftForge.ORE_GEN_BUS.register(oreGenClass);
            }
        }
        this.currentContainer = null;
    }

    public void onConstruction(@NotNull FMLConstructionEvent event) {
        this.currentStage = ModuleStage.CONSTRUCTION;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Construction start");
            module.construction(event);
            module.getLogger().debug("Construction complete");
        }
    }

    public void onPreInit(@NotNull FMLPreInitializationEvent event) {
        this.currentStage = ModuleStage.PRE_INIT;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Registering packets");
            module.registerPackets();
        }
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Pre-Init start");
            module.preInit(event);
            module.getLogger().debug("Pre-Init complete");
        }
    }

    public void onInit(@NotNull FMLInitializationEvent event) {
        this.currentStage = ModuleStage.INIT;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Init start");
            module.init(event);
            module.getLogger().debug("Init complete");
        }
    }

    public void onPostInit(@NotNull FMLPostInitializationEvent event) {
        this.currentStage = ModuleStage.POST_INIT;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Post-Init start");
            module.postInit(event);
            module.getLogger().debug("Post-Init complete");
        }
    }

    public void onLoadComplete(@NotNull FMLLoadCompleteEvent event) {
        this.currentStage = ModuleStage.LOAD_COMPLETE;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Load Complete start");
            module.loadComplete(event);
            module.getLogger().debug("Load Complete complete");
        }
    }

    public void onServerAboutToStart(@NotNull FMLServerAboutToStartEvent event) {
        this.currentStage = ModuleStage.SERVER_ABOUT_TO_START;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Server About To Start start");
            module.serverAboutToStart(event);
            module.getLogger().debug("Server About To Start complete");
        }
    }

    public void onServerStarting(@NotNull FMLServerStartingEvent event) {
        this.currentStage = ModuleStage.SERVER_STARTING;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Server Starting start");
            module.serverStarting(event);
            module.getLogger().debug("Server Starting complete");
        }
    }

    public void onServerStarted(@NotNull FMLServerStartedEvent event) {
        this.currentStage = ModuleStage.SERVER_STARTED;
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.getLogger().debug("Server Started start");
            module.serverStarted(event);
            module.getLogger().debug("Server Started complete");
        }
    }

    public void onServerStopping(@NotNull FMLServerStoppingEvent event) {
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.serverStopping(event);
        }
    }

    public void onServerStopped(@NotNull FMLServerStoppedEvent event) {
        for (CustomModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManagerImpl.getContainerId(module));
            module.serverStopped(event);
        }
    }

    public void processIMC(@Unmodifiable @NotNull ImmutableList<// Could not load outer class - annotation placement on inner may be incorrect
    FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            for (CustomModule module : this.loadedModules) {
                if (module.processIMC(message)) break;
            }
        }
    }

    private String getComment(@NotNull CustomModule module) {
        String[] modDependencies;
        Module annotation = module.getClass().getAnnotation(Module.class);
        String comment = annotation.descriptions();
        Set<ResourceLocation> dependencies = module.getDependencyUids();
        if (!dependencies.isEmpty()) {
            Iterator<ResourceLocation> iterator = dependencies.iterator();
            StringBuilder stringBuilder = new StringBuilder(comment);
            stringBuilder.append("\n");
            stringBuilder.append("Module Dependencies: [ ");
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ").append(iterator.next());
            }
            stringBuilder.append(" ] ");
            comment = stringBuilder.toString();
        }
        if ((modDependencies = annotation.modDependencies()) != null && modDependencies.length > 0) {
            Iterator iterator = Arrays.stream(modDependencies).iterator();
            StringBuilder stringBuilder = new StringBuilder(comment);
            stringBuilder.append("\n");
            stringBuilder.append("Mod Dependencies: [ ");
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ").append((String)iterator.next());
            }
            stringBuilder.append(" ]");
            comment = stringBuilder.toString();
        }
        return comment;
    }

    @NotNull
    private Configuration getConfiguration() {
        if (this.config == null) {
            this.config = new Configuration(new File(configFolder, MODULE_CFG_FILE_NAME));
        }
        return this.config;
    }

    private void discoverContainers(@NotNull ASMDataTable dataTable) {
        Set dataSet = dataTable.getAll(ModuleContainer.class.getCanonicalName());
        for (ASMDataTable.ASMData data : dataSet) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (CustomModuleContainer.class.isAssignableFrom(clazz)) {
                    this.registerContainer((CustomModuleContainer)clazz.newInstance());
                    continue;
                }
                this.logger.error("Module Container class '{}' is not an instanceof correspondenced interface", (Object)clazz.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                this.logger.error("Could not initialize Module Container '{}'", (Object)data.getClassName(), (Object)exception);
            }
        }
    }

    @NotNull
    private static String getContainerId(@NotNull CustomModule module) {
        Module annotation = module.getClass().getAnnotation(Module.class);
        return annotation.containerId();
    }

    private void configureModules(Map<String, List<CustomModule>> modules) {
        CustomModule module;
        Iterator iterator;
        boolean changed;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        ObjectLinkedOpenHashSet toLoad = new ObjectLinkedOpenHashSet();
        ReferenceLinkedOpenHashSet modulesToLoad = new ReferenceLinkedOpenHashSet();
        Configuration config = this.getConfiguration();
        config.load();
        config.addCustomCategoryComment(MODULE_CFG_CATEGORY_NAME, "Module configuration file. Can individually enable/disable modules from the mod and its addons");
        for (CustomModuleContainer container : this.containers.values()) {
            String containerId = container.getId();
            List<CustomModule> containerModules = modules.get(containerId);
            CustomModule coreModule = ModuleManagerImpl.getCoreModule(containerModules);
            if (coreModule == null) {
                throw new IllegalStateException("Could not find Core Module for Module Container " + containerId);
            }
            containerModules.remove(coreModule);
            containerModules.add(0, coreModule);
            Iterator<CustomModule> iterator2 = containerModules.iterator();
            while (iterator2.hasNext()) {
                CustomModule module2 = iterator2.next();
                if (!this.isModuleEnabled(module2)) {
                    iterator2.remove();
                    this.logger.debug("Module disabled: {}", (Object)module2);
                    continue;
                }
                Module annotation = module2.getClass().getAnnotation(Module.class);
                toLoad.add(new ResourceLocation(containerId, annotation.moduleId()));
                modulesToLoad.add(module2);
            }
        }
        do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (CustomModule)iterator.next();
                Set<ResourceLocation> dependencies = module.getDependencyUids();
                if (toLoad.containsAll(dependencies)) continue;
                iterator.remove();
                changed = true;
                Module annotation = module.getClass().getAnnotation(Module.class);
                String moduleId = annotation.moduleId();
                toLoad.remove(new ResourceLocation(moduleId));
                this.logger.info("Module '{}' is missing at least one of Module dependencies: '{}', skipping loading...", (Object)moduleId, dependencies);
            }
        } while (changed);
        block4: do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (CustomModule)iterator.next();
                if (!this.sortedModules.keySet().containsAll(module.getDependencyUids())) continue;
                iterator.remove();
                Module annotation = module.getClass().getAnnotation(Module.class);
                this.sortedModules.put(new ResourceLocation(annotation.containerId(), annotation.moduleId()), module);
                changed = true;
                continue block4;
            }
        } while (changed);
        this.loadedModules.addAll(this.sortedModules.values());
        if (config.hasChanged()) {
            config.save();
        }
        Locale.setDefault(locale);
    }

    @Nullable
    private static CustomModule getCoreModule(@NotNull List<CustomModule> modules) {
        for (CustomModule module : modules) {
            Module annotation = module.getClass().getAnnotation(Module.class);
            if (!annotation.isCore()) continue;
            return module;
        }
        return null;
    }

    @NotNull
    private List<CustomModule> getInstances(@NotNull ASMDataTable dataTable) {
        Set dataSet = dataTable.getAll(Module.class.getCanonicalName());
        ArrayList<CustomModule> instances = new ArrayList<CustomModule>();
        for (ASMDataTable.ASMData data : dataSet) {
            String moduleId = (String)data.getAnnotationInfo().get("moduleId");
            List modDependencies = (List)data.getAnnotationInfo().get("modDependencies");
            if (modDependencies == null || modDependencies.stream().allMatch(Loader::isModLoaded)) {
                try {
                    Class<?> clazz = Class.forName(data.getClassName());
                    if (CustomModule.class.isAssignableFrom(clazz)) {
                        instances.add((CustomModule)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        continue;
                    }
                    this.logger.error("Module of class '{}' with id '{}' is not an instanceof Custom Module", (Object)clazz.getName(), (Object)moduleId);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                    this.logger.error("Could not initialize Module '{}'", (Object)moduleId, (Object)exception);
                }
                continue;
            }
            this.logger.info("Module '{}' is missing at least one of mod dependencies: '{}', skipping loading...", (Object)moduleId, (Object)modDependencies);
        }
        return instances.stream().sorted(Comparator.comparing(module -> module.getClass().getAnnotation(Module.class), Comparator.comparing(Module::containerId).thenComparing(Module::moduleId))).collect(Collectors.toList());
    }

    @NotNull
    private Map<String, List<CustomModule>> getModules(@NotNull ASMDataTable dataTable) {
        List<CustomModule> instances = this.getInstances(dataTable);
        Object2ReferenceLinkedOpenHashMap modules = new Object2ReferenceLinkedOpenHashMap();
        for (CustomModule module : instances) {
            Module annotation = module.getClass().getAnnotation(Module.class);
            modules.computeIfAbsent(annotation.containerId(), k -> new ArrayList()).add(module);
        }
        return modules;
    }
}

