/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.core.advancement.trigger;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import gregtechlite.gtlitecore.GTLiteMod;
import gregtechlite.gtlitecore.api.advancement.AdvancementCriterion;
import gregtechlite.gtlitecore.api.advancement.AdvancementTrigger;
import gregtechlite.gtlitecore.core.advancement.listener.AdvancementListeners;
import java.util.Map;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AdvancementTriggerImpl<T extends AdvancementCriterion>
implements AdvancementTrigger<T> {
    private final ResourceLocation id;
    private final T criterion;
    private final Map<PlayerAdvancements, AdvancementListeners<T>> listeners = Maps.newHashMap();

    public AdvancementTriggerImpl(String name, @NotNull T criterion) {
        this.id = GTLiteMod.id(name);
        this.criterion = criterion;
    }

    public void func_192165_a(@NotNull PlayerAdvancements advancementsIn, @NotNull ICriterionTrigger.Listener<T> listener) {
        AdvancementListeners<T> advancementListener = this.listeners.get(advancementsIn);
        if (advancementListener == null) {
            advancementListener = new AdvancementListeners(advancementsIn);
            this.listeners.put(advancementsIn, advancementListener);
        }
        advancementListener.add(listener);
    }

    public void func_192164_b(@NotNull PlayerAdvancements advancementsIn, @NotNull ICriterionTrigger.Listener<T> listener) {
        AdvancementListeners<T> advancementListener = this.listeners.get(advancementsIn);
        if (advancementListener != null) {
            advancementListener.remove(listener);
            if (advancementListener.isEmpty()) {
                this.listeners.remove(advancementsIn);
            }
        }
    }

    public void func_192167_a(@NotNull PlayerAdvancements advancementsIn) {
        this.listeners.remove(advancementsIn);
    }

    @NotNull
    public T deserializeInstance(@NotNull JsonObject object, @NotNull JsonDeserializationContext context) {
        return this.criterion;
    }

    @Override
    public void trigger(EntityPlayerMP player) {
        AdvancementListeners<T> listener = this.listeners.get(player.func_192039_O());
        if (listener != null) {
            listener.trigger(player);
        }
    }

    @NotNull
    public ResourceLocation func_192163_a() {
        return this.id;
    }
}

