/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.core;

import net.minecraftforge.common.config.Config;

@Config(modid="gtlitecore", name="gtlitecore/gtlitecore")
public class GTLiteConfigHolder {
    @Config.Comment(value={"Config options for Mod Compatibility features"})
    @Config.Name(value="Compatibility Options")
    @Config.RequiresMcRestart
    public static CompatibilityOptions compat = new CompatibilityOptions();
    @Config.Comment(value={"Config options for GregTech Lite Machines, Pipes, Cables, and Electric Items"})
    @Config.Name(value="Machine Options")
    @Config.RequiresMcRestart
    public static MachineOptions machine = new MachineOptions();
    @Config.Comment(value={"Config options for GregTech Lite, GregTech and Vanilla Recipes"})
    @Config.Name(value="Recipe Options")
    @Config.RequiresMcRestart
    public static RecipeOptions recipe = new RecipeOptions();
    @Config.Comment(value={"Config options for World Generation features"})
    @Config.Name(value="Worldgen Options")
    @Config.RequiresMcRestart
    public static WorldGenOptions worldgen = new WorldGenOptions();

    public static class WorldGenOptions {
        @Config.Comment(value={"Whether to disable all Addition Trees world generation.", "Default: false"})
        public boolean disableAdditionTreesGeneration = false;
        @Config.Comment(value={"Allowed to add Additional Items as loot in various structures.", "Default: true"})
        public boolean addLoot = true;
    }

    public static class RecipeOptions {
    }

    public static class MachineOptions {
        @Config.Comment(value={"Modifiable settings for Energy Infuser, consists of maximum repaired damage, energy consumed and UU Matter consumed."})
        @Config.Name(value="Energy Infuser Options")
        public EnergyInfuser energyInfuser = new EnergyInfuser();

        public static class EnergyInfuser {
            @Config.Comment(value={"Maximum repaired durability of Energy Infuser during one working.", "Default: 1000"})
            @Config.Name(value="Maximum durability repair during one working")
            @Config.RangeInt(min=1)
            public int maxRepairedDamagePerWorking = 1000;
            @Config.Comment(value={"Energy consumed (GTEU) per one durability which be repaired in Energy Infuser", "Default: 1000"})
            @Config.Name(value="Energy consumed per one durability")
            @Config.RangeInt(min=1)
            public int energyConsumedPerDurability = 1000;
            @Config.Comment(value={"UU Matter consumed per one durability which be repaired in Energy Infuser", "Default: 1"})
            @Config.Name(value="UU Matter consumed per one durability")
            @Config.RangeInt(min=1)
            public int uuMatterConsumedPerDurability = 1;
        }
    }

    public static class CompatibilityOptions {
        @Config.Comment(value={"Config options regarding JustEnoughItems (JEI) mod"})
        @Config.Name(value="JEI Compat Options")
        public JustEnoughItemsCompatOptions jeiCompat = new JustEnoughItemsCompatOptions();
        @Config.Comment(value={"Config options regarding Applied Energistics 2 (AE2) mod"})
        @Config.Name(value="AE2 Compat Options")
        public AppliedEnergisticsCompatOptions ae2Compat = new AppliedEnergisticsCompatOptions();

        public static class AppliedEnergisticsCompatOptions {
            @Config.Comment(value={"Add Circuit Assembly Line (CAL) recipes for all AE2 processors.", "Default: true"})
            public boolean addProcessorCALRecipes = true;
        }

        public static class JustEnoughItemsCompatOptions {
            @Config.Comment(value={"Make the Font Renderer in all pages be scaleable, it is useful for some large digits.", "Default: true"})
            public boolean scaleableFontRenderer = true;
        }
    }
}

