/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.core;

import com.morphismmc.morphismlib.util.SidedLogger;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.module.CustomModule;
import gregtechlite.gtlitecore.api.module.Module;
import gregtechlite.gtlitecore.api.unification.ore.GTLiteStoneTypes;
import gregtechlite.gtlitecore.common.CommonProxy;
import gregtechlite.gtlitecore.common.EventHandlers;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.command.CommandMaterialComponent;
import gregtechlite.gtlitecore.common.cover.GTLiteCoverBehaviors;
import gregtechlite.gtlitecore.common.entity.GTLiteMetaEntities;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.item.GTLiteMetaOreDictItems;
import gregtechlite.gtlitecore.common.item.behavior.GTLiteBehaviors;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import gregtechlite.gtlitecore.core.GTLiteConfigModifier;
import gregtechlite.gtlitecore.core.advancement.AdvancementManagerImpl;
import gregtechlite.gtlitecore.core.advancement.AdvancementTriggers;
import gregtechlite.gtlitecore.core.command.CommandManagerImpl;
import gregtechlite.gtlitecore.core.network.NetworkHandlerImpl;
import gregtechlite.gtlitecore.core.sound.GTLiteSoundEvents;
import gregtechlite.gtlitecore.core.sound.SoundManagerImpl;
import gregtechlite.gtlitecore.loader.VanillaDropsLoader;
import gregtechlite.gtlitecore.loader.dungeon.DungeonLootLoader;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Module(moduleId="core", containerId="gtlitecore", name="GregTech Lite Core", isCore=true, descriptions="Core Module of GregTech Lite Core Mod.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Lgregtechlite/gtlitecore/core/CoreModule;", "Lgregtechlite/gtlitecore/api/module/CustomModule;", "<init>", "()V", "construction", "", "event", "Lnet/minecraftforge/fml/common/event/FMLConstructionEvent;", "preInit", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "init", "Lnet/minecraftforge/fml/common/event/FMLInitializationEvent;", "postInit", "Lnet/minecraftforge/fml/common/event/FMLPostInitializationEvent;", "loadComplete", "Lnet/minecraftforge/fml/common/event/FMLLoadCompleteEvent;", "serverStarting", "Lnet/minecraftforge/fml/common/event/FMLServerStartingEvent;", "serverStarted", "Lnet/minecraftforge/fml/common/event/FMLServerStartedEvent;", "serverStopping", "Lnet/minecraftforge/fml/common/event/FMLServerStoppingEvent;", "serverStopped", "Lnet/minecraftforge/fml/common/event/FMLServerStoppedEvent;", "registerPackets", "getLogger", "Lorg/apache/logging/log4j/Logger;", "Companion", "gtlitecore"})
public final class CoreModule
implements CustomModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Logger logger = (Logger)new SidedLogger("gtlitecore-api");
    @SidedProxy(clientSide="gregtechlite.gtlitecore.client.ClientProxy", serverSide="gregtechlite.gtlitecore.common.CommonProxy", modId="gtlitecore")
    public static CommonProxy proxy;

    public CoreModule() {
        GTLiteAPI.INSTANCE.setNetworkHandler(NetworkHandlerImpl.getInstance());
    }

    @Override
    public void construction(@NotNull FMLConstructionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getLogger().debug("Starting to construct EventHandlers of the mod");
        MinecraftForge.EVENT_BUS.register((Object)EventHandlers.INSTANCE);
        this.getLogger().debug("Modifying configurations of GregTech mod");
        GTLiteConfigModifier.INSTANCE.init();
        this.getLogger().debug("Adding custom CreativeTabs of the mod to GregTech machines");
        GTLiteMetaTileEntities.INSTANCE.preInit();
    }

    @Override
    public void preInit(@NotNull FMLPreInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getLogger().debug("Starting to construct Advancements and its AdvancementTriggers");
        GTLiteAPI.INSTANCE.setAdvancementManager(AdvancementManagerImpl.getInstance());
        AdvancementTriggers.INSTANCE.register();
        this.getLogger().debug("Loading SoundEvents and Sound files");
        GTLiteAPI.INSTANCE.setSoundManager(SoundManagerImpl.getInstance());
        GTLiteSoundEvents.INSTANCE.register();
        this.getLogger().debug("Loading all MetaItems and MetaOreDictItems");
        GTLiteMetaItems.INSTANCE.init();
        GTLiteMetaOreDictItems.init();
        this.getLogger().debug("Loading all MetaBlocks and MetaBlock Adapters");
        GTLiteBlocks.INSTANCE.init();
        GTLiteBlocks.setFireInfos();
        this.getLogger().debug("Adding custom StoneType of the mod to GregTech");
        GTLiteStoneTypes.INSTANCE.init();
        this.getLogger().debug("Loading BlockAttribute Contexts");
        GTLiteAPI.INSTANCE.init();
        this.getLogger().debug("Loading all MetaTileEntities and MetaEntities");
        GTLiteMetaTileEntities.init();
        GTLiteMetaEntities.INSTANCE.init();
        this.getLogger().debug("Starting to load Pre-Load contents by Proxies");
        Companion.getProxy().onPreInit();
    }

    @Override
    public void init(@NotNull FMLInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getLogger().debug("Adding the mod contents to vanilla Dungeon Looting Table");
        DungeonLootLoader.init();
        this.getLogger().debug("Adding Cover Behaviours to MetaItems");
        GTLiteCoverBehaviors.INSTANCE.init();
        this.getLogger().debug("Starting to load Load contents by Proxies");
        Companion.getProxy().onInit();
    }

    @Override
    public void postInit(@NotNull FMLPostInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getLogger().debug("Adding other Behaviours to MetaItems");
        GTLiteBehaviors.INSTANCE.addBehaviors();
        this.getLogger().debug("Adding the mod contents to vanilla Grass Drops Table");
        VanillaDropsLoader.addSeedDrops();
        this.getLogger().debug("Starting to load Post Load contents by Proxies");
        Companion.getProxy().onPostInit();
    }

    @Override
    public void loadComplete(@NotNull FMLLoadCompleteEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void serverStarting(@NotNull FMLServerStartingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getLogger().debug("Starting to construct Commands of the mod");
        CommandManagerImpl commandManager = CommandManagerImpl.getInstance();
        GTLiteAPI.INSTANCE.setCommandManager(commandManager);
        commandManager.registerServerCommand(event);
        GTLiteAPI.INSTANCE.getCommandManager().addCommand((ICommand)new CommandMaterialComponent());
    }

    @Override
    public void serverStarted(@NotNull FMLServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void serverStopping(@NotNull FMLServerStoppingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void serverStopped(@NotNull FMLServerStoppedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void registerPackets() {
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgregtechlite/gtlitecore/core/CoreModule$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "proxy", "Lgregtechlite/gtlitecore/common/CommonProxy;", "getProxy", "()Lgregtechlite/gtlitecore/common/CommonProxy;", "setProxy", "(Lgregtechlite/gtlitecore/common/CommonProxy;)V", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonProxy getProxy() {
            CommonProxy commonProxy = proxy;
            if (commonProxy != null) {
                return commonProxy;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"proxy");
            return null;
        }

        public final void setProxy(@NotNull CommonProxy commonProxy) {
            Intrinsics.checkNotNullParameter((Object)commonProxy, (String)"<set-?>");
            proxy = commonProxy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

