/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.BiomeCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112$\u0010\u0012\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\t0\u0013H\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014J\u001a\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J.\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\b\u0010\n\u001a\u0004\u0018\u00010 2\b\u0010\f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeRainbow;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "perlinScale", "", "getPerlinScale", "()D", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "getMinTrunkHeight", "random", "getMooreRadiusAtHeight", "trunkHeight", "getItemColor", "stack", "Lnet/minecraft/item/ItemStack;", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWorldGeneratorTreeRainbow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGeneratorTreeRainbow.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeRainbow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1863#2,2:81\n*S KotlinDebug\n*F\n+ 1 WorldGeneratorTreeRainbow.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeRainbow\n*L\n45#1:81,2\n*E\n"})
public final class WorldGeneratorTreeRainbow
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeRainbow() {
        super("rainbow", 9);
        List<GenerateCondition> list = this.getConditions();
        Biome biome = Biomes.field_76772_c;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"PLAINS");
        list.add(new BiomeCondition(biome, 5, 0.89));
        List<GenerateCondition> list2 = this.getConditions();
        Biome biome2 = Biomes.field_185441_Q;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"MUTATED_PLAINS");
        list2.add(new BiomeCondition(biome2, 5, 0.89));
        this.getConditions().add(new ClimateCondition(5, 0.5, 0.8, 0.4, 0.1));
    }

    @Override
    public double getPerlinScale() {
        return 0.05;
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos currentYBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        currentYBlockPos.func_189534_c(EnumFacing.UP, height - 3);
        for (int i = 0; i < 7; ++i) {
            int layerSize = this.getMooreRadiusAtHeight(i + height - 3, height);
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYBlockPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYBlockPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            Intrinsics.checkNotNull((Object)iterator);
            Iterable $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos leavesPos = (BlockPos)element$iv;
                boolean bl = false;
                BlockPos blockPos2 = leavesPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                if (Math.abs(blockPos2.func_177958_n() - currentYBlockPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYBlockPos.func_177952_p()) >= 6) continue;
                notifier.invoke((Object)worldIn, (Object)leavesPos, (Object)this.getPlacedLeaveState());
            }
            currentYBlockPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    public int getMinTrunkHeight(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return random.nextInt(3) + 6;
    }

    @Override
    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        if (height < trunkHeight - 3) {
            return 0;
        }
        if (height == trunkHeight - 3) {
            return 2;
        }
        if (height < trunkHeight + 3) {
            return 3;
        }
        return 2;
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 0x8F00FF;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        int[] nArray = new int[]{0xFF0000, 0xFF4000, 0xFF8000, 0xFFC000, 0xFFFF00, 0xC0FF00, 0x80FF00, 0x40FF00, 65280, 65344, 65408, 65472, 65535, 49407, 33023, 16639, 255, 0x4000FF, 0x8000FF, 0xC000FF, 0xFF00FF, 0xFF00C0, 0xFF0080, 0xFF0040};
        int[] colors = nArray;
        BlockPos blockPos2 = blockPos;
        Intrinsics.checkNotNull((Object)blockPos2);
        return colors[(Math.abs(blockPos2.func_177958_n()) + Math.abs(blockPos.func_177956_o()) + Math.abs(blockPos.func_177952_p())) % colors.length];
    }
}

