/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtech.api.GTValues;
import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.BiomeCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JN\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072$\u0010\u0010\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\t0\u0011H\u0014JP\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072$\u0010\u0010\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\t0\u0011H\u0014J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u001a\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J.\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\n\u001a\u0004\u0018\u00010 2\b\u0010\f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u0005H\u0016\u00a8\u0006!"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeOrange;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "getMinTrunkHeight", "", "random", "Ljava/util/Random;", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "rand", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "generateTrunk", "maxHeight", "getMooreRadiusAtHeight", "trunkHeight", "getFruitDrop", "Lnet/minecraft/item/ItemStack;", "chance", "getItemColor", "stack", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWorldGeneratorTreeOrange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGeneratorTreeOrange.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeOrange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1863#2,2:109\n*S KotlinDebug\n*F\n+ 1 WorldGeneratorTreeOrange.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeOrange\n*L\n51#1:109,2\n*E\n"})
public final class WorldGeneratorTreeOrange
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeOrange() {
        super("orange", 1);
        List<GenerateCondition> list = this.getConditions();
        Biome biome = Biomes.field_150588_X;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"SAVANNA");
        list.add(new BiomeCondition(biome, 3, 0.45));
        List<GenerateCondition> list2 = this.getConditions();
        Biome biome2 = Biomes.field_150587_Y;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"SAVANNA_PLATEAU");
        list2.add(new BiomeCondition(biome2, 6, 0.25));
        this.getConditions().add(new ClimateCondition(3, 1.2, 1.15, 0.0, 0.2));
    }

    @Override
    public int getMinTrunkHeight(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return 2 + random.nextInt(3);
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos currentYBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        currentYBlockPos.func_189536_c(EnumFacing.UP);
        int n = height + 1;
        for (int facingIndex = 0; facingIndex < n; ++facingIndex) {
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYBlockPos.func_177967_a(EnumFacing.NORTH, 2).func_177967_a(EnumFacing.WEST, 2), (BlockPos)currentYBlockPos.func_177967_a(EnumFacing.SOUTH, 2).func_177967_a(EnumFacing.EAST, 2));
            int sideFacingIndex = facingIndex;
            Intrinsics.checkNotNull((Object)iterator);
            Iterable $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos leavesPos = (BlockPos)element$iv;
                boolean bl = false;
                BlockPos blockPos2 = leavesPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                if (Math.abs(blockPos2.func_177958_n() - currentYBlockPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYBlockPos.func_177952_p()) >= 3) continue;
                if (sideFacingIndex >= height) {
                    if (Math.abs(leavesPos.func_177958_n() - currentYBlockPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYBlockPos.func_177952_p()) != 1 && rand.nextInt(2) != 0) continue;
                }
                notifier.invoke((Object)worldIn, (Object)leavesPos, (Object)this.getPlacedLeaveState());
            }
            currentYBlockPos.func_189536_c(EnumFacing.UP);
        }
        notifier.invoke((Object)worldIn, (Object)currentYBlockPos, (Object)this.getPlacedLeaveState());
    }

    @Override
    protected void generateTrunk(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int maxHeight, @Nullable Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos upNBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState iBlockState = this.getLogState();
            notifier.invoke((Object)worldIn, (Object)upNBlockPos, iBlockState != null ? iBlockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y) : null);
            if (height > 0) {
                Random random = rand;
                Intrinsics.checkNotNull((Object)random);
                EnumFacing randomFacing = EnumFacing.func_176731_b((int)random.nextInt(4));
                IBlockState iBlockState2 = this.getLogState();
                notifier.invoke((Object)worldIn, (Object)upNBlockPos.func_177972_a(randomFacing), iBlockState2 != null ? iBlockState2.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)randomFacing.func_176740_k())) : null);
            }
            upNBlockPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        if (height == 0) {
            return 0;
        }
        if (height < trunkHeight + 1) {
            return 1;
        }
        return 0;
    }

    @Override
    @Nullable
    public ItemStack getFruitDrop(int chance) {
        if (GTValues.RNG.nextInt(chance / 10) == 0) {
            return GTLiteMetaItems.INSTANCE.getORANGE().getStackForm(GTValues.RNG.nextInt(2) + 1);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 7784748;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        return 7784748;
    }
}

