/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtech.api.GTValues;
import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.BiomeCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014JP\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001a\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J.\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u001e2\b\u0010\b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u000bH\u0016\u00a8\u0006\u001f"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeOlive;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "generateTrunk", "maxHeight", "getMooreRadiusAtHeight", "trunkHeight", "getFruitDrop", "Lnet/minecraft/item/ItemStack;", "chance", "getItemColor", "stack", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWorldGeneratorTreeOlive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGeneratorTreeOlive.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeOlive\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1863#2,2:124\n*S KotlinDebug\n*F\n+ 1 WorldGeneratorTreeOlive.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeOlive\n*L\n52#1:124,2\n*E\n"})
public final class WorldGeneratorTreeOlive
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeOlive() {
        super("olive", 6);
        List<GenerateCondition> list = this.getConditions();
        Biome biome = Biomes.field_150583_P;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"BIRCH_FOREST");
        list.add(new BiomeCondition(biome, 5, 0.55));
        List<GenerateCondition> list2 = this.getConditions();
        Biome biome2 = Biomes.field_76767_f;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"FOREST");
        list2.add(new BiomeCondition(biome2, 2, 0.65));
        List<GenerateCondition> list3 = this.getConditions();
        Biome biome3 = Biomes.field_76772_c;
        Intrinsics.checkNotNullExpressionValue((Object)biome3, (String)"PLAINS");
        list3.add(new BiomeCondition(biome3, 1, 0.88));
        this.getConditions().add(new ClimateCondition(3, 1.5, 0.6, 0.6, 0.3));
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos currentBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        currentBlockPos.func_189534_c(EnumFacing.UP, height);
        for (int i = 25; i > 0; i -= rand.nextInt(8) + 13) {
            int layerSize = (int)Math.ceil(Math.sqrt(i));
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentBlockPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentBlockPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            int j = i;
            Intrinsics.checkNotNull((Object)iterator);
            Iterable $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos leavesPos = (BlockPos)element$iv;
                boolean bl = false;
                BlockPos blockPos2 = leavesPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                if (!((double)(Math.abs(blockPos2.func_177958_n() - currentBlockPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentBlockPos.func_177952_p())) <= Math.sqrt(j))) continue;
                notifier.invoke((Object)worldIn, (Object)leavesPos, (Object)this.getPlacedLeaveState());
            }
            currentBlockPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    protected void generateTrunk(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int maxHeight, @Nullable Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos upNBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        BlockPos.MutableBlockPos upNSplitBlockPos = BlockPosExtKt.copy((BlockPos)upNBlockPos);
        Random random = rand;
        Intrinsics.checkNotNull((Object)random);
        EnumFacing splitDirection = EnumFacing.func_176731_b((int)random.nextInt(4));
        int splittingHeight = maxHeight - 1 - rand.nextInt(3);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState iBlockState;
            IBlockState state = worldIn.func_180495_p((BlockPos)upNBlockPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, (BlockPos)upNBlockPos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, (BlockPos)upNBlockPos)) {
                iBlockState = this.getLogState();
                notifier.invoke((Object)worldIn, (Object)upNBlockPos, iBlockState != null ? iBlockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y) : null);
            }
            if (height == splittingHeight) {
                upNSplitBlockPos.func_189536_c(splitDirection);
            }
            if (height >= splittingHeight) {
                iBlockState = this.getLogState();
                notifier.invoke((Object)worldIn, (Object)upNSplitBlockPos, iBlockState != null ? iBlockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y) : null);
                if (rand.nextInt(2) == 0) {
                    upNSplitBlockPos.func_189536_c(splitDirection);
                }
            }
            upNBlockPos.func_189536_c(EnumFacing.UP);
            upNSplitBlockPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        if (height < trunkHeight - 3) {
            return 0;
        }
        if (height < trunkHeight) {
            return 4 - (trunkHeight - height);
        }
        return 0;
    }

    @Override
    @Nullable
    public ItemStack getFruitDrop(int chance) {
        if (GTValues.RNG.nextInt(chance / 15) == 0) {
            return GTLiteMetaItems.INSTANCE.getOLIVE().getStackForm(GTValues.RNG.nextInt(4) + 1);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 8556122;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        return 8556122;
    }
}

