/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtech.api.GTValues;
import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.BiomeCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J\u001a\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J.\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00182\b\u0010\b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u000bH\u0016\u00a8\u0006\u001b"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeNutmeg;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "getItemColor", "stack", "Lnet/minecraft/item/ItemStack;", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "getFruitDrop", "chance", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWorldGeneratorTreeNutmeg.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGeneratorTreeNutmeg.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeNutmeg\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1863#2,2:76\n*S KotlinDebug\n*F\n+ 1 WorldGeneratorTreeNutmeg.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeNutmeg\n*L\n48#1:76,2\n*E\n"})
public final class WorldGeneratorTreeNutmeg
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeNutmeg() {
        super("nutmeg", 7);
        List<GenerateCondition> list = this.getConditions();
        Biome biome = Biomes.field_76782_w;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"JUNGLE");
        list.add(new BiomeCondition(biome, 3, 0.3));
        this.getConditions().add(new ClimateCondition(3, 1.2, 0.85, 1.0, 0.3));
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos currentYBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        currentYBlockPos.func_189534_c(EnumFacing.UP, height - 2);
        for (double i = 3.0; i > 0.0; i -= rand.nextDouble() / (double)2 + 0.5) {
            int layerSize = (int)Math.ceil(i);
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYBlockPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYBlockPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            double j = i;
            Intrinsics.checkNotNull((Object)iterator);
            Iterable $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos leavesPos = (BlockPos)element$iv;
                boolean bl = false;
                BlockPos blockPos2 = leavesPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                if (!(Math.pow(Math.pow(Math.abs(blockPos2.func_177958_n() - currentYBlockPos.func_177958_n()), 2.0) + Math.pow(Math.abs(leavesPos.func_177952_p() - currentYBlockPos.func_177952_p()), 2.0), 0.5) <= j)) continue;
                notifier.invoke((Object)worldIn, (Object)leavesPos, (Object)this.getPlacedLeaveState());
            }
            currentYBlockPos.func_189536_c(EnumFacing.UP);
        }
        notifier.invoke((Object)worldIn, (Object)BlockPosExtKt.copy((BlockPos)blockPos).func_189534_c(EnumFacing.UP, height), (Object)this.getPlacedLeaveState());
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 7190054;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        return 7190054;
    }

    @Override
    @Nullable
    public ItemStack getFruitDrop(int chance) {
        if (GTValues.RNG.nextInt(chance / 10) == 0) {
            return GTLiteMetaItems.INSTANCE.getNUTMEG().getStackForm(GTValues.RNG.nextInt(2) + 1);
        }
        return ItemStack.field_190927_a;
    }
}

