/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtech.api.GTValues;
import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.BiomeCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001a\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J.\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u001a2\b\u0010\b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000bH\u0016\u00a8\u0006\u001b"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeLime;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "getFruitDrop", "Lnet/minecraft/item/ItemStack;", "chance", "getItemColor", "stack", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWorldGeneratorTreeLime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGeneratorTreeLime.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeLime\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1863#2,2:80\n*S KotlinDebug\n*F\n+ 1 WorldGeneratorTreeLime.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeLime\n*L\n48#1:80,2\n*E\n"})
public final class WorldGeneratorTreeLime
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeLime() {
        super("lime", 5);
        List<GenerateCondition> list = this.getConditions();
        Biome biome = Biomes.field_76782_w;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"JUNGLE");
        list.add(new BiomeCondition(biome, 3, 0.3));
        List<GenerateCondition> list2 = this.getConditions();
        Biome biome2 = Biomes.field_185447_Y;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"MUTATED_JUNGLE_EDGE");
        list2.add(new BiomeCondition(biome2, 4, 0.3));
        this.getConditions().add(new ClimateCondition(5, 1.2, 0.8, 0.85, 0.3));
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos currentYBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        currentYBlockPos.func_189534_c(EnumFacing.UP, height - 2);
        for (int i = 9; i > 0; i -= rand.nextInt(2) + 2) {
            int layerSize = (int)Math.ceil(Math.sqrt(i));
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYBlockPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYBlockPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            int j = i;
            Intrinsics.checkNotNull((Object)iterator);
            Iterable $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos leavesPos = (BlockPos)element$iv;
                boolean bl = false;
                BlockPos blockPos2 = leavesPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                if (!((double)(Math.abs(blockPos2.func_177958_n() - currentYBlockPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYBlockPos.func_177952_p())) <= Math.sqrt(j)) && (!((double)(Math.abs(leavesPos.func_177958_n() - currentYBlockPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYBlockPos.func_177952_p())) <= Math.sqrt(j) + 0.5) || rand.nextInt(2) != 0)) continue;
                notifier.invoke((Object)worldIn, (Object)leavesPos, (Object)this.getPlacedLeaveState());
            }
            currentYBlockPos.func_189536_c(EnumFacing.UP);
        }
        notifier.invoke((Object)worldIn, (Object)BlockPosExtKt.copy((BlockPos)blockPos).func_189534_c(EnumFacing.UP, height), (Object)this.getPlacedLeaveState());
    }

    @Override
    @Nullable
    public ItemStack getFruitDrop(int chance) {
        if (GTValues.RNG.nextInt(chance / 10) == 0) {
            return GTLiteMetaItems.INSTANCE.getLIME().getStackForm(GTValues.RNG.nextInt(2) + 1);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 4352001;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        return 4352001;
    }
}

