/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtech.api.GTValues;
import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001a\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J.\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u001a2\b\u0010\b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000bH\u0016\u00a8\u0006\u001b"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeCoconut;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "getFruitDrop", "Lnet/minecraft/item/ItemStack;", "chance", "getItemColor", "stack", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "gtlitecore"})
public final class WorldGeneratorTreeCoconut
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeCoconut() {
        super("coconut", 8);
        this.getConditions().add(new ClimateCondition(5, 1.5, 0.8, 0.9, 0.5));
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        int i;
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos blockPos2 = blockPos.func_177981_b(height - 1);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"up(...)");
        BlockPos.MutableBlockPos tBlockPos = BlockPosExtKt.copy(blockPos2);
        int tSideVariance = rand.nextInt(4);
        for (i = 0; i < 3; ++i) {
            tBlockPos.func_189536_c(EnumFacing.UP);
            notifier.invoke((Object)worldIn, (Object)tBlockPos, (Object)this.getPlacedLeaveState());
            switch (i) {
                case 1: 
                case 2: {
                    tBlockPos.func_189536_c(EnumFacing.func_176731_b((int)tSideVariance));
                    notifier.invoke((Object)worldIn, (Object)tBlockPos, (Object)this.getPlacedLeaveState());
                }
            }
        }
        tBlockPos.func_189536_c(EnumFacing.func_176731_b((int)tSideVariance));
        notifier.invoke((Object)worldIn, (Object)tBlockPos, (Object)this.getPlacedLeaveState());
        for (i = 0; i < 4; ++i) {
            int leafOffset = rand.nextInt(2);
            BlockPos blockPos3 = blockPos.func_177981_b(height - 2 + leafOffset);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"up(...)");
            BlockPos.MutableBlockPos sBlockPos = BlockPosExtKt.copy(blockPos3);
            int sSideVariance = rand.nextInt(2);
            for (int j = 0; j < 3; ++j) {
                sBlockPos.func_189536_c(EnumFacing.func_176731_b((int)i));
                notifier.invoke((Object)worldIn, (Object)sBlockPos, (Object)this.getPlacedLeaveState());
                if (j == 0) {
                    sBlockPos.func_189536_c(EnumFacing.UP);
                    notifier.invoke((Object)worldIn, (Object)sBlockPos, (Object)this.getPlacedLeaveState());
                }
                if (rand.nextInt(3) != 0) continue;
                if (sSideVariance == 0) {
                    sBlockPos.func_189536_c(EnumFacing.func_176731_b((int)i).func_176746_e());
                    notifier.invoke((Object)worldIn, (Object)sBlockPos, (Object)this.getPlacedLeaveState());
                    continue;
                }
                sBlockPos.func_189536_c(EnumFacing.func_176731_b((int)i).func_176735_f());
                notifier.invoke((Object)worldIn, (Object)sBlockPos, (Object)this.getPlacedLeaveState());
            }
        }
        for (i = 0; i < 4; ++i) {
            notifier.invoke((Object)worldIn, (Object)blockPos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)i)), (Object)this.getPlacedLeaveState());
            notifier.invoke((Object)worldIn, (Object)blockPos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)i)).func_177972_a(EnumFacing.func_176731_b((int)i).func_176746_e()), (Object)this.getPlacedLeaveState());
        }
    }

    @Override
    @Nullable
    public ItemStack getFruitDrop(int chance) {
        if (GTValues.RNG.nextInt(chance / 7) == 0) {
            return GTLiteMetaItems.INSTANCE.getCOCONUT().getStackForm(GTValues.RNG.nextInt(2));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 6651676;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        return 6651676;
    }
}

