/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.generator.AbstractWorldGenerator;
import gregtechlite.gtlitecore.api.worldgen.generator.CustomWorldGeneratorImpl;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.block.GTLiteLeaveBlock;
import gregtechlite.gtlitecore.common.block.GTLiteLogBlock;
import gregtechlite.gtlitecore.common.block.GTLiteSaplingBlock;
import gregtechlite.gtlitecore.common.worldgen.generator.custom.CustomWorldGeneratorTree;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeRegistry;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010&\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0005H&J.\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u000b2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010)\u001a\u00020\u0005H&JL\u00100\u001a\u0002012\b\u0010,\u001a\u0004\u0018\u0001022\b\u0010.\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u0001052$\u00106\u001a \u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020807H\u0016JN\u00109\u001a\u0002082\u0006\u0010,\u001a\u0002022\u0006\u0010.\u001a\u0002032\u0006\u0010:\u001a\u00020\u00052\u0006\u00104\u001a\u0002052$\u00106\u001a \u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020807H\u0014JP\u0010;\u001a\u0002082\u0006\u0010,\u001a\u0002022\u0006\u0010.\u001a\u0002032\u0006\u0010<\u001a\u00020\u00052\b\u00104\u001a\u0004\u0018\u0001052$\u00106\u001a \u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020807H\u0014J\u0006\u0010=\u001a\u000208J\u0016\u0010>\u001a\u0002012\u0006\u0010,\u001a\u0002022\u0006\u0010.\u001a\u00020/J\u0010\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020AH\u0004J \u0010B\u001a\u0002012\u0006\u0010,\u001a\u0002022\u0006\u0010.\u001a\u00020/2\u0006\u0010C\u001a\u00020\u0005H\u0004J\u0010\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u000205H\u0016J\u0018\u0010F\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0014J\u0012\u0010H\u001a\u0004\u0018\u00010(2\u0006\u0010I\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR(\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d8V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010#\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"\u00a8\u0006J"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "Lgregtechlite/gtlitecore/api/worldgen/generator/AbstractWorldGenerator;", "name", "", "seed", "", "<init>", "(Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "logState", "Lnet/minecraft/block/state/IBlockState;", "getLogState", "()Lnet/minecraft/block/state/IBlockState;", "setLogState", "(Lnet/minecraft/block/state/IBlockState;)V", "leaveState", "getLeaveState", "setLeaveState", "saplingState", "getSaplingState", "setSaplingState", "placedLeaveState", "getPlacedLeaveState", "placedSaplingBlock", "Lnet/minecraftforge/common/IPlantable;", "getPlacedSaplingBlock", "()Lnet/minecraftforge/common/IPlantable;", "value", "Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "innerGenerator", "getInnerGenerator", "()Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "setInnerGenerator", "(Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;)V", "outerGenerator", "getOuterGenerator", "setOuterGenerator", "getItemColor", "stack", "Lnet/minecraft/item/ItemStack;", "tintIndex", "getBlockColor", "blockState", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "generate", "", "Lnet/minecraft/world/World;", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "", "generateLeaves", "height", "generateTrunk", "maxHeight", "setupBlocks", "isReplaceable", "canGrowInto", "block", "Lnet/minecraft/block/Block;", "isSuitableLocation", "minHeight", "getMinTrunkHeight", "random", "getMooreRadiusAtHeight", "trunkHeight", "getFruitDrop", "chance", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWorldGeneratorTreeBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGeneratorTreeBase.kt\ngregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public abstract class WorldGeneratorTreeBase
extends AbstractWorldGenerator {
    @NotNull
    private final String name;
    private final int seed;
    @Nullable
    private IBlockState logState;
    @Nullable
    private IBlockState leaveState;
    @Nullable
    private IBlockState saplingState;

    public WorldGeneratorTreeBase(@NotNull String name, int seed) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(seed);
        this.name = name;
        this.seed = seed;
        WorldGeneratorTreeRegistry.INSTANCE.getGenerators().add(this);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final IBlockState getLogState() {
        return this.logState;
    }

    public final void setLogState(@Nullable IBlockState iBlockState) {
        this.logState = iBlockState;
    }

    @Nullable
    public final IBlockState getLeaveState() {
        return this.leaveState;
    }

    public final void setLeaveState(@Nullable IBlockState iBlockState) {
        this.leaveState = iBlockState;
    }

    @Nullable
    public final IBlockState getSaplingState() {
        return this.saplingState;
    }

    public final void setSaplingState(@Nullable IBlockState iBlockState) {
        this.saplingState = iBlockState;
    }

    @NotNull
    public IBlockState getPlacedLeaveState() {
        IBlockState iBlockState = this.leaveState;
        Intrinsics.checkNotNull((Object)iBlockState);
        IBlockState iBlockState2 = iBlockState.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState2, (String)"withProperty(...)");
        return iBlockState2;
    }

    @NotNull
    public IPlantable getPlacedSaplingBlock() {
        IBlockState iBlockState = this.saplingState;
        Intrinsics.checkNotNull((Object)iBlockState);
        Block block = iBlockState.func_177230_c();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraftforge.common.IPlantable");
        return (IPlantable)block;
    }

    @Override
    @Nullable
    public CustomWorldGeneratorImpl getInnerGenerator() {
        return new CustomWorldGeneratorTree(false, this);
    }

    @Override
    protected void setInnerGenerator(@Nullable CustomWorldGeneratorImpl value) {
        this.setInnerGenerator(value);
    }

    @Nullable
    public final CustomWorldGeneratorImpl getOuterGenerator() {
        return new CustomWorldGeneratorTree(true, this);
    }

    public final void setOuterGenerator(@Nullable CustomWorldGeneratorImpl value) {
        this.setOuterGenerator(value);
    }

    public abstract int getItemColor(@Nullable ItemStack var1, int var2);

    public abstract int getBlockColor(@Nullable IBlockState var1, @Nullable IBlockAccess var2, @Nullable BlockPos var3, int var4);

    @Override
    public boolean generate(@Nullable World worldIn, @Nullable BlockPos.MutableBlockPos blockPos, @Nullable Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Integer n;
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        Random random = rand;
        if (random != null) {
            Random it = random;
            boolean bl = false;
            n = this.getMinTrunkHeight(it);
        } else {
            n = null;
        }
        Integer minHeight = n;
        BlockPos.MutableBlockPos mutableBlockPos = blockPos;
        Intrinsics.checkNotNull((Object)mutableBlockPos);
        if (mutableBlockPos.func_177956_o() >= 1) {
            IBlockState blockState;
            Block block;
            int n2 = blockPos.func_177956_o();
            Integer n3 = minHeight;
            Intrinsics.checkNotNull((Object)n3);
            int n4 = n2 + n3 + 1;
            World world = worldIn;
            Intrinsics.checkNotNull((Object)world);
            if (n4 <= world.func_72800_K() && this.isSuitableLocation(worldIn, (BlockPos)blockPos, minHeight) && (block = (blockState = worldIn.func_180495_p(blockPos.func_177977_b())).func_177230_c()).canSustainPlant(blockState, (IBlockAccess)worldIn, blockPos.func_177977_b(), EnumFacing.UP, this.getPlacedSaplingBlock()) && blockPos.func_177956_o() < worldIn.func_72800_K() - minHeight - 1) {
                block.onPlantGrow(blockState, worldIn, blockPos.func_177977_b(), (BlockPos)blockPos);
                this.generateLeaves(worldIn, blockPos, minHeight, rand, notifier);
                this.generateTrunk(worldIn, blockPos, minHeight, rand, notifier);
                return true;
            }
        }
        return false;
    }

    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        int foliageY = blockPos.func_177956_o() - 3 + height;
        int n = blockPos.func_177956_o() + height;
        if (foliageY <= n) {
            while (true) {
                int n2;
                int foliageLayer = foliageY - (blockPos.func_177956_o() + height);
                int foliageLayerRadius = 1 - foliageLayer / 2;
                int foliageX = blockPos.func_177958_n() - foliageLayerRadius;
                if (foliageX <= (n2 = blockPos.func_177958_n() + foliageLayerRadius)) {
                    while (true) {
                        int n3;
                        int foliageRelativeX = foliageX - blockPos.func_177958_n();
                        int foliageZ = blockPos.func_177952_p() - foliageLayerRadius;
                        if (foliageZ <= (n3 = blockPos.func_177952_p() + foliageLayerRadius)) {
                            while (true) {
                                BlockPos leavesBlockPos;
                                IBlockState leavesBlockState;
                                Block leavesBlock;
                                int foliageRelativeZ = foliageZ - blockPos.func_177952_p();
                                if ((Math.abs(foliageRelativeX) != foliageLayerRadius || Math.abs(foliageRelativeZ) != foliageLayerRadius || rand.nextInt(2) != 0 && foliageLayer != 0) && ((leavesBlock = (leavesBlockState = worldIn.func_180495_p(leavesBlockPos = new BlockPos(foliageX, foliageY, foliageZ))).func_177230_c()).func_176200_f((IBlockAccess)worldIn, (BlockPos)blockPos) || leavesBlock.canBeReplacedByLeaves(leavesBlockState, (IBlockAccess)worldIn, (BlockPos)blockPos))) {
                                    notifier.invoke((Object)worldIn, (Object)leavesBlockPos, (Object)this.leaveState);
                                }
                                if (foliageZ == n3) break;
                                ++foliageZ;
                            }
                        }
                        if (foliageX == n2) break;
                        ++foliageX;
                    }
                }
                if (foliageY == n) break;
                ++foliageY;
            }
        }
    }

    protected void generateTrunk(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int maxHeight, @Nullable Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos upNBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState blockState = worldIn.func_180495_p((BlockPos)upNBlockPos);
            Block block = blockState.func_177230_c();
            if (block.isAir(blockState, (IBlockAccess)worldIn, (BlockPos)upNBlockPos) || block.isLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)upNBlockPos)) {
                BlockPos blockPos2 = blockPos.func_177981_b(height);
                IBlockState iBlockState = this.logState;
                Intrinsics.checkNotNull((Object)iBlockState);
                notifier.invoke((Object)worldIn, (Object)blockPos2, (Object)iBlockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            }
            upNBlockPos.func_189536_c(EnumFacing.UP);
        }
    }

    public final void setupBlocks() {
        GTLiteLeaveBlock gTLiteLeaveBlock = GTLiteBlocks.LEAVES.get(this.seed / 4);
        Intrinsics.checkNotNullExpressionValue((Object)gTLiteLeaveBlock, (String)"get(...)");
        GTLiteLeaveBlock leaves = gTLiteLeaveBlock;
        this.leaveState = leaves.func_176203_a(this.seed % 4 << 2);
        GTLiteLogBlock gTLiteLogBlock = GTLiteBlocks.LOGS.get(this.seed / 4);
        Intrinsics.checkNotNullExpressionValue((Object)gTLiteLogBlock, (String)"get(...)");
        GTLiteLogBlock logs = gTLiteLogBlock;
        this.logState = logs.func_176203_a(this.seed % 4 << 2);
        GTLiteSaplingBlock gTLiteSaplingBlock = GTLiteBlocks.SAPLINGS.get(this.seed / 8);
        Intrinsics.checkNotNullExpressionValue((Object)gTLiteSaplingBlock, (String)"get(...)");
        GTLiteSaplingBlock saplings = gTLiteSaplingBlock;
        this.saplingState = saplings.func_176203_a(this.seed % 8 << 1);
    }

    public final boolean isReplaceable(@NotNull World worldIn, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Block block = worldIn.func_180495_p(blockPos).func_177230_c();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        return this.canGrowInto(block);
    }

    protected final boolean canGrowInto(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == Blocks.field_150395_bd;
    }

    protected final boolean isSuitableLocation(@NotNull World worldIn, @NotNull BlockPos blockPos, int minHeight) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        int height = 0;
        int n = 1 + minHeight;
        if (height <= n) {
            while (true) {
                int n2;
                int extraSpaceNeeded = this.getMooreRadiusAtHeight(height, minHeight);
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                int checkX = blockPos.func_177958_n() - extraSpaceNeeded;
                if (checkX <= (n2 = blockPos.func_177958_n() + extraSpaceNeeded)) {
                    while (true) {
                        int n3;
                        int checkZ;
                        if ((checkZ = blockPos.func_177952_p() - extraSpaceNeeded) <= (n3 = blockPos.func_177952_p() + extraSpaceNeeded)) {
                            while (true) {
                                BlockPos.MutableBlockPos mutableBlockPos = pos.func_181079_c(checkX, height + blockPos.func_177956_o(), checkZ);
                                Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"setPos(...)");
                                if (!this.isReplaceable(worldIn, (BlockPos)mutableBlockPos)) {
                                    return false;
                                }
                                if (checkZ == n3) break;
                                ++checkZ;
                            }
                        }
                        if (checkX == n2) break;
                        ++checkX;
                    }
                }
                if (height == n) break;
                ++height;
            }
        }
        return true;
    }

    public int getMinTrunkHeight(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return random.nextInt(3) + 5;
    }

    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        return 0;
    }

    @Nullable
    public ItemStack getFruitDrop(int chance) {
        return ItemStack.field_190927_a;
    }
}

