/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.tree;

import gregtech.api.GTValues;
import gregtechlite.gtlitecore.api.extension.BlockPosExtKt;
import gregtechlite.gtlitecore.api.worldgen.condition.BiomeCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.ClimateCondition;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014JP\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2$\u0010\u000e\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001a\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J.\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u001e2\b\u0010\b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u000bH\u0016\u00a8\u0006\u001f"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBanana;", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "<init>", "()V", "generateLeaves", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "height", "", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "generateTrunk", "maxHeight", "getMinTrunkHeight", "random", "getFruitDrop", "Lnet/minecraft/item/ItemStack;", "chance", "getItemColor", "stack", "tintIndex", "getBlockColor", "blockState", "Lnet/minecraft/world/IBlockAccess;", "gtlitecore"})
public final class WorldGeneratorTreeBanana
extends WorldGeneratorTreeBase {
    public WorldGeneratorTreeBanana() {
        super("banana", 0);
        List<GenerateCondition> list = this.getConditions();
        Biome biome = Biomes.field_76782_w;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"JUNGLE");
        list.add(new BiomeCondition(biome, 5, 0.35));
        List<GenerateCondition> list2 = this.getConditions();
        Biome biome2 = Biomes.field_150574_L;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"JUNGLE_EDGE");
        list2.add(new BiomeCondition(biome2, 5, 0.3));
        List<GenerateCondition> list3 = this.getConditions();
        Biome biome3 = Biomes.field_76792_x;
        Intrinsics.checkNotNullExpressionValue((Object)biome3, (String)"JUNGLE_HILLS");
        list3.add(new BiomeCondition(biome3, 5, 0.35));
        List<GenerateCondition> list4 = this.getConditions();
        Biome biome4 = Biomes.field_185446_X;
        Intrinsics.checkNotNullExpressionValue((Object)biome4, (String)"MUTATED_JUNGLE");
        list4.add(new BiomeCondition(biome4, 5, 0.3));
        List<GenerateCondition> list5 = this.getConditions();
        Biome biome5 = Biomes.field_185447_Y;
        Intrinsics.checkNotNullExpressionValue((Object)biome5, (String)"MUTATED_JUNGLE_EDGE");
        list5.add(new BiomeCondition(biome5, 5, 0.15));
        this.getConditions().add(new ClimateCondition(5, 1.5, 0.8, 0.8, 0.4));
    }

    @Override
    protected void generateLeaves(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int height, @NotNull Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        int facingIndex;
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos blockPos2 = blockPos.func_177981_b(height - 1);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"up(...)");
        BlockPos.MutableBlockPos pos = BlockPosExtKt.copy(blockPos2);
        for (facingIndex = 0; facingIndex < 3; ++facingIndex) {
            pos.func_189536_c(EnumFacing.UP);
            notifier.invoke((Object)worldIn, (Object)pos, (Object)this.getPlacedLeaveState());
            if (facingIndex != 1) continue;
            pos.func_189536_c(EnumFacing.func_176731_b((int)rand.nextInt(4)));
            notifier.invoke((Object)worldIn, (Object)pos, (Object)this.getPlacedLeaveState());
        }
        for (facingIndex = 0; facingIndex < 4; ++facingIndex) {
            int leafOffset = rand.nextInt(2);
            BlockPos blockPos3 = blockPos.func_177981_b(height - 2 + leafOffset);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"up(...)");
            BlockPos.MutableBlockPos sidePos = BlockPosExtKt.copy(blockPos3);
            for (int sideFacingIndex = 0; sideFacingIndex < 3; ++sideFacingIndex) {
                sidePos.func_189536_c(EnumFacing.func_176731_b((int)facingIndex));
                notifier.invoke((Object)worldIn, (Object)sidePos, (Object)this.getPlacedLeaveState());
                if (sideFacingIndex != 0) continue;
                sidePos.func_189536_c(EnumFacing.UP);
                notifier.invoke((Object)worldIn, (Object)sidePos, (Object)this.getPlacedLeaveState());
            }
        }
        for (facingIndex = 0; facingIndex < 4; ++facingIndex) {
            notifier.invoke((Object)worldIn, (Object)blockPos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)facingIndex)), (Object)this.getPlacedLeaveState());
            notifier.invoke((Object)worldIn, (Object)blockPos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)facingIndex)).func_177972_a(EnumFacing.func_176731_b((int)facingIndex).func_176746_e()), (Object)this.getPlacedLeaveState());
        }
    }

    @Override
    protected void generateTrunk(@NotNull World worldIn, @NotNull BlockPos.MutableBlockPos blockPos, int maxHeight, @Nullable Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        BlockPos.MutableBlockPos upNBlockPos = BlockPosExtKt.copy((BlockPos)blockPos);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState blockState = worldIn.func_180495_p((BlockPos)upNBlockPos);
            Block block = blockState.func_177230_c();
            if (block.isAir(blockState, (IBlockAccess)worldIn, (BlockPos)upNBlockPos) || block.isLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)upNBlockPos)) {
                IBlockState iBlockState;
                notifier.invoke((Object)worldIn, (Object)blockPos.func_177981_b(height), (iBlockState = this.getLogState()) != null ? iBlockState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)(height == maxHeight - 1 ? BlockLog.EnumAxis.NONE : BlockLog.EnumAxis.Y)) : null);
            }
            upNBlockPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    public int getMinTrunkHeight(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return 3 + random.nextInt(2);
    }

    @Override
    @Nullable
    public ItemStack getFruitDrop(int chance) {
        if (GTValues.RNG.nextInt(chance / 8) == 0) {
            return GTLiteMetaItems.INSTANCE.getBANANA().getStackForm(GTValues.RNG.nextInt(4) + 3);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getItemColor(@Nullable ItemStack stack, int tintIndex) {
        return 3762734;
    }

    @Override
    public int getBlockColor(@Nullable IBlockState blockState, @Nullable IBlockAccess worldIn, @Nullable BlockPos blockPos, int tintIndex) {
        return 3762734;
    }
}

