/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen.generator.plant;

import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.api.worldgen.generator.AbstractWorldGenerator;
import gregtechlite.gtlitecore.api.worldgen.generator.CustomWorldGeneratorImpl;
import gregtechlite.gtlitecore.common.block.GTLiteBerryBushBlock;
import gregtechlite.gtlitecore.common.worldgen.generator.custom.CustomWorldGeneratorBerry;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JL\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182$\u0010\u0019\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u001d0\u001aH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010!\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00142\b\u0010#\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/generator/plant/WorldGeneratorBerryBase;", "Lgregtechlite/gtlitecore/api/worldgen/generator/AbstractWorldGenerator;", "seed", "", "bush", "Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;", "<init>", "(ILgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;)V", "getBush", "()Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;", "value", "Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "innerGenerator", "getInnerGenerator", "()Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "setInnerGenerator", "(Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;)V", "generate", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "", "addCondition", "condition", "Lgregtechlite/gtlitecore/api/worldgen/condition/GenerateCondition;", "canGrowAt", "world", "pos", "canGrowInto", "block", "Lnet/minecraft/block/Block;", "gtlitecore"})
public class WorldGeneratorBerryBase
extends AbstractWorldGenerator {
    @NotNull
    private final GTLiteBerryBushBlock bush;

    public WorldGeneratorBerryBase(int seed, @NotNull GTLiteBerryBushBlock bush) {
        Intrinsics.checkNotNullParameter((Object)((Object)bush), (String)"bush");
        super(seed);
        this.bush = bush;
    }

    @NotNull
    public final GTLiteBerryBushBlock getBush() {
        return this.bush;
    }

    @Override
    @Nullable
    public CustomWorldGeneratorImpl getInnerGenerator() {
        return new CustomWorldGeneratorBerry(this);
    }

    @Override
    protected void setInnerGenerator(@Nullable CustomWorldGeneratorImpl value) {
        this.setInnerGenerator(value);
    }

    @Override
    public boolean generate(@Nullable World worldIn, @Nullable BlockPos.MutableBlockPos blockPos, @Nullable Random rand, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> notifier) {
        Intrinsics.checkNotNullParameter(notifier, (String)"notifier");
        if (this.canGrowAt(worldIn, (BlockPos)blockPos)) {
            notifier.invoke((Object)worldIn, (Object)blockPos, (Object)this.bush.func_185528_e(2));
            Random random = rand;
            Intrinsics.checkNotNull((Object)random);
            int n = random.nextInt(3);
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                BlockPos.MutableBlockPos mutableBlockPos = blockPos;
                Intrinsics.checkNotNull((Object)mutableBlockPos);
                BlockPos other = mutableBlockPos.func_177982_a(rand.nextInt(5) - 2, rand.nextInt(5) - 2, 0);
                if (!this.canGrowAt(worldIn, other)) continue;
                notifier.invoke((Object)worldIn, (Object)other, (Object)this.bush.func_185528_e(2));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public final WorldGeneratorBerryBase addCondition(@NotNull GenerateCondition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.getConditions().add(condition);
        return this;
    }

    private final boolean canGrowAt(World world, BlockPos pos) {
        BlockPos blockPos = pos;
        Intrinsics.checkNotNull((Object)blockPos);
        if (blockPos.func_177956_o() >= 1) {
            int n = pos.func_177956_o();
            World world2 = world;
            Intrinsics.checkNotNull((Object)world2);
            if (n < world2.func_72800_K()) {
                IBlockState soilState = world.func_180495_p(pos.func_177977_b());
                IBlockState currentState = world.func_180495_p(pos);
                Block block = currentState.func_177230_c();
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
                return this.canGrowInto(block) && soilState.func_177230_c().canSustainPlant(soilState, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this.bush);
            }
        }
        return false;
    }

    private final boolean canGrowInto(Block block) {
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || block == Blocks.field_150395_bd || material == Material.field_151597_y;
    }
}

