/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.worldgen;

import com.morphismmc.morphismlib.util.SidedLogger;
import gregtech.api.util.FileUtility;
import gregtechlite.gtlitecore.GTLiteMod;
import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.module.Module;
import gregtechlite.gtlitecore.common.worldgen.generator.WorldGeneratorManager;
import gregtechlite.gtlitecore.core.module.BaseModule;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Module(moduleId="worldgen", containerId="gtlitecore", name="GregTech Lite World Generator Module", descriptions="World Generator Module of GregTech Lite Core Mod.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\f0\u000bH\u0016J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\f0\u000bH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/WorldGenModule;", "Lgregtechlite/gtlitecore/core/module/BaseModule;", "<init>", "()V", "preInit", "", "event", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "init", "Lnet/minecraftforge/fml/common/event/FMLInitializationEvent;", "getTerrainGenBusSubscribers", "", "Ljava/lang/Class;", "getOreGenBusSubscribers", "extractWorldGenFiles", "resource", "", "targetPath", "Ljava/io/File;", "replace", "", "getLogger", "Lorg/apache/logging/log4j/Logger;", "Companion", "gtlitecore"})
public final class WorldGenModule
extends BaseModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger = (Logger)new SidedLogger("gtlitecore-world-generator");

    @Override
    public void preInit(@NotNull FMLPreInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileUtility.extractJarFiles((String)"/assets/gregtech/worldgen/", (File)Loader.instance().getConfigDir().toPath().resolve("gregtech").toFile(), (boolean)false);
        File file = Loader.instance().getConfigDir().toPath().resolve("gregtech").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.extractWorldGenFiles("/assets/gtlitecore/worldgen/", file, false);
    }

    @Override
    public void init(@NotNull FMLInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WorldGeneratorManager.Companion.init$gtlitecore();
    }

    @NotNull
    public List<Class<WorldGenModule>> getTerrainGenBusSubscribers() {
        return CollectionsKt.listOf(WorldGenModule.class);
    }

    @NotNull
    public List<Class<WorldGenModule>> getOreGenBusSubscribers() {
        return CollectionsKt.listOf(WorldGenModule.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void extractWorldGenFiles(String resource, File targetPath, boolean replace) {
        zipFileSystem = null;
        try {
            block24: {
                sampleURL = GTLiteMod.class.getResource("/assets/gtlitecore/LICENSE");
                if (sampleURL == null) {
                    GTLiteLog.logger.warn("Could not find LICENSE resource.");
                    return;
                }
                sampleURI = sampleURL.toURI();
                resourcePath = null;
                var8_11 = sampleURI.getScheme();
                if (var8_11 == null) throw new IllegalStateException("Unable to locate absolute path to directory: " + sampleURI);
                switch (var8_11.hashCode()) {
                    case 120609: {
                        if (!var8_11.equals("zip")) {
                            throw new IllegalStateException("Unable to locate absolute path to directory: " + sampleURI);
                        }
                        ** GOTO lbl24
                    }
                    case 3143036: {
                        if (var8_11.equals("file")) break;
                        throw new IllegalStateException("Unable to locate absolute path to directory: " + sampleURI);
                    }
                    case 104987: {
                        if (var8_11.equals("jar") == false) throw new IllegalStateException("Unable to locate absolute path to directory: " + sampleURI);
lbl24:
                        // 2 sources

                        zipFileSystem = FileSystems.newFileSystem(sampleURI, (Map)new LinkedHashMap<K, V>());
                        resourcePath = zipFileSystem.getPath(resource, new String[0]);
                        break block24;
                    }
                }
                resourceURL = GTLiteMod.class.getResource(resource);
                if (resourceURL == null) {
                    GTLiteLog.logger.warn("Could not find resource file for " + resource + '.');
                    return;
                }
                resourcePath = Paths.get(resourceURL.toURI());
                break block24;
                throw new IllegalStateException("Unable to locate absolute path to directory: " + sampleURI);
            }
            jarFiles = null;
            var9_12 = Files.walk(resourcePath, new FileVisitOption[0]);
            var10_13 = null;
            try {
                it = (Stream)var9_12;
                $i$a$-use-WorldGenModule$extractWorldGenFiles$1 = false;
                Intrinsics.checkNotNull((Object)it);
                jarFiles = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)it), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, extractWorldGenFiles$lambda$1$lambda$0(java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/lang/Boolean;)()));
                it = Unit.INSTANCE;
            }
            catch (Throwable var12_16) {
                var10_13 = var12_16;
                throw var12_16;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)var9_12, (Throwable)var10_13);
            }
            v0 = jarFiles;
            Intrinsics.checkNotNull((Object)v0);
            var9_12 = v0.iterator();
            while (var9_12.hasNext() != false) {
                jarFile = (Path)var9_12.next();
                genPath = targetPath.toPath().resolve(resourcePath.relativize(jarFile).toString());
                Files.createDirectories(genPath.getParent(), new FileAttribute[0]);
                if (!replace && genPath.toFile().isFile()) continue;
                var12_18 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(jarFile, genPath, var12_18);
            }
            return;
        }
        catch (URISyntaxException impossible) {
            throw new RuntimeException(impossible);
        }
        catch (IOException exception) {
            GTLiteLog.logger.error("error while extracting jar files: " + resource + ' ' + targetPath, (Throwable)exception);
            return;
        }
        finally {
            if (zipFileSystem != null) {
                IOUtils.closeQuietly((Closeable)zipFileSystem);
            }
        }
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return logger;
    }

    private static final boolean extractWorldGenFiles$lambda$1$lambda$0(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    @JvmName(name="_logger")
    public static final /* synthetic */ Logger _logger() {
        return Companion._logger();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058GX\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgregtechlite/gtlitecore/common/worldgen/WorldGenModule$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "_logger$annotations", "_logger", "()Lorg/apache/logging/log4j/Logger;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="_logger")
        public final /* synthetic */ Logger _logger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void _logger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

