/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.morphismmc.morphismlib.util.Unchecks;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.IPropertyFluidFilter;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.GTFluidHandlerItemStack;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\rJ\u0012\u0010\u0012\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020\u0019H\u0016J,\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J.\u00101\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u00102\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00103\u001a\u00020\u0019H\u0002J\u0018\u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000106\u0012\u0006\u0012\u0004\u0018\u00010\u000705H\u0017J3\u00107\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010;2\u0010\u0010<\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010>\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u0007H\u0016J2\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020 2\b\u0010C\u001a\u0004\u0018\u00010D2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160F2\u0006\u0010G\u001a\u00020\u0011H\u0017J\b\u0010H\u001a\u00020\u0011H\u0016J\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u001cH\u0016J\u0010\u0010K\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u001cH\u0016J\b\u0010L\u001a\u00020\u0011H\u0014R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/storage/MetaTileEntityPlasticCan;", "Lgregtech/api/metatileentity/MetaTileEntity;", "id", "Lnet/minecraft/util/ResourceLocation;", "material", "Lgregtech/api/unification/material/Material;", "tankSize", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;Lgregtech/api/unification/material/Material;I)V", "fluidFilter", "Lgregtech/api/capability/IPropertyFluidFilter;", "color", "(Lnet/minecraft/util/ResourceLocation;Lgregtech/api/capability/IPropertyFluidFilter;II)V", "fluidTank", "Lgregtech/api/capability/impl/FilteredFluidHandler;", "isAutoOutput", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "getHarvestTool", "", "hasFrontFacing", "initializeInventory", "", "initFromItemStackData", "itemStack", "Lnet/minecraft/nbt/NBTTagCompound;", "writeItemStackData", "initItemStackCapabilities", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "Lnet/minecraft/item/ItemStack;", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "update", "onRightClick", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitResult", "Lcodechicken/lib/raytracer/CuboidRayTraceResult;", "onScrewdriverClick", "wrenchSide", "toggleOutput", "getParticleTexture", "Lorg/apache/commons/lang3/tuple/Pair;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "getDefaultPaintingColor", "addInformation", "stack", "player", "Lnet/minecraft/world/World;", "tooltip", "", "advanced", "showToolUsages", "writeToNBT", "data", "readFromNBT", "shouldSerializeInventories", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMetaTileEntityPlasticCan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTileEntityPlasticCan.kt\ngregtechlite/gtlitecore/common/metatileentity/storage/MetaTileEntityPlasticCan\n+ 2 ArrayExt.kt\ngregtechlite/gtlitecore/api/extension/ArrayExtKt\n*L\n1#1,306:1\n17#2,3:307\n*S KotlinDebug\n*F\n+ 1 MetaTileEntityPlasticCan.kt\ngregtechlite/gtlitecore/common/metatileentity/storage/MetaTileEntityPlasticCan\n*L\n250#1:307,3\n*E\n"})
public final class MetaTileEntityPlasticCan
extends MetaTileEntity {
    @Nullable
    private final IPropertyFluidFilter<?> fluidFilter;
    private final int color;
    private final int tankSize;
    @Nullable
    private FilteredFluidHandler fluidTank;
    private boolean isAutoOutput;

    public MetaTileEntityPlasticCan(@NotNull ResourceLocation id, @NotNull Material material, int tankSize) {
        IPropertyFluidFilter filter;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        super(id);
        IMaterialProperty iMaterialProperty = material.getProperty(PropertyKey.FLUID_PIPE);
        Intrinsics.checkNotNullExpressionValue((Object)iMaterialProperty, (String)"getProperty(...)");
        this.fluidFilter = filter = (IPropertyFluidFilter)iMaterialProperty;
        this.color = material.getMaterialRGB();
        this.tankSize = tankSize;
        this.initializeInventory();
    }

    public MetaTileEntityPlasticCan(@NotNull ResourceLocation id, @NotNull IPropertyFluidFilter<?> fluidFilter, int color, int tankSize) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(fluidFilter, (String)"fluidFilter");
        super(id);
        this.fluidFilter = fluidFilter;
        this.color = color;
        this.tankSize = tankSize;
        this.initializeInventory();
    }

    @NotNull
    public MetaTileEntity createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        IPropertyFluidFilter<?> iPropertyFluidFilter = this.fluidFilter;
        Intrinsics.checkNotNull(iPropertyFluidFilter);
        return new MetaTileEntityPlasticCan(resourceLocation, iPropertyFluidFilter, this.color, this.tankSize);
    }

    @NotNull
    public String getHarvestTool() {
        return "wrench";
    }

    public boolean hasFrontFacing() {
        return false;
    }

    protected void initializeInventory() {
        if (this.fluidFilter != null) {
            super.initializeInventory();
            this.fluidTank = new FilteredFluidHandler(this.tankSize).setFilter((IFilter)this.fluidFilter);
            this.fluidInventory = (IFluidHandler)this.fluidTank;
        }
    }

    public void initFromItemStackData(@NotNull NBTTagCompound itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("Fluid"));
            FilteredFluidHandler filteredFluidHandler = this.fluidTank;
            Intrinsics.checkNotNull((Object)filteredFluidHandler);
            filteredFluidHandler.setFluid(fluidStack);
        }
    }

    public void writeItemStackData(@NotNull NBTTagCompound itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super.writeItemStackData(itemStack);
        FilteredFluidHandler filteredFluidHandler = this.fluidTank;
        Intrinsics.checkNotNull((Object)filteredFluidHandler);
        FluidStack fluidStack = filteredFluidHandler.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            itemStack.func_74782_a("Fluid", (NBTBase)tagCompound);
        }
    }

    @NotNull
    public ICapabilityProvider initItemStackCapabilities(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        GTFluidHandlerItemStack gTFluidHandlerItemStack = new GTFluidHandlerItemStack(itemStack, this.tankSize);
        FilteredFluidHandler filteredFluidHandler = this.fluidTank;
        Intrinsics.checkNotNull((Object)filteredFluidHandler);
        GTFluidHandlerItemStack gTFluidHandlerItemStack2 = gTFluidHandlerItemStack.setFilter(filteredFluidHandler.getFilter());
        Intrinsics.checkNotNullExpressionValue((Object)gTFluidHandlerItemStack2, (String)"setFilter(...)");
        return (ICapabilityProvider)gTFluidHandlerItemStack2;
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        FilteredFluidHandler filteredFluidHandler = this.fluidTank;
        Intrinsics.checkNotNull((Object)filteredFluidHandler);
        FluidStack fluidStack = filteredFluidHandler.getFluid();
        buf.writeBoolean(fluidStack != null);
        if (fluidStack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            buf.func_150786_a(tagCompound);
        }
        buf.writeBoolean(this.isAutoOutput);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        FluidStack fluidStack = null;
        if (buf.readBoolean()) {
            try {
                NBTTagCompound tagCompound = buf.func_150793_b();
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FilteredFluidHandler filteredFluidHandler = this.fluidTank;
        Intrinsics.checkNotNull((Object)filteredFluidHandler);
        filteredFluidHandler.setFluid(fluidStack);
        this.isAutoOutput = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT) {
            this.isAutoOutput = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.isAutoOutput && this.getOffsetTimer() % (long)5 == 0L) {
            EnumFacing[] enumFacingArray = new EnumFacing[]{EnumFacing.DOWN};
            this.pushFluidsIntoNearbyHandlers(enumFacingArray);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onRightClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @Nullable EnumFacing facing, @Nullable CuboidRayTraceResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (playerIn.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            if (this.getWorld().field_72995_K) return true;
            if (playerIn.func_70093_af()) return false;
            FilteredFluidHandler filteredFluidHandler = this.fluidTank;
            Intrinsics.checkNotNull((Object)filteredFluidHandler);
            if (!FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)((IFluidHandler)filteredFluidHandler))) return false;
            return true;
        }
        boolean bl = super.onRightClick(playerIn, hand, facing, hitResult);
        return bl;
    }

    public boolean onScrewdriverClick(@NotNull EntityPlayer playerIn, @Nullable EnumHand hand, @Nullable EnumFacing wrenchSide, @Nullable CuboidRayTraceResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        if (!playerIn.func_70093_af()) {
            if (this.getWorld().field_72995_K) {
                this.scheduleRenderUpdate();
                return true;
            }
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.drum." + (this.isAutoOutput ? "disable" : "enable") + "_output", new Object[0]), true);
            this.toggleOutput();
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, wrenchSide, hitResult);
    }

    private final void toggleOutput() {
        boolean bl = this.isAutoOutput = !this.isAutoOutput;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT, arg_0 -> MetaTileEntityPlasticCan.toggleOutput$lambda$1(this, arg_0));
            this.markDirty();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        int color = GTUtility.convertOpaqueRGBA_CLtoRGB((int)ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.color), (int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering())));
        Pair pair = Pair.of((Object)GTLiteOverlays.PLASTIC_CAN.getParticleTexture(), (Object)color);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
        return pair;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        IVertexOperation[] iVertexOperationArray;
        ColourMultiplier multiplier = new ColourMultiplier(ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.color), (int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering())));
        if (pipeline != null) {
            IVertexOperation[] $this$add$iv = pipeline;
            boolean $i$f$add = false;
            IVertexOperation[] iVertexOperationArray2 = Arrays.copyOf($this$add$iv, $this$add$iv.length + 1);
            Intrinsics.checkNotNullExpressionValue((Object)iVertexOperationArray2, (String)"copyOf(...)");
            IVertexOperation[] arr$iv = iVertexOperationArray2;
            arr$iv[$this$add$iv.length] = multiplier;
            Object object = Unchecks.cast((Object)arr$iv);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cast(...)");
            iVertexOperationArray = (IVertexOperation[])((Object[])object);
        } else {
            iVertexOperationArray = null;
        }
        GTLiteOverlays.PLASTIC_CAN.render(renderState, translation, iVertexOperationArray, this.frontFacing);
        GTLiteOverlays.PLASTIC_CAN_OVERLAY.render(renderState, translation, pipeline);
        if (this.isAutoOutput) {
            Textures.STEAM_VENT_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        }
    }

    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        NBTTagCompound tagCompound;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Object[] objectArray = new Object[]{this.tankSize};
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])objectArray));
        IPropertyFluidFilter<?> iPropertyFluidFilter = this.fluidFilter;
        Intrinsics.checkNotNull(iPropertyFluidFilter);
        iPropertyFluidFilter.appendTooltips(tooltip, true, true);
        if (TooltipHelper.isShiftDown()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_down", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
        }
        if ((tagCompound = stack.func_77978_p()) != null && tagCompound.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            if (fluidStack == null) {
                return;
            }
            Object[] objectArray2 = new Object[]{fluidStack.amount, fluidStack.getFluid().getLocalizedName(fluidStack)};
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_tank.fluid", (Object[])objectArray2));
        }
    }

    public boolean showToolUsages() {
        return false;
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        IFluidHandler iFluidHandler = this.fluidInventory;
        Intrinsics.checkNotNull((Object)iFluidHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.FluidTank");
        data.func_74782_a("FluidInventory", (NBTBase)((FluidTank)iFluidHandler).writeToNBT(new NBTTagCompound()));
        data.func_74757_a("AutoOutput", this.isAutoOutput);
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        IFluidHandler iFluidHandler = this.fluidInventory;
        Intrinsics.checkNotNull((Object)iFluidHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.FluidTank");
        ((FluidTank)iFluidHandler).readFromNBT(data.func_74775_l("FluidInventory"));
        this.isAutoOutput = data.func_74767_n("AutoOutput");
    }

    protected boolean shouldSerializeInventories() {
        return false;
    }

    private static final void toggleOutput$lambda$1(MetaTileEntityPlasticCan this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isAutoOutput);
    }
}

