/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtechlite.gtlitecore.api.metatileentity.MetaTileEntityDelegator;
import gregtechlite.gtlitecore.client.renderer.texture.custom.ExtenderRenderer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\f\u0010\u0011J\u0012\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0016J3\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010!\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0006\u0012\u0004\u0018\u00010\u000b0$H\u0016J,\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00132\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020.H\u0016J\u0010\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00107\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u0013H\u0016J\u0006\u0010:\u001a\u00020\u0013J\u000e\u0010;\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010<\u001a\u00020\u0007H\u0016J6\u0010=\u001a\u00020\u001a2\b\u0010>\u001a\u0004\u0018\u00010?2\n\b\u0001\u0010@\u001a\u0004\u0018\u00010A2\u000e\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010D0C2\u0006\u0010E\u001a\u00020\u0007H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/storage/MetaTileEntityExtender;", "Lgregtechlite/gtlitecore/api/metatileentity/MetaTileEntityDelegator;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "capabilityFilter", "Lkotlin/Function1;", "Lnet/minecraftforge/common/capabilities/Capability;", "", "renderer", "Lgregtechlite/gtlitecore/client/renderer/texture/custom/ExtenderRenderer;", "baseColor", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;Lkotlin/jvm/functions/Function1;Lgregtechlite/gtlitecore/client/renderer/texture/custom/ExtenderRenderer;I)V", "capFilter", "baseMaterial", "Lgregtech/api/unification/material/Material;", "(Lnet/minecraft/util/ResourceLocation;Lkotlin/jvm/functions/Function1;Lgregtechlite/gtlitecore/client/renderer/texture/custom/ExtenderRenderer;Lgregtech/api/unification/material/Material;)V", "inputFacing", "Lnet/minecraft/util/EnumFacing;", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "getDelegatingFacing", "facing", "renderMetaTileEntity", "", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "getParticleTexture", "Lorg/apache/commons/lang3/tuple/Pair;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "onWrenchClick", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "hitResult", "Lcodechicken/lib/raytracer/CuboidRayTraceResult;", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "isValidFrontFacing", "setFrontFacing", "frontFacing", "getInputFacing", "setInputFacing", "needsSneakToRotate", "addToolUsages", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "gtlitecore"})
public final class MetaTileEntityExtender
extends MetaTileEntityDelegator {
    @NotNull
    private final ExtenderRenderer renderer;
    @Nullable
    private EnumFacing inputFacing;

    public MetaTileEntityExtender(@NotNull ResourceLocation metaTileEntityId, @NotNull Function1<? super Capability<?>, Boolean> capabilityFilter, @NotNull ExtenderRenderer renderer, int baseColor) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        Intrinsics.checkNotNullParameter(capabilityFilter, (String)"capabilityFilter");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        super(metaTileEntityId, capabilityFilter, baseColor);
        this.renderer = renderer;
    }

    public MetaTileEntityExtender(@NotNull ResourceLocation metaTileEntityId, @NotNull Function1<? super Capability<?>, Boolean> capFilter, @NotNull ExtenderRenderer renderer, @NotNull Material baseMaterial) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        Intrinsics.checkNotNullParameter(capFilter, (String)"capFilter");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)baseMaterial, (String)"baseMaterial");
        this(metaTileEntityId, capFilter, renderer, baseMaterial.getMaterialRGB());
    }

    @NotNull
    public MetaTileEntityExtender createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MetaTileEntityExtender(resourceLocation, this.getCapabilityFilter(), this.renderer, this.getBaseColor());
    }

    @Override
    @Nullable
    public EnumFacing getDelegatingFacing(@Nullable EnumFacing facing) {
        return facing == this.getFrontFacing() ? this.inputFacing : this.getFrontFacing();
    }

    @Override
    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.renderer.render(renderState, translation, pipeline, this.getFrontFacing(), this.inputFacing);
    }

    @Override
    @NotNull
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        int color = GTUtility.convertOpaqueRGBA_CLtoRGB((int)ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getBaseColor()), (int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering())));
        Pair pair = Pair.of((Object)this.renderer.getParticleTexture(), (Object)color);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
        return pair;
    }

    public boolean onWrenchClick(@NotNull EntityPlayer playerIn, @Nullable EnumHand hand, @NotNull EnumFacing facing, @Nullable CuboidRayTraceResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        if (!playerIn.func_70093_af()) {
            if (this.getInputFacing() == facing || facing == this.getFrontFacing()) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setInputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74768_a("InputFacing", this.getInputFacing().func_176745_a());
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        this.inputFacing = EnumFacing.field_82609_l[data.func_74762_e("InputFacing")];
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getInputFacing().func_176745_a());
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.inputFacing = EnumFacing.field_82609_l[buf.readByte()];
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_OUTPUT_FACING) {
            this.inputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        }
    }

    public boolean isValidFrontFacing(@NotNull EnumFacing facing) {
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        return facing != this.getFrontFacing() && facing != this.inputFacing;
    }

    public void setFrontFacing(@NotNull EnumFacing frontFacing) {
        Intrinsics.checkNotNullParameter((Object)frontFacing, (String)"frontFacing");
        super.setFrontFacing(frontFacing);
        if (this.inputFacing == null) {
            EnumFacing enumFacing = frontFacing.func_176734_d();
            Intrinsics.checkNotNullExpressionValue((Object)enumFacing, (String)"getOpposite(...)");
            this.setInputFacing(enumFacing);
        }
    }

    @NotNull
    public final EnumFacing getInputFacing() {
        EnumFacing enumFacing = this.inputFacing;
        if (enumFacing == null) {
            enumFacing = EnumFacing.SOUTH;
        }
        return enumFacing;
    }

    public final void setInputFacing(@NotNull EnumFacing inputFacing) {
        Intrinsics.checkNotNullParameter((Object)inputFacing, (String)"inputFacing");
        this.inputFacing = inputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, arg_0 -> MetaTileEntityExtender.setInputFacing$lambda$0(inputFacing, arg_0));
            this.markDirty();
        }
    }

    public boolean needsSneakToRotate() {
        return true;
    }

    public void addToolUsages(@Nullable ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private static final void setInputFacing$lambda$0(EnumFacing $inputFacing, PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeByte($inputFacing.func_176745_a());
    }
}

