/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.single;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.metatileentity.PseudoMultiMachineMetaTileEntity;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J(\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016J3\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0010\u0010&\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010'H\u0017\u00a2\u0006\u0002\u0010)J4\u0010*\u001a\u00020\u00112\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u000101002\u0006\u00102\u001a\u00020\u0015H\u0016J\b\u00103\u001a\u00020\u0015H\u0016\u00a8\u00064"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/single/MachineSapCollector;", "Lgregtechlite/gtlitecore/api/metatileentity/PseudoMultiMachineMetaTileEntity;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;I)V", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "createImportItemHandler", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "createExportItemHandler", "createExportFluidHandler", "Lgregtech/api/capability/impl/FluidTankList;", "addNotifiedInput", "", "input", "", "isValidFrontFacing", "", "facing", "Lnet/minecraft/util/EnumFacing;", "setFrontFacing", "frontFacing", "onWrenchClick", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "hitResult", "Lcodechicken/lib/raytracer/CuboidRayTraceResult;", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "getIsWeatherOrTerrainResistant", "gtlitecore"})
public final class MachineSapCollector
extends PseudoMultiMachineMetaTileEntity {
    public MachineSapCollector(@Nullable ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, GTLiteRecipeMaps.SAP_COLLECTOR_RECIPES, (ICubeRenderer)GTLiteOverlays.SAP_COLLECTOR_OVERLAY, tier, true, GTLiteMetaTileEntities.collectorTankSizeFunction);
    }

    @Override
    @NotNull
    public PseudoMultiMachineMetaTileEntity createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        return new MachineSapCollector(this.metaTileEntityId, this.getTier());
    }

    @NotNull
    protected IItemHandlerModifiable createImportItemHandler() {
        return (IItemHandlerModifiable)new ItemStackHandler(1);
    }

    @NotNull
    protected IItemHandlerModifiable createExportItemHandler() {
        return (IItemHandlerModifiable)new ItemStackHandler(1);
    }

    @NotNull
    protected FluidTankList createExportFluidHandler() {
        IFluidTank[] iFluidTankArray = new IFluidTank[]{new FluidTank(16000)};
        return new FluidTankList(false, iFluidTankArray);
    }

    public void addNotifiedInput(@Nullable Object input) {
        super.addNotifiedInput(input);
        this.onNeighborChanged();
    }

    public boolean isValidFrontFacing(@Nullable EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.getOutputFacingFluids().func_176734_d() && facing != this.getOutputFacingItems().func_176734_d();
    }

    public void setFrontFacing(@NotNull EnumFacing frontFacing) {
        Intrinsics.checkNotNullParameter((Object)frontFacing, (String)"frontFacing");
        super.setFrontFacing(frontFacing);
        if (this.getOutputFacingFluids() == frontFacing.func_176734_d() || this.getOutputFacingItems() == frontFacing.func_176734_d()) {
            this.setOutputFacing(frontFacing.func_176746_e());
        }
    }

    @Override
    public boolean onWrenchClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull EnumFacing facing, @NotNull CuboidRayTraceResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing) {
                return false;
            }
            if (this.hasFrontFacing() && facing == this.getFrontFacing() || facing == this.getFrontFacing().func_176734_d()) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        GTLiteOverlays.SAP_COLLECTOR_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.set(1, I18n.func_135052_a((String)"gtlitecore.machine.sap_collector.sap_collection", (Object[])new Object[0]));
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }
}

