/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.single;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.capability.logic.MobExtractorRecipeLogic;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.property.MobOnTopProperty;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u001e2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0014J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/single/MachineMobExtractor;", "Lgregtech/api/metatileentity/SimpleMachineMetaTileEntity;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "recipeMap", "Lgregtech/api/recipes/RecipeMap;", "renderer", "Lgregtech/client/renderer/ICubeRenderer;", "tier", "", "hasFrontFacing", "", "tankScalingFunction", "Ljava/util/function/Function;", "<init>", "(Lnet/minecraft/util/ResourceLocation;Lgregtech/api/recipes/RecipeMap;Lgregtech/client/renderer/ICubeRenderer;IZLjava/util/function/Function;)V", "boundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "entityAttackable", "Lnet/minecraft/entity/EntityLivingBase;", "entities", "", "Lnet/minecraft/entity/Entity;", "entitiesInProximity", "getEntitiesInProximity", "()Ljava/util/List;", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "createWorkable", "Lgregtech/api/capability/impl/AbstractRecipeLogic;", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "gtlitecore"})
public final class MachineMobExtractor
extends SimpleMachineMetaTileEntity {
    @Nullable
    private AxisAlignedBB boundingBox;
    @Nullable
    private EntityLivingBase entityAttackable;
    @Nullable
    private List<Entity> entities;

    public MachineMobExtractor(@NotNull ResourceLocation metaTileEntityId, @Nullable RecipeMap<?> recipeMap, @Nullable ICubeRenderer renderer, int tier, boolean hasFrontFacing, @Nullable Function<Integer, Integer> tankScalingFunction) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        super(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, tankScalingFunction);
    }

    private final List<Entity> getEntitiesInProximity() {
        if (this.boundingBox == null) {
            this.boundingBox = new AxisAlignedBB(this.getPos().func_177984_a());
        }
        World world = this.getWorld();
        AxisAlignedBB axisAlignedBB = this.boundingBox;
        Intrinsics.checkNotNull((Object)axisAlignedBB);
        List list = world.func_72872_a(Entity.class, axisAlignedBB);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesWithinAABB(...)");
        return list;
    }

    @NotNull
    public MachineMobExtractor createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MachineMobExtractor(resourceLocation, GTLiteRecipeMaps.MOB_EXTRACTOR_RECIPES, (ICubeRenderer)GTLiteOverlays.MOB_EXTRACTOR_OVERLAY, this.getTier(), this.hasFrontFacing(), this.getTankScalingFunction());
    }

    @NotNull
    protected AbstractRecipeLogic createWorkable(@NotNull RecipeMap<?> recipeMap) {
        Intrinsics.checkNotNullParameter(recipeMap, (String)"recipeMap");
        return (AbstractRecipeLogic)new MobExtractorRecipeLogic((MetaTileEntity)this, recipeMap, () -> MachineMobExtractor.createWorkable$lambda$0(this));
    }

    public final boolean checkRecipe(@NotNull Recipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        ResourceLocation entityId = (ResourceLocation)recipe.getProperty((RecipeProperty)MobOnTopProperty.INSTANCE, null);
        if (this.entities == null || this.getOffsetTimer() % (long)5 * 1L == 0L) {
            this.entities = this.getEntitiesInProximity();
        }
        List<Entity> list = this.entities;
        Intrinsics.checkNotNull(list);
        for (Entity entity : list) {
            ResourceLocation resourceLocation = entityId;
            Intrinsics.checkNotNull((Object)resourceLocation);
            if (!EntityList.func_180123_a((Entity)entity, (ResourceLocation)resourceLocation)) continue;
            this.entityAttackable = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
            return true;
        }
        return false;
    }

    private static final IEnergyContainer createWorkable$lambda$0(MachineMobExtractor this$0) {
        return this$0.energyContainer;
    }
}

