/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.part;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IParentWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.widget.GhostCircuitSlotWidget;
import gregtech.api.util.GTHashMaps;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityItemBus;
import gregtechlite.gtlitecore.api.capability.handler.ConfigurableItemStackHandler;
import gregtechlite.gtlitecore.api.extension.ItemStackExtKt;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\tH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0014J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010$\u001a\u00020#H\u0016J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0010H\u0016J\u0012\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010/\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u000202H\u0016J4\u00103\u001a\u00020\u00162\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u0001072\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:092\u0006\u0010;\u001a\u00020\u0010H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u001e\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002050FH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/part/PartMachineHugeItemBus;", "Lgregtech/common/metatileentities/multi/multiblockpart/MetaTileEntityItemBus;", "Lgregtech/api/metatileentity/multiblock/IMultiblockAbilityPart;", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "Lgregtech/api/capability/IControllable;", "Lgregtech/api/capability/IGhostSlotConfigurable;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;I)V", "slotItemInventory", "Lgregtechlite/gtlitecore/api/capability/handler/ConfigurableItemStackHandler;", "actualImportItems", "workingEnabled", "", "autoCollapse", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "initializeInventory", "", "getInventorySize", "getImportItems", "createImportItemHandler", "update", "isAutoCollapse", "setWorkingEnabled", "isWorkingEnabled", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "receiveCustomData", "dataId", "collapseInventorySlotContents", "inventory", "setAutoCollapse", "inverted", "addToMultiBlock", "controllerBase", "Lgregtech/api/metatileentity/multiblock/MultiblockControllerBase;", "removeFromMultiBlock", "registerAbilities", "abilityInstances", "Lgregtech/api/metatileentity/multiblock/AbilityInstances;", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "buildUI", "Lcom/cleanroommc/modularui/screen/ModularPanel;", "guiData", "Lcom/cleanroommc/modularui/factory/PosGuiData;", "panelSyncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "getSubItems", "creativeTab", "Lnet/minecraft/creativetab/CreativeTabs;", "subItems", "Lnet/minecraft/util/NonNullList;", "gtlitecore"})
public final class PartMachineHugeItemBus
extends MetaTileEntityItemBus
implements IMultiblockAbilityPart<IItemHandlerModifiable>,
IControllable,
IGhostSlotConfigurable {
    @Nullable
    private ConfigurableItemStackHandler slotItemInventory;
    @Nullable
    private IItemHandlerModifiable actualImportItems;
    private boolean workingEnabled;
    private boolean autoCollapse;

    public PartMachineHugeItemBus(@NotNull ResourceLocation metaTileEntityId, int tier) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        super(metaTileEntityId, tier, false);
        this.workingEnabled = true;
    }

    @NotNull
    public PartMachineHugeItemBus createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new PartMachineHugeItemBus(resourceLocation, this.getTier());
    }

    protected void initializeInventory() {
        super.initializeInventory();
        if (this.hasGhostCircuitInventory()) {
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory = new GhostCircuitItemStackHandler((MetaTileEntity)this);
            Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
            ghostCircuitItemStackHandler.addNotifiableMetaTileEntity((MetaTileEntity)this);
            this.slotItemInventory = new ConfigurableItemStackHandler((MetaTileEntity)this, this.getInventorySize(), null, false, (Function0<Integer>)((Function0)PartMachineHugeItemBus::initializeInventory$lambda$0));
            Object[] objectArray = new Object[]{this.slotItemInventory, this.circuitInventory};
            this.actualImportItems = (IItemHandlerModifiable)new ItemHandlerList(CollectionsKt.listOf((Object[])objectArray));
        } else {
            this.actualImportItems = null;
        }
    }

    private final int getInventorySize() {
        int slotRoot = 1 + this.getTier();
        return slotRoot * slotRoot;
    }

    @Nullable
    public IItemHandlerModifiable getImportItems() {
        return this.actualImportItems == null ? super.getImportItems() : this.actualImportItems;
    }

    @Nullable
    protected IItemHandlerModifiable createImportItemHandler() {
        return (IItemHandlerModifiable)new NotifiableItemStackHandler((MetaTileEntity)this, this.getInventorySize(), (MetaTileEntity)this.getController(), false);
    }

    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % (long)5 == 0L && this.workingEnabled) {
            EnumFacing[] enumFacingArray = new EnumFacing[]{this.getFrontFacing()};
            this.pullItemsFromNearbyHandlers(enumFacingArray);
        }
        if (this.isAutoCollapse()) {
            IItemHandlerModifiable inventory = super.getImportItems();
            if (!this.isAttachedToMultiBlock() || this.getNotifiedItemInputList().contains(inventory)) {
                Intrinsics.checkNotNull((Object)inventory);
                this.collapseInventorySlotContents(inventory);
            }
        }
    }

    public boolean isAutoCollapse() {
        return this.autoCollapse;
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> PartMachineHugeItemBus.setWorkingEnabled$lambda$1(this, arg_0));
        }
    }

    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
        buf.writeBoolean(this.autoCollapse);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
        this.autoCollapse = buf.readBoolean();
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74757_a("workingEnabled", this.workingEnabled);
        data.func_74757_a("autoCollapse", this.autoCollapse);
        if (this.circuitInventory != null) {
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
            Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
            ghostCircuitItemStackHandler.write(data);
        }
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        if (data.func_74764_b("workingEnabled")) {
            this.workingEnabled = data.func_74767_n("workingEnabled");
        }
        if (data.func_74764_b("autoCollapse")) {
            this.autoCollapse = data.func_74767_n("autoCollapse");
        }
        if (this.circuitInventory != null) {
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
            Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
            ghostCircuitItemStackHandler.read(data);
        }
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.TOGGLE_COLLAPSE_ITEMS) {
            this.autoCollapse = buf.readBoolean();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
        }
    }

    private final void collapseInventorySlotContents(IItemHandlerModifiable inventory) {
        Object2IntMap object2IntMap = GTHashMaps.fromItemHandler((IItemHandler)((IItemHandler)inventory), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)object2IntMap, (String)"fromItemHandler(...)");
        Object2IntMap inventoryContents = object2IntMap;
        List inventoryItemContents = new ArrayList();
        ObjectIterator objectIterator = inventoryContents.object2IntEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            ItemStack copy;
            int count;
            Object2IntMap.Entry e = (Object2IntMap.Entry)objectIterator2.next();
            Object object = e.getKey();
            Intrinsics.checkNotNull((Object)object);
            ItemStack stack = (ItemStack)object;
            int maxStackSize = stack.func_77976_d();
            for (count = e.getIntValue(); count >= maxStackSize; count -= maxStackSize) {
                copy = ItemStackExtKt.copy(stack, maxStackSize);
                inventoryItemContents.add(copy);
            }
            if (count <= 0) continue;
            copy = ItemStackExtKt.copy(stack, count);
            inventoryItemContents.add(copy);
        }
        int n = inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack stackToMove = null;
            stackToMove = i >= inventoryItemContents.size() ? ItemStack.field_190927_a : (ItemStack)inventoryItemContents.get(i);
            inventory.setStackInSlot(i, stackToMove);
        }
    }

    public void setAutoCollapse(boolean inverted) {
        this.autoCollapse = inverted;
        if (!this.getWorld().field_72995_K) {
            if (this.autoCollapse) {
                this.addNotifiedInput(super.getImportItems());
            }
            this.writeCustomData(GregtechDataCodes.TOGGLE_COLLAPSE_ITEMS, arg_0 -> PartMachineHugeItemBus.setAutoCollapse$lambda$2(this, arg_0));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    public void addToMultiBlock(@Nullable MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        if (this.hasGhostCircuitInventory() && this.actualImportItems instanceof ItemHandlerList) {
            IItemHandlerModifiable iItemHandlerModifiable = this.actualImportItems;
            Intrinsics.checkNotNull((Object)iItemHandlerModifiable, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.ItemHandlerList");
            for (IItemHandler handler : ((ItemHandlerList)iItemHandlerModifiable).getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                ((INotifiableHandler)handler).addNotifiableMetaTileEntity((MetaTileEntity)controllerBase);
                ((INotifiableHandler)handler).addToNotifiedList((MetaTileEntity)this, (Object)handler, false);
            }
        }
    }

    public void removeFromMultiBlock(@Nullable MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        if (this.hasGhostCircuitInventory() && this.actualImportItems instanceof ItemHandlerList) {
            IItemHandlerModifiable iItemHandlerModifiable = this.actualImportItems;
            Intrinsics.checkNotNull((Object)iItemHandlerModifiable, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.ItemHandlerList");
            for (IItemHandler handler : ((ItemHandlerList)iItemHandlerModifiable).getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                ((INotifiableHandler)handler).removeNotifiableMetaTileEntity((MetaTileEntity)controllerBase);
            }
        }
    }

    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        Intrinsics.checkNotNullParameter((Object)abilityInstances, (String)"abilityInstances");
        boolean bl = this.hasGhostCircuitInventory() && this.actualImportItems != null ? abilityInstances.add((Object)this.actualImportItems) : abilityInstances.add((Object)this.importItems);
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.huge_item_bus.import.tooltip", (Object[])new Object[0]));
        Object[] objectArray = new Object[]{this.getInventorySize()};
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])objectArray));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.huge_item_bus.tooltip", (Object[])new Object[0]));
    }

    @NotNull
    public ModularPanel buildUI(@NotNull PosGuiData guiData, @NotNull PanelSyncManager panelSyncManager) {
        Intrinsics.checkNotNullParameter((Object)guiData, (String)"guiData");
        Intrinsics.checkNotNullParameter((Object)panelSyncManager, (String)"panelSyncManager");
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        panelSyncManager.registerSlotGroup("item_inv", rowSize);
        int backgroundWidth = Math.max(199, rowSize * 18 + 14);
        int backgroundHeight = 18 + 18 * rowSize + 94;
        BooleanSyncValue workingStateValue = new BooleanSyncValue(() -> PartMachineHugeItemBus.buildUI$lambda$3(this), arg_0 -> PartMachineHugeItemBus.buildUI$lambda$4(this, arg_0));
        BooleanSyncValue collapseStateValue = new BooleanSyncValue(() -> PartMachineHugeItemBus.buildUI$lambda$5(this), arg_0 -> PartMachineHugeItemBus.buildUI$lambda$6(this, arg_0));
        IItemHandlerModifiable handler = this.importItems;
        boolean hasGhostCircuit = this.hasGhostCircuitInventory() && this.circuitInventory != null;
        IDrawable[] iDrawableArray = new IDrawable[]{GTGuiTextures.BUTTON_ITEM_OUTPUT};
        Flow flow = (Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().pos(backgroundWidth - 7 - 18, backgroundHeight - 72 - 7 - 5)).width(18)).height(77)).child((IWidget)((Widget)GTGuiTextures.getLogo((GTGuiTheme)this.getUITheme()).asWidget().size(17)).top(59))).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().top(36)).value((IBoolValue)workingStateValue).overlay(iDrawableArray)).tooltipAutoUpdate(true)).tooltipBuilder(arg_0 -> PartMachineHugeItemBus.buildUI$lambda$9(workingStateValue, arg_0)));
        iDrawableArray = new IDrawable[]{GTGuiTextures.BUTTON_AUTO_COLLAPSE};
        Flow flow2 = (Flow)flow.child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().top(18)).value((IBoolValue)collapseStateValue).overlay(iDrawableArray)).tooltipAutoUpdate(true)).tooltipBuilder(arg_0 -> PartMachineHugeItemBus.buildUI$lambda$10(collapseStateValue, arg_0)));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.INT_CIRCUIT_OVERLAY};
        Flow flow3 = (Flow)flow2.childIf(hasGhostCircuit, (IWidget)new GhostCircuitSlotWidget().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)((IItemHandlerModifiable)this.circuitInventory), (int)0)).background(iDrawableArray));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.BUTTON_X};
        IParentWidget iParentWidget = ((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel((MetaTileEntity)((MetaTileEntity)this), (int)backgroundWidth, (int)backgroundHeight).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).mapTo(rowSize, rowSize * rowSize, arg_0 -> PartMachineHugeItemBus.buildUI$lambda$8(this, handler, arg_0)))).child((IWidget)flow3.childIf(!hasGhostCircuit, (IWidget)new Widget().background(iDrawableArray).tooltip(PartMachineHugeItemBus::buildUI$lambda$11)));
        Intrinsics.checkNotNullExpressionValue((Object)iParentWidget, (String)"child(...)");
        return (ModularPanel)iParentWidget;
    }

    public void getSubItems(@NotNull CreativeTabs creativeTab, @NotNull NonNullList<ItemStack> subItems) {
        Intrinsics.checkNotNullParameter((Object)creativeTab, (String)"creativeTab");
        Intrinsics.checkNotNullParameter(subItems, (String)"subItems");
        for (PartMachineHugeItemBus bus : GTLiteMetaTileEntities.INSTANCE.getHUGE_ITEM_IMPORT_BUS()) {
            subItems.add((Object)bus.getStackForm());
        }
    }

    private static final int initializeInventory$lambda$0() {
        return Integer.MAX_VALUE;
    }

    private static final void setWorkingEnabled$lambda$1(PartMachineHugeItemBus this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.workingEnabled);
    }

    private static final void setAutoCollapse$lambda$2(PartMachineHugeItemBus this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.autoCollapse);
    }

    private static final boolean buildUI$lambda$3(PartMachineHugeItemBus this$0) {
        return this$0.workingEnabled;
    }

    private static final void buildUI$lambda$4(PartMachineHugeItemBus this$0, boolean workingStatus) {
        this$0.workingEnabled = workingStatus;
    }

    private static final boolean buildUI$lambda$5(PartMachineHugeItemBus this$0) {
        return this$0.autoCollapse;
    }

    private static final void buildUI$lambda$6(PartMachineHugeItemBus this$0, boolean collapseMode) {
        this$0.autoCollapse = collapseMode;
    }

    private static final void buildUI$lambda$8$lambda$7(IItemHandlerModifiable $handler, int $index, ItemStack newItem, boolean onlyAmountChanged, boolean client, boolean init2) {
        if (onlyAmountChanged && $handler instanceof GTItemStackHandler) {
            ((GTItemStackHandler)$handler).onContentsChanged($index);
        }
    }

    private static final ItemSlot buildUI$lambda$8(PartMachineHugeItemBus this$0, IItemHandlerModifiable $handler, int index) {
        return new ItemSlot().slot(new ModularSlot($handler, index){

            public int func_75219_a() {
                return Integer.MAX_VALUE;
            }
        }.ignoreMaxStackSize(true).slotGroup("item_inv").changeListener((arg_0, arg_1, arg_2, arg_3) -> PartMachineHugeItemBus.buildUI$lambda$8$lambda$7($handler, index, arg_0, arg_1, arg_2, arg_3)).accessibility(!this$0.isExportHatch, true));
    }

    private static final void buildUI$lambda$9(BooleanSyncValue $workingStateValue, RichTooltip tooltip) {
        tooltip.addLine((IDrawable)($workingStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.item_auto_input.tooltip.enabled") : IKey.lang((String)"gregtech.gui.item_auto_input.tooltip.disabled")));
    }

    private static final void buildUI$lambda$10(BooleanSyncValue $collapseStateValue, RichTooltip tooltip) {
        tooltip.addLine((IDrawable)($collapseStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.item_auto_collapse.tooltip.enabled") : IKey.lang((String)"gregtech.gui.item_auto_collapse.tooltip.disabled")));
    }

    private static final void buildUI$lambda$11(RichTooltip tooltip) {
        tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.gui.configurator_slot.unavailable.tooltip"));
    }
}

