/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.part;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IParentWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.capability.DualHandler;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.widget.GhostCircuitSlotWidget;
import gregtech.api.util.GTHashMaps;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.mui.widget.GTFluidSlot;
import gregtechlite.gtlitecore.api.extension.ItemStackExtKt;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\u0015\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u0003H\u0014J\b\u0010\"\u001a\u00020\u0003H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0014J\b\u0010&\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\tH\u0016J\u0012\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010+H\u0016J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u000bH\u0016J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J3\u00106\u001a\u00020\u00192\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:2\u0010\u0010;\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010<\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010B\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010C\u001a\u00020\u000bH\u0016J\u000e\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u0018\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\t2\u0006\u0010?\u001a\u00020@H\u0016J.\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010N2\b\u0010O\u001a\u0004\u0018\u00010PH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020RH\u0016J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010S\u001a\u00020RH\u0016J4\u0010U\u001a\u00020\u00192\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010Y2\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\\0[2\u0006\u0010]\u001a\u00020\u000bH\u0016J4\u0010^\u001a\u00020\u00192\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010_\u001a\u0004\u0018\u00010Y2\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\\0[2\u0006\u0010]\u001a\u00020\u000bH\u0016J\u000e\u0010`\u001a\u00020\u00192\u0006\u0010a\u001a\u00020\u0003R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/part/PartMachineDualHatch;", "Lgregtech/common/metatileentities/multi/multiblockpart/MetaTileEntityMultiblockNotifiablePart;", "Lgregtech/api/metatileentity/multiblock/IMultiblockAbilityPart;", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "Lgregtech/api/capability/IControllable;", "Lgregtech/api/capability/IGhostSlotConfigurable;", "id", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "isExportHatch", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;IZ)V", "circuitInventory", "Lgregtech/api/capability/impl/GhostCircuitItemStackHandler;", "actualImportItems", "dualHandler", "Lgregtech/api/capability/DualHandler;", "workingEnabled", "autoCollapse", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "initializeInventory", "", "getImportItems", "getItemSize", "getTankSize", "createTanks", "", "Lnet/minecraftforge/fluids/IFluidTank;", "()[Lnet/minecraftforge/fluids/IFluidTank;", "createImportItemHandler", "createExportItemHandler", "createImportFluidHandler", "Lgregtech/api/capability/impl/FluidTankList;", "createExportFluidHandler", "update", "hasGhostCircuitInventory", "setGhostCircuitConfig", "config", "getAbility", "Lgregtech/api/metatileentity/multiblock/MultiblockAbility;", "registerAbilities", "abilityInstances", "Lgregtech/api/metatileentity/multiblock/AbilityInstances;", "usesMui2", "buildUI", "Lcom/cleanroommc/modularui/screen/ModularPanel;", "guiData", "Lcom/cleanroommc/modularui/factory/PosGuiData;", "syncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "setWorkingEnabled", "isWorkingEnabled", "setAutoCollapse", "inverted", "receiveCustomData", "dataId", "onScrewdriverClick", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitResult", "Lcodechicken/lib/raytracer/CuboidRayTraceResult;", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "addToolUsages", "world", "collapseInventorySlotContents", "inventory", "gtlitecore"})
public final class PartMachineDualHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IItemHandlerModifiable>,
IControllable,
IGhostSlotConfigurable {
    @Nullable
    private GhostCircuitItemStackHandler circuitInventory;
    @Nullable
    private IItemHandlerModifiable actualImportItems;
    @Nullable
    private DualHandler dualHandler;
    private boolean workingEnabled;
    private boolean autoCollapse;

    public PartMachineDualHatch(@NotNull ResourceLocation id, int tier, boolean isExportHatch) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, tier, isExportHatch);
        this.workingEnabled = true;
        this.initializeInventory();
    }

    @NotNull
    public PartMachineDualHatch createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new PartMachineDualHatch(resourceLocation, this.getTier(), this.isExportHatch);
    }

    protected void initializeInventory() {
        IItemHandlerModifiable iItemHandlerModifiable;
        super.initializeInventory();
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory = new GhostCircuitItemStackHandler((MetaTileEntity)this);
            Object[] objectArray = new IItemHandlerModifiable[]{this.importItems, this.circuitInventory};
            this.actualImportItems = (IItemHandlerModifiable)new ItemHandlerList(CollectionsKt.listOf((Object[])objectArray));
        } else {
            this.actualImportItems = this.importItems;
        }
        if (this.isExportHatch) {
            IItemHandlerModifiable iItemHandlerModifiable2 = this.exportItems;
            iItemHandlerModifiable = iItemHandlerModifiable2;
            Intrinsics.checkNotNull((Object)iItemHandlerModifiable2);
        } else {
            IItemHandlerModifiable iItemHandlerModifiable3 = this.actualImportItems;
            iItemHandlerModifiable = iItemHandlerModifiable3;
            Intrinsics.checkNotNull((Object)iItemHandlerModifiable3);
        }
        this.dualHandler = new DualHandler(iItemHandlerModifiable, (IMultipleTankHandler)(this.isExportHatch ? this.getExportFluids() : this.getImportFluids()), this.isExportHatch);
    }

    @NotNull
    public IItemHandlerModifiable getImportItems() {
        DualHandler dualHandler = this.dualHandler;
        Intrinsics.checkNotNull((Object)dualHandler);
        return (IItemHandlerModifiable)dualHandler;
    }

    private final int getItemSize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    private final int getTankSize() {
        return 8000 * Math.min(Integer.MAX_VALUE, 1 << this.getTier());
    }

    private final IFluidTank[] createTanks() {
        int size = 1 + Math.min(9, this.getTier());
        IFluidTank[] tanks = new IFluidTank[size];
        int n = tanks.length;
        for (int index = 0; index < n; ++index) {
            tanks[index] = new NotifiableFluidTank(this.getTankSize(), null, this.isExportHatch);
        }
        return tanks;
    }

    @NotNull
    protected IItemHandlerModifiable createImportItemHandler() {
        return this.isExportHatch ? (IItemHandlerModifiable)new GTItemStackHandler((MetaTileEntity)this, 0) : (IItemHandlerModifiable)new NotifiableItemStackHandler((MetaTileEntity)this, this.getItemSize(), null, false);
    }

    @NotNull
    protected IItemHandlerModifiable createExportItemHandler() {
        return this.isExportHatch ? (IItemHandlerModifiable)new NotifiableItemStackHandler((MetaTileEntity)this, this.getItemSize(), null, true) : (IItemHandlerModifiable)new GTItemStackHandler((MetaTileEntity)this, 0);
    }

    @NotNull
    protected FluidTankList createImportFluidHandler() {
        FluidTankList fluidTankList;
        if (this.isExportHatch) {
            fluidTankList = new FluidTankList(false, new IFluidTank[0]);
        } else {
            IFluidTank[] iFluidTankArray = this.createTanks();
            FluidTankList fluidTankList2 = new FluidTankList(false, Arrays.copyOf(iFluidTankArray, iFluidTankArray.length));
            fluidTankList = fluidTankList2;
        }
        return fluidTankList;
    }

    @NotNull
    protected FluidTankList createExportFluidHandler() {
        FluidTankList fluidTankList;
        if (this.isExportHatch) {
            IFluidTank[] iFluidTankArray = this.createTanks();
            FluidTankList fluidTankList2 = new FluidTankList(false, Arrays.copyOf(iFluidTankArray, iFluidTankArray.length));
            fluidTankList = fluidTankList2;
        } else {
            fluidTankList = new FluidTankList(false, new IFluidTank[0]);
        }
        return fluidTankList;
    }

    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % (long)5 == 0L) {
            if (this.workingEnabled) {
                EnumFacing[] enumFacingArray;
                if (this.isExportHatch) {
                    enumFacingArray = new EnumFacing[]{this.getFrontFacing()};
                    this.pushItemsIntoNearbyHandlers(enumFacingArray);
                    enumFacingArray = new EnumFacing[]{this.getFrontFacing()};
                    this.pushFluidsIntoNearbyHandlers(enumFacingArray);
                } else {
                    enumFacingArray = new EnumFacing[]{this.getFrontFacing()};
                    this.pullItemsFromNearbyHandlers(enumFacingArray);
                    enumFacingArray = new EnumFacing[]{this.getFrontFacing()};
                    this.pullFluidsFromNearbyHandlers(enumFacingArray);
                }
            }
            if (this.autoCollapse()) {
                IItemHandlerModifiable itemHandler;
                IItemHandlerModifiable iItemHandlerModifiable = itemHandler = this.isExportHatch ? this.getExportItems() : super.getImportItems();
                if (!this.isAttachedToMultiBlock() || (this.isExportHatch ? this.getNotifiedItemOutputList().contains(itemHandler) : this.getNotifiedItemInputList().contains(itemHandler))) {
                    Intrinsics.checkNotNull((Object)itemHandler);
                    this.collapseInventorySlotContents(itemHandler);
                }
            }
        }
    }

    public boolean hasGhostCircuitInventory() {
        return !this.isExportHatch;
    }

    public void setGhostCircuitConfig(int config) {
        block5: {
            block4: {
                if (this.circuitInventory == null) break block4;
                GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
                Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
                if (ghostCircuitItemStackHandler.getCircuitValue() != config) break block5;
            }
            return;
        }
        GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
        Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
        ghostCircuitItemStackHandler.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Nullable
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return this.isExportHatch ? MultiblockAbility.EXPORT_ITEMS : MultiblockAbility.IMPORT_ITEMS;
    }

    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        Intrinsics.checkNotNullParameter((Object)abilityInstances, (String)"abilityInstances");
        abilityInstances.add((Object)this.dualHandler);
    }

    public boolean usesMui2() {
        return true;
    }

    @NotNull
    public ModularPanel buildUI(@NotNull PosGuiData guiData, @NotNull PanelSyncManager syncManager) {
        Intrinsics.checkNotNullParameter((Object)guiData, (String)"guiData");
        Intrinsics.checkNotNullParameter((Object)syncManager, (String)"syncManager");
        int rowSize = (int)Math.sqrt(this.getItemSize());
        syncManager.registerSlotGroup("item_inv", rowSize);
        int backgroundWidth = Math.max(199, rowSize * 18 + 14 + 18);
        int backgroundHeight = 18 + 18 * rowSize + 94;
        List widgets = new ArrayList();
        for (int i = 0; i < rowSize; ++i) {
            widgets.add(new ArrayList());
            for (int j = 0; j < rowSize; ++j) {
                int index = i * rowSize + j;
                IItemHandlerModifiable handler = this.isExportHatch ? this.getExportItems() : this.getImportItems();
                List list = (List)widgets.get(i);
                ItemSlot itemSlot = new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)handler, (int)index).slotGroup("item_inv").changeListener((arg_0, arg_1, arg_2, arg_3) -> PartMachineDualHatch.buildUI$lambda$0(handler, index, arg_0, arg_1, arg_2, arg_3)).accessibility(!this.isExportHatch, true));
                Intrinsics.checkNotNullExpressionValue((Object)itemSlot, (String)"slot(...)");
                list.add(itemSlot);
            }
            DualHandler dualHandler = this.dualHandler;
            Intrinsics.checkNotNull((Object)dualHandler);
            IMultipleTankHandler.ITankEntry iTankEntry = dualHandler.getTankAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)iTankEntry, (String)"getTankAt(...)");
            IFluidTank tankHandler = (IFluidTank)iTankEntry;
            List list = (List)widgets.get(i);
            GTFluidSlot gTFluidSlot = new GTFluidSlot().syncHandler(GTFluidSlot.sync((IFluidTank)tankHandler).accessibility(true, !this.isExportHatch));
            Intrinsics.checkNotNullExpressionValue((Object)gTFluidSlot, (String)"syncHandler(...)");
            list.add(gTFluidSlot);
        }
        BooleanSyncValue workingStateValue = new BooleanSyncValue(() -> PartMachineDualHatch.buildUI$lambda$1(this), arg_0 -> PartMachineDualHatch.buildUI$lambda$2(this, arg_0));
        BooleanSyncValue collapseStateValue = new BooleanSyncValue(() -> PartMachineDualHatch.buildUI$lambda$3(this), arg_0 -> PartMachineDualHatch.buildUI$lambda$4(this, arg_0));
        syncManager.syncValue("working_state", (SyncHandler)workingStateValue);
        syncManager.syncValue("collapse_state", (SyncHandler)collapseStateValue);
        boolean hasGhostCircuit = this.hasGhostCircuitInventory() && this.circuitInventory != null;
        IDrawable[] iDrawableArray = new IDrawable[]{GTGuiTextures.BUTTON_ITEM_OUTPUT};
        Flow flow = (Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().pos(backgroundWidth - 7 - 18, backgroundHeight - 72 - 7 - 5)).width(18)).height(77)).child((IWidget)((Widget)GTGuiTextures.getLogo((GTGuiTheme)this.getUITheme()).asWidget().size(17)).top(59))).child((IWidget)((ToggleButton)((ToggleButton)new ToggleButton().top(36)).value((IBoolValue)new BoolValue.Dynamic(() -> PartMachineDualHatch.buildUI$lambda$5(workingStateValue), arg_0 -> PartMachineDualHatch.buildUI$lambda$6(workingStateValue, arg_0))).overlay(iDrawableArray)).tooltipBuilder(arg_0 -> PartMachineDualHatch.buildUI$lambda$7(this, workingStateValue, arg_0)));
        iDrawableArray = new IDrawable[]{GTGuiTextures.BUTTON_AUTO_COLLAPSE};
        Flow flow2 = (Flow)flow.child((IWidget)((ToggleButton)((ToggleButton)new ToggleButton().top(18)).value((IBoolValue)new BoolValue.Dynamic(() -> PartMachineDualHatch.buildUI$lambda$8(collapseStateValue), arg_0 -> PartMachineDualHatch.buildUI$lambda$9(collapseStateValue, arg_0))).overlay(iDrawableArray)).tooltipBuilder(arg_0 -> PartMachineDualHatch.buildUI$lambda$10(collapseStateValue, arg_0)));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.INT_CIRCUIT_OVERLAY};
        Flow flow3 = (Flow)flow2.childIf(hasGhostCircuit, (IWidget)new GhostCircuitSlotWidget().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)((IItemHandlerModifiable)this.circuitInventory), (int)0).changeListener((arg_0, arg_1, arg_2, arg_3) -> PartMachineDualHatch.buildUI$lambda$11(this, arg_0, arg_1, arg_2, arg_3))).background(iDrawableArray));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.BUTTON_X};
        IParentWidget iParentWidget = ((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel((MetaTileEntity)((MetaTileEntity)this), (int)backgroundWidth, (int)backgroundHeight).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).matrix(widgets))).child((IWidget)flow3.childIf(!hasGhostCircuit, (IWidget)new Widget().background(iDrawableArray).tooltip(PartMachineDualHatch::buildUI$lambda$12)));
        Intrinsics.checkNotNullExpressionValue((Object)iParentWidget, (String)"child(...)");
        return (ModularPanel)iParentWidget;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        SimpleOverlayRenderer renderer = this.isExportHatch ? Textures.PIPE_OUT_OVERLAY : Textures.PIPE_IN_OVERLAY;
        renderer.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        SimpleOverlayRenderer overlay = this.isExportHatch ? GTLiteOverlays.DUAL_HATCH_OUTPUT_OVERLAY : GTLiteOverlays.DUAL_HATCH_INPUT_OVERLAY;
        overlay.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
        buf.writeBoolean(this.autoCollapse);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
        this.autoCollapse = buf.readBoolean();
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> PartMachineDualHatch.setWorkingEnabled$lambda$13(workingEnabled, arg_0));
        }
    }

    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    public final void setAutoCollapse(boolean inverted) {
        this.autoCollapse = inverted;
        if (!this.getWorld().field_72995_K) {
            if (this.autoCollapse) {
                if (this.isExportHatch) {
                    this.addNotifiedOutput(this.getExportItems());
                } else {
                    this.addNotifiedInput(this.getImportItems());
                }
            }
            this.writeCustomData(GregtechDataCodes.TOGGLE_COLLAPSE_ITEMS, arg_0 -> PartMachineDualHatch.setAutoCollapse$lambda$14(this, arg_0));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    public final boolean autoCollapse() {
        return this.autoCollapse;
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
        } else if (dataId == GregtechDataCodes.TOGGLE_COLLAPSE_ITEMS) {
            this.autoCollapse = buf.readBoolean();
        }
    }

    public boolean onScrewdriverClick(@NotNull EntityPlayer playerIn, @Nullable EnumHand hand, @Nullable EnumFacing facing, @Nullable CuboidRayTraceResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        this.setAutoCollapse(!this.autoCollapse);
        if (!this.getWorld().field_72995_K) {
            if (this.autoCollapse) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.bus.collapse_true", new Object[0]), true);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.bus.collapse_false", new Object[0]), true);
            }
        }
        return true;
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74757_a("workingEnabled", this.workingEnabled);
        data.func_74757_a("autoCollapse", this.autoCollapse);
        if (this.circuitInventory != null) {
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
            Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
            ghostCircuitItemStackHandler.write(data);
        }
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        this.workingEnabled = data.func_74767_n("workingEnabled");
        this.autoCollapse = data.func_74767_n("autoCollapse");
        if (this.circuitInventory != null) {
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
            Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
            ghostCircuitItemStackHandler.read(data);
        }
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        boolean bl = this.isExportHatch ? tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.export.tooltip", (Object[])new Object[0])) : tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        Object[] objectArray = new Object[]{this.getItemSize()};
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])objectArray));
        objectArray = new Object[]{this.getTankSize()};
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])objectArray));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    public void addToolUsages(@Nullable ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_collapse", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    public final void collapseInventorySlotContents(@NotNull IItemHandlerModifiable inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Object2IntMap object2IntMap = GTHashMaps.fromItemHandler((IItemHandler)((IItemHandler)inventory), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)object2IntMap, (String)"fromItemHandler(...)");
        Object2IntMap inventoryContents = object2IntMap;
        List inventoryItemContents = new ArrayList();
        ObjectIterator objectIterator = inventoryContents.object2IntEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            ItemStack copy;
            int count;
            Object2IntMap.Entry e = (Object2IntMap.Entry)objectIterator2.next();
            Object object = e.getKey();
            Intrinsics.checkNotNull((Object)object);
            ItemStack stack = (ItemStack)object;
            int maxStackSize = stack.func_77976_d();
            for (count = e.getIntValue(); count >= maxStackSize; count -= maxStackSize) {
                copy = ItemStackExtKt.copy(stack, maxStackSize);
                inventoryItemContents.add(copy);
            }
            if (count <= 0) continue;
            copy = ItemStackExtKt.copy(stack, count);
            inventoryItemContents.add(copy);
        }
        int n = inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack stackToMove = null;
            stackToMove = i >= inventoryItemContents.size() ? ItemStack.field_190927_a : (ItemStack)inventoryItemContents.get(i);
            inventory.setStackInSlot(i, stackToMove);
        }
    }

    private static final void buildUI$lambda$0(IItemHandlerModifiable $handler, int $index, ItemStack newItem, boolean onlyAmountChanged, boolean client, boolean init2) {
        if (onlyAmountChanged && $handler instanceof GTItemStackHandler) {
            ((GTItemStackHandler)$handler).onContentsChanged($index);
        }
    }

    private static final boolean buildUI$lambda$1(PartMachineDualHatch this$0) {
        return this$0.workingEnabled;
    }

    private static final void buildUI$lambda$2(PartMachineDualHatch this$0, boolean workingStatus) {
        this$0.workingEnabled = workingStatus;
    }

    private static final boolean buildUI$lambda$3(PartMachineDualHatch this$0) {
        return this$0.autoCollapse;
    }

    private static final void buildUI$lambda$4(PartMachineDualHatch this$0, boolean collapse) {
        this$0.autoCollapse = collapse;
    }

    private static final boolean buildUI$lambda$5(BooleanSyncValue $workingStateValue) {
        return $workingStateValue.getBoolValue();
    }

    private static final void buildUI$lambda$6(BooleanSyncValue $workingStateValue, boolean workingStatus) {
        $workingStateValue.setBoolValue(workingStatus);
    }

    private static final void buildUI$lambda$7(PartMachineDualHatch this$0, BooleanSyncValue $workingStateValue, RichTooltip it) {
        it.setAutoUpdate(true);
        RichTooltip richTooltip = this$0.isExportHatch ? ($workingStateValue.getBoolValue() ? (RichTooltip)it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.item_auto_output.tooltip.enabled")) : (RichTooltip)it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.item_auto_output.tooltip.disabled"))) : ($workingStateValue.getBoolValue() ? (RichTooltip)it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.item_auto_input.tooltip.enabled")) : (RichTooltip)it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.item_auto_input.tooltip.disabled")));
    }

    private static final boolean buildUI$lambda$8(BooleanSyncValue $collapseStateValue) {
        return $collapseStateValue.getBoolValue();
    }

    private static final void buildUI$lambda$9(BooleanSyncValue $collapseStateValue, boolean collapseStatus) {
        $collapseStateValue.setBoolValue(collapseStatus);
    }

    private static final void buildUI$lambda$10(BooleanSyncValue $collapseStateValue, RichTooltip it) {
        it.setAutoUpdate(true);
        RichTooltip richTooltip = $collapseStateValue.getBoolValue() ? (RichTooltip)it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.item_auto_collapse.tooltip.enabled")) : (RichTooltip)it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.item_auto_collapse.tooltip.disabled"));
    }

    private static final void buildUI$lambda$11(PartMachineDualHatch this$0, ItemStack newItem, boolean onlyAmountChanged, boolean client, boolean init2) {
        DualHandler dualHandler = this$0.dualHandler;
        Intrinsics.checkNotNull((Object)dualHandler);
        dualHandler.onContentsChanged();
    }

    private static final void buildUI$lambda$12(RichTooltip it) {
        it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.configurator_slot.unavailable.tooltip"));
    }

    private static final void setWorkingEnabled$lambda$13(boolean $workingEnabled, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean($workingEnabled);
    }

    private static final void setAutoCollapse$lambda$14(PartMachineDualHatch this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.autoCollapse);
    }
}

