/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.part;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IParentWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.recipes.properties.impl.DimensionProperty;
import gregtech.api.unification.material.Materials;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.mui.widget.GTFluidSlot;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J3\u0010$\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0010\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010+\u0018\u00010*H\u0017\u00a2\u0006\u0002\u0010,J3\u0010-\u001a\u0004\u0018\u0001H.\"\n\b\u0000\u0010.*\u0004\u0018\u00010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\b\u00102\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000206H\u0014J\n\u00107\u001a\u0004\u0018\u000108H\u0014J\b\u00109\u001a\u000208H\u0014J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u0013H\u0016J4\u0010A\u001a\u00020\u00182\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010E2\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0G2\u0006\u0010I\u001a\u00020\u0013H\u0016J4\u0010J\u001a\u00020\u00182\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010K\u001a\u0004\u0018\u00010E2\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0G2\u0006\u0010I\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/part/PartMachineAirIntakeHatch;", "Lgregtech/common/metatileentities/multi/multiblockpart/MetaTileEntityMultiblockNotifiablePart;", "Lgregtech/api/metatileentity/multiblock/IMultiblockAbilityPart;", "Lnet/minecraftforge/fluids/IFluidTank;", "id", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "capacity", "transferRate", "<init>", "(Lnet/minecraft/util/ResourceLocation;III)V", "rand", "Ljava/util/Random;", "fluidTank", "Lnet/minecraftforge/fluids/FluidTank;", "airType", "Lnet/minecraftforge/fluids/Fluid;", "isWorkingEnabled", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "update", "", "receiveCustomData", "dataId", "buf", "Lnet/minecraft/network/PacketBuffer;", "writeInitialSyncData", "receiveInitialSyncData", "getAbility", "Lgregtech/api/metatileentity/multiblock/MultiblockAbility;", "registerAbilities", "abilities", "Lgregtech/api/metatileentity/multiblock/AbilityInstances;", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "getCapability", "T", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "createImportFluidHandler", "Lgregtech/api/capability/impl/FluidTankList;", "createImportItemHandler", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "createExportItemHandler", "buildUI", "Lcom/cleanroommc/modularui/screen/ModularPanel;", "guiData", "Lcom/cleanroommc/modularui/factory/PosGuiData;", "syncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "usesMui2", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "addToolUsages", "world", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nPartMachineAirIntakeHatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartMachineAirIntakeHatch.kt\ngregtechlite/gtlitecore/common/metatileentity/part/PartMachineAirIntakeHatch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1863#2,2:314\n*S KotlinDebug\n*F\n+ 1 PartMachineAirIntakeHatch.kt\ngregtechlite/gtlitecore/common/metatileentity/part/PartMachineAirIntakeHatch\n*L\n82#1:314,2\n*E\n"})
public final class PartMachineAirIntakeHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IFluidTank> {
    private final int capacity;
    private final int transferRate;
    @NotNull
    private final Random rand;
    @NotNull
    private FluidTank fluidTank;
    @Nullable
    private Fluid airType;
    private boolean isWorkingEnabled;

    public PartMachineAirIntakeHatch(@NotNull ResourceLocation id, int tier, int capacity, int transferRate) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, tier, false);
        this.capacity = capacity;
        this.transferRate = transferRate;
        this.rand = new Random();
        this.fluidTank = (FluidTank)new NotifiableFluidTank(this.capacity, (MetaTileEntity)this, false);
        this.initializeInventory();
    }

    @NotNull
    public PartMachineAirIntakeHatch createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new PartMachineAirIntakeHatch(resourceLocation, this.getTier(), this.capacity, this.transferRate);
    }

    public void update() {
        super.update();
        if (this.isFirstTick() && !this.getWorld().field_72995_K) {
            Collection collection = RecipeMaps.GAS_COLLECTOR_RECIPES.getRecipeList();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRecipeList(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                DimensionProperty.DimensionPropertyList dimensions;
                Recipe recipe = (Recipe)element$iv;
                boolean bl2 = false;
                if (!recipe.hasProperty((RecipeProperty)DimensionProperty.getInstance())) {
                    return;
                }
                DimensionProperty.DimensionPropertyList dimensionPropertyList = dimensions = (DimensionProperty.DimensionPropertyList)recipe.getProperty((RecipeProperty)DimensionProperty.getInstance(), null);
                if (dimensionPropertyList != null) {
                    Integer n = (Integer)dimensionPropertyList.whiteListDimensions.get(0);
                    int n2 = this.getWorld().field_73011_w.getDimension();
                    bl = n != null && n == n2;
                } else {
                    bl = false;
                }
                if (bl) {
                    this.airType = ((FluidStack)recipe.getFluidOutputs().get(0)).getFluid();
                }
                if (this.airType != null) continue;
                this.airType = Materials.Air.getFluid();
            }
        }
        BlockPos blockFacingPos = new BlockPos(this.getPos().func_177958_n() + this.frontFacing.func_82601_c(), this.getPos().func_177956_o() + this.frontFacing.func_96559_d(), this.getPos().func_177952_p() + this.frontFacing.func_82599_e());
        if (this.getOffsetTimer() % (long)5 == 0L && this.getWorld().func_175623_d(blockFacingPos)) {
            if (!this.getWorld().field_72995_K) {
                int fillAmount = this.fluidTank.fill(new FluidStack(this.airType, this.transferRate), true);
                if (fillAmount == 0 && this.isWorkingEnabled) {
                    this.isWorkingEnabled = false;
                    this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> PartMachineAirIntakeHatch.update$lambda$1(this, arg_0));
                } else if (fillAmount > 0 && !this.isWorkingEnabled) {
                    this.isWorkingEnabled = true;
                    this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> PartMachineAirIntakeHatch.update$lambda$2(this, arg_0));
                }
            }
            if (this.getWorld().field_72995_K && this.isWorkingEnabled) {
                EnumParticleTypes particle = EnumParticleTypes.CLOUD;
                float randX = this.rand.nextFloat();
                float randY = this.rand.nextFloat();
                float randZ = this.rand.nextFloat();
                float posX = (float)this.getPos().func_177958_n() + 0.25f + (float)this.frontFacing.func_82601_c() * 0.76f;
                float posY = (float)this.getPos().func_177956_o() + 0.65f + (float)this.frontFacing.func_96559_d() * 0.76f;
                float posZ = (float)this.getPos().func_177952_p() + 0.25f + (float)this.frontFacing.func_82599_e() * 0.76f;
                float spdX = (float)this.frontFacing.func_96559_d() * 0.1f + 0.2f + 0.1f * this.rand.nextFloat();
                float spdY = 0.0f;
                float spdZ = 0.0f;
                if (this.frontFacing.func_96559_d() == -1) {
                    double pi2 = (double)(this.rand.nextFloat() * 2.0f) * Math.PI;
                    spdY = (float)Math.sin(pi2) * 0.1f;
                    spdZ = (float)Math.cos(pi2) * 0.1f;
                    spdX = -spdX;
                    posY -= 0.8f;
                } else {
                    spdY = -((float)this.frontFacing.func_82601_c() * (0.1f + 0.2f * this.rand.nextFloat()));
                    spdZ = -((float)this.frontFacing.func_82599_e() * (0.1f + 0.2f * this.rand.nextFloat()));
                }
                this.getWorld().func_175688_a(particle, (double)(posX + randX * 0.5f), (double)(posY + this.rand.nextFloat() * 0.5f), (double)(posZ + this.rand.nextFloat() * 0.5f), (double)spdY, -((double)spdX), (double)spdZ, new int[0]);
                this.getWorld().func_175688_a(particle, (double)(posX + randY * 0.5f), (double)(posY + this.rand.nextFloat() * 0.5f), (double)(posZ + this.rand.nextFloat() * 0.5f), (double)spdY, -((double)spdX), (double)spdZ, new int[0]);
                this.getWorld().func_175688_a(particle, (double)(posX + randZ * 0.5f), (double)(posY + this.rand.nextFloat() * 0.5f), (double)(posZ + this.rand.nextFloat() * 0.5f), (double)spdY, -((double)spdX), (double)spdZ, new int[0]);
            }
        }
        this.fillContainerFromInternalTank((IFluidHandler)this.fluidTank);
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
        }
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.isWorkingEnabled = buf.readBoolean();
    }

    @Nullable
    public MultiblockAbility<IFluidTank> getAbility() {
        return MultiblockAbility.IMPORT_FLUIDS;
    }

    public void registerAbilities(@NotNull AbilityInstances abilities) {
        Intrinsics.checkNotNullParameter((Object)abilities, (String)"abilities");
        abilities.add((Object)this.fluidTank);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        GTLiteOverlays.AIR_INTAKE_HATCH_OVERLAY.renderSided(this.frontFacing, renderState, translation, pipeline);
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidTank);
        }
        return (T)super.getCapability(capability, side);
    }

    @NotNull
    protected FluidTankList createImportFluidHandler() {
        IFluidTank[] iFluidTankArray = new IFluidTank[]{this.fluidTank};
        return new FluidTankList(false, iFluidTankArray);
    }

    @Nullable
    protected IItemHandlerModifiable createImportItemHandler() {
        return (IItemHandlerModifiable)new FilteredItemHandler((MetaTileEntity)this).setFillPredicate(FilteredItemHandler.getCapabilityFilter((Capability)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @NotNull
    protected IItemHandlerModifiable createExportItemHandler() {
        return (IItemHandlerModifiable)new ItemStackHandler(1);
    }

    @NotNull
    public ModularPanel buildUI(@NotNull PosGuiData guiData, @NotNull PanelSyncManager syncManager) {
        Intrinsics.checkNotNullParameter((Object)guiData, (String)"guiData");
        Intrinsics.checkNotNullParameter((Object)syncManager, (String)"syncManager");
        syncManager.registerSlotGroup("item_inv", 2);
        GTFluidSyncHandler tankSyncHandler = GTFluidSlot.sync((IFluidTank)((IFluidTank)this.fluidTank)).showAmountOnSlot(false).accessibility(true, false);
        IDrawable[] iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.IN_SLOT_OVERLAY};
        ModularPanel modularPanel = (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel((MetaTileEntity)((MetaTileEntity)this), (int)176, (int)166).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Widget)((Widget)GTGuiTextures.DISPLAY.asWidget().left(7)).top(16)).size(81, 55))).child((IWidget)((Widget)((Widget)GTGuiTextures.TANK_ICON.asWidget().left(92)).top(36)).size(14, 15))).child((IWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)new RichTextWidget().size(75, 47)).pos(10, 20)).textColor(Color.WHITE.main)).alignment(Alignment.TopLeft)).autoUpdate(true).textBuilder(arg_0 -> PartMachineAirIntakeHatch.buildUI$lambda$3(tankSyncHandler, arg_0)))).child((IWidget)((GTFluidSlot)new GTFluidSlot().syncHandler(tankSyncHandler).pos(69, 52)).disableBackground())).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.importItems, (int)0).slotGroup("item_inv").filter(PartMachineAirIntakeHatch::buildUI$lambda$4)).background(iDrawableArray)).pos(90, 16));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.OUT_SLOT_OVERLAY};
        IParentWidget iParentWidget = modularPanel.child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.exportItems, (int)0).slotGroup("item_inv").accessibility(false, true)).background(iDrawableArray)).pos(90, 53));
        Intrinsics.checkNotNullExpressionValue((Object)iParentWidget, (String)"child(...)");
        return (ModularPanel)iParentWidget;
    }

    public boolean usesMui2() {
        return true;
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.air_intake_hatch.tooltip.1", (Object[])new Object[0]));
        Object[] objectArray = new Object[]{this.transferRate};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.air_intake_hatch.tooltip.2", (Object[])objectArray));
        objectArray = new Object[]{this.capacity};
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])objectArray));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    public void addToolUsages(@Nullable ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private static final void update$lambda$1(PartMachineAirIntakeHatch this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isWorkingEnabled);
    }

    private static final void update$lambda$2(PartMachineAirIntakeHatch this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isWorkingEnabled);
    }

    private static final void buildUI$lambda$3(GTFluidSyncHandler $tankSyncHandler, RichText it) {
        it.addLine((IDrawable)IKey.lang((String)"gregtech.gui.fluid_amount"));
        String name = $tankSyncHandler.getFluidLocalizedName();
        if (name == null) {
            return;
        }
        it.addLine((IDrawable)IKey.str((String)name));
        it.addLine((IDrawable)IKey.str((String)$tankSyncHandler.getFormattedFluidAmount()));
    }

    private static final boolean buildUI$lambda$4(ItemStack it) {
        return FluidUtil.getFluidHandler((ItemStack)it) != null;
    }
}

