/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.steam;

import gregtech.api.capability.impl.SteamMultiWorkable;
import gregtech.api.capability.impl.SteamMultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapSteamMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtechlite.gtlitecore.common.block.adapter.GTFireboxCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\b\u0010\u000f\u001a\u00020\fH\u0015J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0017\u00a8\u0006 "}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/steam/SteamMultiblockAlloySmelter;", "Lgregtech/api/metatileentity/multiblock/RecipeMapSteamMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "hasMaintenanceMechanics", "", "getItemOutputLimit", "", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "randomDisplayTick", "Companion", "gtlitecore"})
public final class SteamMultiblockAlloySmelter
extends RecipeMapSteamMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IBlockState casingState = ConfigHolder.machines.steelSteamMultiblocks ? GTMetalCasing.STEEL_SOLID.getState() : GTMetalCasing.BRONZE_BRICKS.getState();
    @NotNull
    private static final IBlockState fireboxCasingState = ConfigHolder.machines.steelSteamMultiblocks ? GTFireboxCasing.STEEL_FIREBOX.getState() : GTFireboxCasing.BRONZE_FIREBOX.getState();

    public SteamMultiblockAlloySmelter(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, RecipeMaps.ALLOY_SMELTER_RECIPES, RecipeMapSteamMultiblockController.CONVERSION_RATE);
        double d = RecipeMapSteamMultiblockController.CONVERSION_RATE;
        this.recipeMapWorkable = (SteamMultiblockRecipeLogic)new SteamMultiWorkable(this, d){

            public ParallelLogicType getParallelLogicType() {
                return ParallelLogicType.MULTIPLY;
            }
        };
        this.recipeMapWorkable.setParallelLimit(8);
    }

    @NotNull
    public SteamMultiblockAlloySmelter createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new SteamMultiblockAlloySmelter(resourceLocation);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCC", "FFF", "FFF", "CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCC", "F#F", "F#F", "CCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CSC", "FFF", "FFF", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('C', RecipeMapSteamMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(9).or(this.autoAbilities()));
        stringArray = new IBlockState[]{fireboxCasingState};
        BlockPattern blockPattern = factoryBlockPattern4.where('F', RecipeMapSteamMultiblockController.states((IBlockState[])stringArray)).where('#', RecipeMapSteamMultiblockController.air()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        ICubeRenderer iCubeRenderer;
        if (ConfigHolder.machines.steelSteamMultiblocks) {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.SOLID_STEEL_CASING;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"SOLID_STEEL_CASING");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        } else {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.BRONZE_PLATED_BRICKS;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"BRONZE_PLATED_BRICKS");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        }
        return iCubeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.ALLOY_SMELTER_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"ALLOY_SMELTER_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public int getItemOutputLimit() {
        return 1;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, player, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gregtech.multiblock.steam_.duration_modifier", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        Object[] objectArray = new Object[]{8};
        String string2 = I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        tooltip.add(TooltipHelper.BLINKING_ORANGE + I18n.func_135052_a((String)"gregtech.multiblock.require_steam_parts", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            EnumParticleTypes[] enumParticleTypesArray = new EnumParticleTypes[]{EnumParticleTypes.SMOKE_NORMAL};
            VanillaParticleEffects.defaultFrontEffect((MetaTileEntity)((MetaTileEntity)this), (float)0.4f, (EnumParticleTypes[])enumParticleTypesArray);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/steam/SteamMultiblockAlloySmelter$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "fireboxCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

