/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.primitive;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapPrimitiveMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.api.mui.widget.GhostCircuitSlotWidget;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.mui.widget.GTFluidSlot;
import gregtechlite.gtlitecore.api.gui.GTLiteMuiTextures;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.PrimitiveCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0002:;B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0014H\u0015J3\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001f\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020#H\u0016J\b\u0010-\u001a\u00020.H\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0014J0\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0006\u00109\u001a\u00020#H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockCoagulationTank;", "Lgregtech/api/metatileentity/multiblock/RecipeMapPrimitiveMultiblockController;", "Lgregtech/api/capability/IGhostSlotConfigurable;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "circuitInventory", "Lgregtech/api/capability/impl/GhostCircuitItemStackHandler;", "actualImportItems", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "initializeInventory", "", "getImportItems", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "update", "hasMaintenanceMechanics", "", "hasGhostCircuitInventory", "setGhostCircuitConfig", "config", "", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "usesMui2", "getUITheme", "Lgregtech/api/mui/GTGuiTheme;", "createUIFactory", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIFactory;", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "Companion", "CoagulationTankRecipeLogic", "gtlitecore"})
public final class MultiblockCoagulationTank
extends RecipeMapPrimitiveMultiblockController
implements IGhostSlotConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GhostCircuitItemStackHandler circuitInventory;
    @Nullable
    private IItemHandlerModifiable actualImportItems;
    @NotNull
    private static final IBlockState casingState = PrimitiveCasing.REINFORCED_TREATED_WOOD_WALL.getState();

    public MultiblockCoagulationTank(@NotNull ResourceLocation id) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id, GTLiteRecipeMaps.COAGULATION_RECIPES);
            this.recipeMapWorkable = new CoagulationTankRecipeLogic(this, GTLiteRecipeMaps.COAGULATION_RECIPES);
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory = new GhostCircuitItemStackHandler((MetaTileEntity)this);
            if (ghostCircuitItemStackHandler == null) break block0;
            ghostCircuitItemStackHandler.addNotifiableMetaTileEntity((MetaTileEntity)this);
        }
    }

    @NotNull
    public MultiblockCoagulationTank createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockCoagulationTank(resourceLocation);
    }

    protected void initializeInventory() {
        super.initializeInventory();
        this.actualImportItems = null;
    }

    @NotNull
    public IItemHandlerModifiable getImportItems() {
        if (this.actualImportItems == null) {
            IItemHandlerModifiable iItemHandlerModifiable;
            if (this.circuitInventory == null) {
                iItemHandlerModifiable = super.getImportItems();
            } else {
                Object[] objectArray = new IItemHandlerModifiable[]{super.getImportItems(), this.circuitInventory};
                iItemHandlerModifiable = (IItemHandlerModifiable)new ItemHandlerList(CollectionsKt.listOf((Object[])objectArray));
            }
            this.actualImportItems = iItemHandlerModifiable;
        }
        IItemHandlerModifiable iItemHandlerModifiable = this.actualImportItems;
        Intrinsics.checkNotNull((Object)iItemHandlerModifiable);
        return iItemHandlerModifiable;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCC", "CCC", "CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCC", "C*C", "C#C"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CSC", "CCC", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = RecipeMapPrimitiveMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.EXPORT_ITEMS};
        BlockPattern blockPattern = factoryBlockPattern3.where('C', traceabilityPredicate.or(RecipeMapPrimitiveMultiblockController.abilities((MultiblockAbility[])stringArray))).where('#', RecipeMapPrimitiveMultiblockController.air()).where('*', RecipeMapPrimitiveMultiblockController.air().or(TraceabilityPredicates.getSNOW_LAYER())).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.REINFORCED_TREATED_WOOD_WALL;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.COAGULATION_TANK_OVERLAY;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.frontFacing, this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    public void update() {
        super.update();
        if (this.getOffsetTimer() % (long)5 * 1L == 0L && this.isStructureFormed()) {
            for (IFluidTank tank : this.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
                if (tank.getFluid() == null) continue;
                NonNullList fluidStacks = NonNullList.func_191196_a();
                int toFill = this.importFluids.getTankAt(0).getCapacity() - this.importFluids.getTankAt(0).getFluidAmount();
                int amount = Math.min(tank.getFluidAmount(), toFill);
                fluidStacks.add((Object)new FluidStack(tank.getFluid(), amount));
                if (!GTTransferUtils.addFluidsToFluidHandler((IMultipleTankHandler)((IMultipleTankHandler)this.importFluids), (boolean)true, (List)((List)fluidStacks))) continue;
                GTTransferUtils.addFluidsToFluidHandler((IMultipleTankHandler)((IMultipleTankHandler)this.importFluids), (boolean)false, (List)((List)fluidStacks));
                tank.drain(amount, true);
            }
            int n = this.exportItems.getSlots();
            for (int i = 0; i < n; ++i) {
                ItemStack stack;
                Intrinsics.checkNotNullExpressionValue((Object)this.exportItems.getStackInSlot(i), (String)"getStackInSlot(...)");
                this.exportItems.setStackInSlot(i, ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS))), (ItemStack)stack, (boolean)false));
            }
            this.fillInternalTankFromFluidContainer();
        }
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean hasGhostCircuitInventory() {
        return true;
    }

    public void setGhostCircuitConfig(int config) {
        block5: {
            block4: {
                if (this.circuitInventory == null) break block4;
                GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
                Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
                if (ghostCircuitItemStackHandler.getCircuitValue() != config) break block5;
            }
            return;
        }
        GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
        Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
        ghostCircuitItemStackHandler.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        if (this.circuitInventory != null) {
            GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
            Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
            ghostCircuitItemStackHandler.write(data);
        }
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        if (this.circuitInventory != null) {
            if (data.func_150297_b("CircuitInventory", 10)) {
                ItemStackHandler currentCircuitInventory = new ItemStackHandler();
                int n = currentCircuitInventory.getSlots();
                for (int i = 0; i < n; ++i) {
                    ItemStack stack;
                    Intrinsics.checkNotNullExpressionValue((Object)currentCircuitInventory.getStackInSlot(i), (String)"getStackInSlot(...)");
                    if (stack.func_190926_b()) continue;
                    stack = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)this.importItems), (ItemStack)stack, (boolean)false);
                    GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
                    Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
                    ghostCircuitItemStackHandler.setCircuitValueFromStack(stack);
                }
            } else {
                GhostCircuitItemStackHandler ghostCircuitItemStackHandler = this.circuitInventory;
                Intrinsics.checkNotNull((Object)ghostCircuitItemStackHandler);
                ghostCircuitItemStackHandler.read(data);
            }
        }
    }

    public boolean usesMui2() {
        return true;
    }

    @NotNull
    public GTGuiTheme getUITheme() {
        GTGuiTheme gTGuiTheme = GTGuiTheme.PRIMITIVE;
        Intrinsics.checkNotNullExpressionValue((Object)gTGuiTheme, (String)"PRIMITIVE");
        return gTGuiTheme;
    }

    @Nullable
    protected MultiblockUIFactory createUIFactory() {
        return new MultiblockUIFactory((MultiblockWithDisplayBase)this).setSize(176, 166).disableDisplay().disableButtons().addScreenChildren((arg_0, arg_1) -> MultiblockCoagulationTank.createUIFactory$lambda$2(this, arg_0, arg_1));
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.coagulation_tank.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.coagulation_tank.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.coagulation_tank.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        Object[] objectArray = new Object[]{8};
        String string4 = I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
    }

    private static final boolean createUIFactory$lambda$2$lambda$0() {
        return true;
    }

    private static final boolean createUIFactory$lambda$2$lambda$1() {
        return true;
    }

    private static final void createUIFactory$lambda$2(MultiblockCoagulationTank this$0, ParentWidget parent, PanelSyncManager guiSyncManager) {
        guiSyncManager.registerSlotGroup("item_inv", 3, true);
        GTFluidSyncHandler tankSyncManager1 = GTFluidSlot.sync((IFluidTank)((IFluidTank)this$0.importFluids.getTankAt(0))).accessibility(true, true).showAmountOnSlot(MultiblockCoagulationTank::createUIFactory$lambda$2$lambda$0);
        GTFluidSyncHandler tankSyncManager2 = GTFluidSlot.sync((IFluidTank)((IFluidTank)this$0.importFluids.getTankAt(1))).accessibility(true, true).showAmountOnSlot(MultiblockCoagulationTank::createUIFactory$lambda$2$lambda$1);
        IDrawable[] iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT_PRIMITIVE};
        ParentWidget parentWidget = (ParentWidget)((ParentWidget)((ParentWidget)parent.child((IWidget)KeyUtil.lang((String)this$0.getMetaFullName(), (Object[])new Object[0]).asWidget().pos(6, 6))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this$0.importItems, (int)0).slotGroup("item_inv")).background(iDrawableArray)).pos(30, 30));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT_PRIMITIVE};
        ParentWidget parentWidget2 = (ParentWidget)parentWidget.child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this$0.importItems, (int)1).slotGroup("item_inv")).background(iDrawableArray)).pos(48, 30));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT_PRIMITIVE};
        ParentWidget parentWidget3 = (ParentWidget)parentWidget2.child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this$0.exportItems, (int)0).slotGroup("item_inv").accessibility(false, true)).background(iDrawableArray)).pos(106, 39));
        iDrawableArray = new IDrawable[]{GTLiteMuiTextures.PRIMITIVE_FLUID_SLOT};
        ParentWidget parentWidget4 = (ParentWidget)parentWidget3.child((IWidget)((GTFluidSlot)new GTFluidSlot().syncHandler(tankSyncManager1).pos(30, 48)).background(iDrawableArray));
        iDrawableArray = new IDrawable[]{GTLiteMuiTextures.PRIMITIVE_FLUID_SLOT};
        ParentWidget parentWidget5 = (ParentWidget)parentWidget4.child((IWidget)((GTFluidSlot)new GTFluidSlot().syncHandler(tankSyncManager2).pos(48, 48)).background(iDrawableArray));
        iDrawableArray = new IDrawable[]{GTGuiTextures.SLOT_PRIMITIVE, GTLiteMuiTextures.PRIMITIVE_INT_CIRCUIT_OVERLAY};
        ((ParentWidget)parentWidget5.child((IWidget)((ItemSlot)new GhostCircuitSlotWidget().slot((IItemHandlerModifiable)this$0.circuitInventory, 0).background(iDrawableArray)).pos(124, 62))).child((IWidget)((ProgressWidget)((ProgressWidget)new ProgressWidget().pos(76, 41)).size(20, 15)).texture(GTGuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR, 100).value((IDoubleValue)new DoubleSyncValue(() -> ((PrimitiveRecipeLogic)this$0.recipeMapWorkable).getProgressPercent())).direction(ProgressWidget.Direction.RIGHT));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockCoagulationTank$CoagulationTankRecipeLogic;", "Lgregtech/api/capability/impl/PrimitiveRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapPrimitiveMultiblockController;", "recipeMap", "Lgregtech/api/recipes/RecipeMap;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockCoagulationTank;Lgregtech/api/metatileentity/multiblock/RecipeMapPrimitiveMultiblockController;Lgregtech/api/recipes/RecipeMap;)V", "getParallelLimit", "", "getMaxParallelVoltage", "", "getParallelLogicType", "Lgregtech/api/metatileentity/multiblock/ParallelLogicType;", "gtlitecore"})
    private final class CoagulationTankRecipeLogic
    extends PrimitiveRecipeLogic {
        public CoagulationTankRecipeLogic(@NotNull RecipeMapPrimitiveMultiblockController metaTileEntity, RecipeMap<?> recipeMap) {
            Intrinsics.checkNotNullParameter((Object)metaTileEntity, (String)"metaTileEntity");
            Intrinsics.checkNotNullParameter(recipeMap, (String)"recipeMap");
            super(metaTileEntity, recipeMap);
        }

        public int getParallelLimit() {
            return 8;
        }

        protected long getMaxParallelVoltage() {
            return 2147432767L;
        }

        @NotNull
        public ParallelLogicType getParallelLogicType() {
            return ParallelLogicType.MULTIPLY;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockCoagulationTank$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

