/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.primitive;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtechlite.gtlitecore.api.capability.logic.NoEnergyMultiblockRecipeLogic;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTFireboxCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0012H\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J3\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001f\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020%H\u0016J0\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0006\u0010-\u001a\u00020%H\u0016J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockAdvancedPrimitiveBlastFurnace;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "auxiliaryFurnaceNumber", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "getUITheme", "Lgregtech/api/mui/GTGuiTheme;", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "getMatchingShapes", "", "Lgregtech/api/pattern/MultiblockShapeInfo;", "hasMaintenanceMechanics", "", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "advanced", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "Companion", "IndustrialPBFRecipeLogic", "gtlitecore"})
public final class MultiblockAdvancedPrimitiveBlastFurnace
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int auxiliaryFurnaceNumber;
    @NotNull
    private static final IBlockState casingState = GTMetalCasing.PRIMITIVE_BRICKS.getState();
    @NotNull
    private static final IBlockState fireboxCasingState = GTFireboxCasing.STEEL_FIREBOX.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.STEEL_PIPE.getState();

    public MultiblockAdvancedPrimitiveBlastFurnace(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES);
        this.recipeMapWorkable = new IndustrialPBFRecipeLogic(this);
    }

    @NotNull
    public MultiblockAdvancedPrimitiveBlastFurnace createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockAdvancedPrimitiveBlastFurnace(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        if (context.get("AuxiliaryFurnace1") != null) {
            ++this.auxiliaryFurnaceNumber;
        }
        if (context.get("AuxiliaryFurnace2") != null) {
            ++this.auxiliaryFurnaceNumber;
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"     DDD     ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"    CDDDC    ", "    CDDDC    ", "    CDDDC    ", "     DDD     ", "             ", "             ", "             ", "             ", "             "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"AAAGDDDDDJFFF", "GGG D###D JJJ", " G  D###D  J ", " G  D###D  J ", " G   DDD   J ", " G    D    J ", "      D      ", "      D      ", "      D      "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"AAAGDDDDDJFFF", "GoGHD#o#DIJoJ", "G#G D###D J#J", "G#G D###D J#J", "G#G D###D J#J", "G#G  D#D  J#J", "     D#D     ", "     D#D     ", "     D#D     "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"AAAGDDDDDJFFF", "GGG D###D JJJ", " G  D###D  J ", " G  D###D  J ", " G   DDD   J ", " G    D    J ", "      D      ", "      D      ", "      D      "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"    CDDDC    ", "    CDSDC    ", "    CDDDC    ", "     DDD     ", "             ", "             ", "             ", "             ", "             "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"     DDD     ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new Material[]{Materials.Steel};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('C', RecipeMapMultiblockController.frames((Material[])stringArray));
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.where('D', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(69).or(this.autoAbilities(false, false, true, true, false, false, false)));
        stringArray = new IBlockState[]{fireboxCasingState};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.where('A', TraceabilityPredicates.optionalStates("AuxiliaryFurnace1", (IBlockState[])stringArray));
        stringArray = new IBlockState[]{fireboxCasingState};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.where('F', TraceabilityPredicates.optionalStates("AuxiliaryFurnace2", (IBlockState[])stringArray));
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.where('G', TraceabilityPredicates.optionalStates("AuxiliaryFurnace1", (IBlockState[])stringArray));
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.where('J', TraceabilityPredicates.optionalStates("AuxiliaryFurnace2", (IBlockState[])stringArray));
        stringArray = new IBlockState[]{pipeCasingState};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.where('H', TraceabilityPredicates.optionalStates("AuxiliaryFurnace1", (IBlockState[])stringArray));
        stringArray = new IBlockState[]{pipeCasingState};
        BlockPattern blockPattern = factoryBlockPattern14.where('I', TraceabilityPredicates.optionalStates("AuxiliaryFurnace2", (IBlockState[])stringArray)).where('#', RecipeMapMultiblockController.air()).where('o', RecipeMapMultiblockController.air().or(TraceabilityPredicates.getSNOW_LAYER())).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        SimpleOverlayRenderer simpleOverlayRenderer = Textures.PRIMITIVE_BRICKS;
        Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"PRIMITIVE_BRICKS");
        return (ICubeRenderer)simpleOverlayRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.PRIMITIVE_BLAST_FURNACE_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"PRIMITIVE_BLAST_FURNACE_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    @NotNull
    public GTGuiTheme getUITheme() {
        GTGuiTheme gTGuiTheme = GTGuiTheme.STEEL;
        Intrinsics.checkNotNullExpressionValue((Object)gTGuiTheme, (String)"STEEL");
        return gTGuiTheme;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.frontFacing, this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    @NotNull
    public List<MultiblockShapeInfo> getMatchingShapes() {
        List shapeInfo = new ArrayList();
        Object[] objectArray = new RelativeDirection[]{RelativeDirection.RIGHT, RelativeDirection.DOWN, RelativeDirection.FRONT};
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder((RelativeDirection[])objectArray);
        objectArray = new String[]{"     DDD     ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
        MultiblockShapeInfo.Builder builder2 = builder.aisle((String[])objectArray);
        objectArray = new String[]{"    CDDDC    ", "    CDDDC    ", "    CDDDC    ", "     DDD     ", "             ", "             ", "             ", "             ", "             "};
        MultiblockShapeInfo.Builder builder3 = builder2.aisle((String[])objectArray);
        objectArray = new String[]{"AAAGDDDDDJFFF", "GGG D   D JJJ", " G  D   D  J ", " G  D   D  J ", " G   DDD   J ", " G    D    J ", "      D      ", "      D      ", "      D      "};
        MultiblockShapeInfo.Builder builder4 = builder3.aisle((String[])objectArray);
        objectArray = new String[]{"AAAGDDDDDJFFF", "G GHD   DIJ J", "G G D   D J J", "G*G D   D J!J", "G G D   D J J", "G G  D D  J J", "     D D     ", "     D D     ", "     D D     "};
        MultiblockShapeInfo.Builder builder5 = builder4.aisle((String[])objectArray);
        objectArray = new String[]{"AAAGDDDDDJFFF", "GGG D   D JJJ", " G  D   D  J ", " G  D   D  J ", " G   DDD   J ", " G    D    J ", "      D      ", "      D      ", "      D      "};
        MultiblockShapeInfo.Builder builder6 = builder5.aisle((String[])objectArray);
        objectArray = new String[]{"    CDDDC    ", "    CXSYC    ", "    CDDDC    ", "     DDD     ", "             ", "             ", "             ", "             ", "             "};
        MultiblockShapeInfo.Builder builder7 = builder6.aisle((String[])objectArray);
        objectArray = new String[]{"     DDD     ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
        MultiblockShapeInfo.Builder builder8 = builder7.aisle((String[])objectArray).where('S', (MetaTileEntity)GTLiteMetaTileEntities.INSTANCE.getINDUSTRIAL_PRIMITIVE_BLAST_FURNACE(), EnumFacing.SOUTH);
        Object v = MetaBlocks.FRAMES.get(Materials.Steel);
        Intrinsics.checkNotNull(v);
        MultiblockShapeInfo.Builder builder9 = builder8.where('C', ((BlockFrame)v).getBlock(Materials.Steel)).where('D', casingState).where('X', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[0], EnumFacing.SOUTH).where('Y', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[0], EnumFacing.SOUTH);
        MultiblockShapeInfo multiblockShapeInfo = builder9.build();
        Intrinsics.checkNotNullExpressionValue((Object)multiblockShapeInfo, (String)"build(...)");
        shapeInfo.add(multiblockShapeInfo);
        MultiblockShapeInfo multiblockShapeInfo2 = builder9.where('A', fireboxCasingState).where('G', casingState).where('H', pipeCasingState).build();
        Intrinsics.checkNotNullExpressionValue((Object)multiblockShapeInfo2, (String)"build(...)");
        shapeInfo.add(multiblockShapeInfo2);
        MultiblockShapeInfo multiblockShapeInfo3 = builder9.where('F', fireboxCasingState).where('I', pipeCasingState).where('J', casingState).build();
        Intrinsics.checkNotNullExpressionValue((Object)multiblockShapeInfo3, (String)"build(...)");
        shapeInfo.add(multiblockShapeInfo3);
        return shapeInfo;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.industrial_primitive_blast_furnace.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.industrial_primitive_blast_furnace.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.industrial_primitive_blast_furnace.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockAdvancedPrimitiveBlastFurnace$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "fireboxCasingState", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockAdvancedPrimitiveBlastFurnace$IndustrialPBFRecipeLogic;", "Lgregtechlite/gtlitecore/api/capability/logic/NoEnergyMultiblockRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/primitive/MultiblockAdvancedPrimitiveBlastFurnace;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "setMaxProgress", "", "maxProgress", "", "gtlitecore"})
    private final class IndustrialPBFRecipeLogic
    extends NoEnergyMultiblockRecipeLogic {
        public IndustrialPBFRecipeLogic(RecipeMapMultiblockController metaTileEntity) {
            Intrinsics.checkNotNullParameter((Object)metaTileEntity, (String)"metaTileEntity");
            super(metaTileEntity);
        }

        public void setMaxProgress(int maxProgress) {
            if (MultiblockAdvancedPrimitiveBlastFurnace.this.isStructureFormed()) {
                int n;
                switch (MultiblockAdvancedPrimitiveBlastFurnace.this.auxiliaryFurnaceNumber) {
                    case 1: {
                        n = maxProgress / 8;
                        break;
                    }
                    case 2: {
                        n = maxProgress / 16;
                        break;
                    }
                    default: {
                        n = maxProgress;
                    }
                }
                this.maxProgressTime = n;
            }
        }
    }
}

