/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.module;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.ConfigHolder;
import gregtechlite.gtlitecore.api.metatileentity.multiblock.ModuleMultiblockBase;
import gregtechlite.gtlitecore.api.recipe.frontend.SpacePumpRecipeFrontend;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.aerospace.AerospaceCasing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0001;B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000f\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0015J3\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010#J2\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0*2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0018\u00101\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00052\u0006\u00102\u001a\u00020+H\u0002J\u0010\u00103\u001a\u00020+2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0018\u00104\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00052\u0006\u00102\u001a\u00020+H\u0002J\b\u00105\u001a\u00020\u0013H\u0014J\b\u00106\u001a\u00020-H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016J\u0010\u0010:\u001a\u00020\u00132\u0006\u00109\u001a\u000208H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpacePump;", "Lgregtechlite/gtlitecore/api/metatileentity/multiblock/ModuleMultiblockBase;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "moduleTier", "minCasingTier", "<init>", "(Lnet/minecraft/util/ResourceLocation;III)V", "outputFluidInventory", "Lgregtech/api/capability/IMultipleTankHandler;", "planets", "", "fluids", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "initializeAbilities", "", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "getOrbitTier", "getPlanetValue", "index", "setPlanetValue", "value", "getFluidValue", "setFluidValue", "updateFormedValid", "checkRecipes", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "Companion", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMultiblockSpacePump.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockSpacePump.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpacePump\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n1#2:388\n1863#3,2:389\n*S KotlinDebug\n*F\n+ 1 MultiblockSpacePump.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpacePump\n*L\n326#1:389,2\n*E\n"})
public final class MultiblockSpacePump
extends ModuleMultiblockBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IMultipleTankHandler outputFluidInventory;
    @NotNull
    private final int[] planets;
    @NotNull
    private final int[] fluids;
    @NotNull
    private static final IBlockState casingState = AerospaceCasing.ELEVATOR_BASE_CASING.getState();

    public MultiblockSpacePump(@NotNull ResourceLocation metaTileEntityId, int tier, int moduleTier, int minCasingTier) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        super(metaTileEntityId, tier, moduleTier, minCasingTier);
        int[] nArray = new int[]{0, 0, 0, 0};
        this.planets = nArray;
        nArray = new int[]{0, 0, 0, 0};
        this.fluids = nArray;
        this.maxProgress = moduleTier == 3 ? 20 : 80;
    }

    @NotNull
    public MultiblockSpacePump createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockSpacePump(resourceLocation, this.getTier(), this.getModuleTier(), this.getMinCasingTier());
    }

    @Override
    protected void initializeAbilities() {
        this.outputFluidInventory = (IMultipleTankHandler)new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"C", "C", "C", "C", "C"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"C", "C", "C", "S", "C"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiblockWithDisplayBase.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS};
        BlockPattern blockPattern = factoryBlockPattern2.where('C', traceabilityPredicate.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(0))).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.SPACE_ELEVATOR_BASE_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.SPACE_ELEVATOR_OVERLAY;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Iterator iterator = ArrayIteratorKt.iterator((Object[])EnumFacing.field_176754_o);
        while (iterator.hasNext()) {
            EnumFacing renderSide = (EnumFacing)iterator.next();
            if (renderSide == this.getFrontFacing()) {
                this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
                continue;
            }
            GTLiteOverlays.SPACE_PUMP_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
        }
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.tooltip.1", (Object[])new Object[0]));
        switch (this.getModuleTier()) {
            case 1: {
                boolean bl = tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.mk1.tooltip.1", (Object[])new Object[0]));
                break;
            }
            case 2: {
                boolean bl = tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.mk2.tooltip.1", (Object[])new Object[0]));
                break;
            }
            default: {
                boolean bl = tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.mk3.tooltip.1", (Object[])new Object[0]));
            }
        }
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.tooltip.2", (Object[])new Object[0]));
        boolean bl = this.getModuleTier() == 1 ? tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.tooltip.3", (Object[])new Object[0])) : tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.tooltip.4", (Object[])new Object[0]));
        if (this.getModuleTier() == 3) {
            tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.tooltip.5", (Object[])new Object[0]));
        }
        Object[] objectArray = new Object[]{GTValues.VNF[this.getTier()]};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.max_parallel", (Object[])objectArray));
        objectArray = new Object[]{this.getOrbitTier(this.getModuleTier())};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_pump_module.orbit_tier", (Object[])objectArray));
    }

    private final String getOrbitTier(int moduleTier) {
        String string;
        switch (moduleTier) {
            case 1: {
                string = "MK1";
                break;
            }
            case 2: {
                string = "MK2";
                break;
            }
            default: {
                string = "MK4";
            }
        }
        return string;
    }

    private final String getPlanetValue(int index) {
        return String.valueOf(this.planets[index]);
    }

    private final void setPlanetValue(int index, String value) {
        this.planets[index] = Integer.parseInt(value);
    }

    private final String getFluidValue(int index) {
        return String.valueOf(this.fluids[index]);
    }

    private final void setFluidValue(int index, String value) {
        this.fluids[index] = Integer.parseInt(value);
    }

    @Override
    protected void updateFormedValid() {
        super.updateFormedValid();
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.drainEnergy(true)) {
            if (this.progress >= 2) {
                this.progress = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progress - 2);
            }
            return;
        }
        if (this.progress == 0 && !this.checkRecipes()) {
            this.setActive(false);
        } else {
            this.drainEnergy(false);
            this.setActive(true);
            int n = this.progress;
            this.progress = n + 1;
            if (this.progress % this.maxProgress != 0) {
                return;
            }
            this.progress = 0;
            ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
            for (int i = 0; i < 4; ++i) {
                FluidStack it;
                if (!SpacePumpRecipeFrontend.INSTANCE.getRECIPES().containsKey((Object)new Pair((Object)this.planets[i], (Object)this.fluids[i]))) continue;
                if ((FluidStack)SpacePumpRecipeFrontend.INSTANCE.getRECIPES().get((Object)new Pair((Object)this.planets[i], (Object)this.fluids[i])) == null) continue;
                boolean bl = false;
                fluidStacks.add(it);
            }
            Iterable $this$forEach$iv = fluidStacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FluidStack fluidStack = (FluidStack)element$iv;
                boolean bl = false;
                IMultipleTankHandler iMultipleTankHandler = this.outputFluidInventory;
                if (iMultipleTankHandler == null) continue;
                iMultipleTankHandler.fill(fluidStack, true);
            }
        }
    }

    private final boolean checkRecipes() {
        if (this.getModuleTier() > 1) {
            for (int i = 0; i < 4; ++i) {
                FluidStack fluidStack = (FluidStack)SpacePumpRecipeFrontend.INSTANCE.getRECIPES().get((Object)new Pair((Object)this.planets[i], (Object)this.fluids[i]));
                if (fluidStack == null) continue;
                return true;
            }
        } else {
            FluidStack fluidStack = (FluidStack)SpacePumpRecipeFrontend.INSTANCE.getRECIPES().get((Object)new Pair((Object)this.planets[0], (Object)this.fluids[0]));
            return fluidStack != null;
        }
        return false;
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        NBTTagList planetsNBT = new NBTTagList();
        NBTTagList fluidsNBT = new NBTTagList();
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound planetNBT = new NBTTagCompound();
            planetNBT.func_74768_a("planet", this.planets[i]);
            planetsNBT.func_74742_a((NBTBase)planetNBT);
            NBTTagCompound fluidNBT = new NBTTagCompound();
            fluidNBT.func_74768_a("fluid", this.fluids[i]);
            fluidsNBT.func_74742_a((NBTBase)fluidNBT);
        }
        data.func_74782_a("planets", (NBTBase)planetsNBT);
        data.func_74782_a("fluids", (NBTBase)fluidsNBT);
        return data;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        NBTTagList planetsNBT = data.func_150295_c("planets", 10);
        NBTTagList fluidsNBT = data.func_150295_c("fluids", 10);
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound planetNBT = planetsNBT.func_150305_b(i);
            this.planets[i] = planetNBT.func_74762_e("planet");
            NBTTagCompound fluidNBT = fluidsNBT.func_150305_b(i);
            this.fluids[i] = fluidNBT.func_74762_e("fluid");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpacePump$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

