/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.module;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.capability.ModuleProvider;
import gregtechlite.gtlitecore.api.metatileentity.multiblock.RecipeMapModuleMultiblockController;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeProperties;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.aerospace.AerospaceCasing;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0002+,B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0012H\u0015J3\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020(H\u0016\u00a8\u0006-"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpaceAssembler;", "Lgregtechlite/gtlitecore/api/metatileentity/multiblock/RecipeMapModuleMultiblockController;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "moduleTier", "minCasingTier", "<init>", "(Lnet/minecraft/util/ResourceLocation;III)V", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "initializeAbilities", "", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "getOrbitTier", "canBeDistinct", "Companion", "SpaceAssemblerRecipeLogic", "gtlitecore"})
public final class MultiblockSpaceAssembler
extends RecipeMapModuleMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IBlockState casingState = AerospaceCasing.ELEVATOR_BASE_CASING.getState();

    public MultiblockSpaceAssembler(@NotNull ResourceLocation metaTileEntityId, int tier, int moduleTier, int minCasingTier) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        super(metaTileEntityId, GTLiteRecipeMaps.SPACE_ASSEMBLER_RECIPES, tier, moduleTier, minCasingTier);
        this.recipeMapWorkable = new SpaceAssemblerRecipeLogic(this);
    }

    @NotNull
    public MultiblockSpaceAssembler createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockSpaceAssembler(resourceLocation, this.getTier(), this.getModuleTier(), this.getMinCasingTier());
    }

    @Override
    protected void initializeAbilities() {
        this.inputInventory = (IItemHandlerModifiable)new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.inputFluidInventory = (IMultipleTankHandler)new FluidTankList(this.allowSameFluidFillForOutputs(), this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.extendedFluidInputs = this.extendedImportFluidList(this.inputFluidInventory);
        this.outputInventory = (IItemHandlerModifiable)new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"C", "C", "C", "C", "C"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"C", "C", "C", "S", "C"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.IMPORT_FLUIDS};
        BlockPattern blockPattern = factoryBlockPattern2.where('C', traceabilityPredicate.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(0))).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.SPACE_ELEVATOR_BASE_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.SPACE_ELEVATOR_OVERLAY;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Iterator iterator = ArrayIteratorKt.iterator((Object[])EnumFacing.field_176754_o);
        while (iterator.hasNext()) {
            EnumFacing renderSide = (EnumFacing)iterator.next();
            if (renderSide == this.getFrontFacing()) {
                this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
                continue;
            }
            GTLiteOverlays.SPACE_ASSEMBLER_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
        }
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_assembler_module.tooltip", (Object[])new Object[0]));
        switch (this.getModuleTier()) {
            case 1: {
                boolean bl = tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_assembler_module.mk1.tooltip.1", (Object[])new Object[0]));
                break;
            }
            case 2: {
                boolean bl = tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_assembler_module.mk2.tooltip.1", (Object[])new Object[0]));
                break;
            }
            default: {
                boolean bl = tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_assembler_module.mk3.tooltip.1", (Object[])new Object[0]));
            }
        }
        Object[] objectArray = new Object[]{GTValues.VNF[this.getTier()], this.recipeMapWorkable.getParallelLimit()};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_assembler_module.max_parallel", (Object[])objectArray));
        objectArray = new Object[]{this.getOrbitTier(this.getModuleTier())};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.space_assembler_module.orbit_tier", (Object[])objectArray));
    }

    private final String getOrbitTier(int moduleTier) {
        String string;
        switch (moduleTier) {
            case 1: {
                string = "MK1";
                break;
            }
            case 2: {
                string = "MK2";
                break;
            }
            default: {
                string = "MK3";
            }
        }
        return string;
    }

    public boolean canBeDistinct() {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpaceAssembler$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpaceAssembler$SpaceAssemblerRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "metaTileEntity", "Lgregtechlite/gtlitecore/api/metatileentity/multiblock/RecipeMapModuleMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/module/MultiblockSpaceAssembler;Lgregtechlite/gtlitecore/api/metatileentity/multiblock/RecipeMapModuleMultiblockController;)V", "checkRecipe", "", "recipe", "Lgregtech/api/recipes/Recipe;", "getParallelLimit", "", "gtlitecore"})
    private final class SpaceAssemblerRecipeLogic
    extends MultiblockRecipeLogic {
        public SpaceAssemblerRecipeLogic(RecipeMapModuleMultiblockController metaTileEntity) {
            super((RecipeMapMultiblockController)metaTileEntity);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkRecipe(@NotNull Recipe recipe) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            if (MultiblockSpaceAssembler.this.getModuleProvider() == null) return false;
            if (!super.checkRecipe(recipe)) return false;
            Object object = recipe.getProperty(GTLiteRecipeProperties.INSTANCE.getACCELERATION_TRACK_TIER(), (Object)0);
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            ModuleProvider moduleProvider = MultiblockSpaceAssembler.this.getModuleProvider();
            Intrinsics.checkNotNull((Object)moduleProvider);
            if (n > moduleProvider.getCasingTier()) return false;
            return true;
        }

        public int getParallelLimit() {
            int n;
            switch (MultiblockSpaceAssembler.this.getModuleTier()) {
                case 1: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 16;
                    break;
                }
                default: {
                    n = 64;
                }
            }
            return n;
        }
    }
}

