/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.mega;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.GTValues;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.HeatingCoilRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.OCParams;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.recipes.properties.impl.TemperatureProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockWireCoil;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.GlassCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import gregtechlite.gtlitecore.common.block.variant.science.ScienceCasing;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u00012\u00020\u0002:\u000267B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0014J2\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\bH\u0016J\b\u0010.\u001a\u00020$H\u0016J\b\u0010/\u001a\u00020$H\u0016J\u0018\u00100\u001a\u00020$2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020$H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002050!H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/mega/MultiblockEntrodynamicallyPhaseChanger;", "Lgregtech/api/metatileentity/multiblock/MultiMapMultiblockController;", "Lgregtech/api/capability/IHeatingCoil;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "tier", "", "level", "temperature", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "addHeatCapacity", "keyManager", "Lgregtech/api/metatileentity/multiblock/ui/KeyManager;", "syncer", "Lgregtech/api/metatileentity/multiblock/ui/UISyncer;", "getCurrentTemperature", "hasMaintenanceMechanics", "canBeDistinct", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "consumeIfSuccess", "getDataInfo", "Lnet/minecraft/util/text/ITextComponent;", "Companion", "EntrodynamicallyPhaseChangerRecipeLogic", "gtlitecore"})
public final class MultiblockEntrodynamicallyPhaseChanger
extends MultiMapMultiblockController
implements IHeatingCoil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int tier;
    private int level;
    private int temperature;
    @NotNull
    private static final IBlockState casingState = MultiblockCasing.LATTICE_QCD_THERMAL_SHIELDING_CASING.getState();
    @NotNull
    private static final IBlockState secondCasingState = MultiblockCasing.HAMILTON_KILLING_FLOW_CONTROL_CASING.getState();
    @NotNull
    private static final IBlockState thirdCasingState = MetalCasing.NEUTRONIUM.getState();
    @NotNull
    private static final IBlockState fourthCasingState = ScienceCasing.DIMENSIONAL_BRIDGE_CASING.getState();
    @NotNull
    private static final IBlockState glassState = GlassCasing.NANO_SHIELDING_FRAME.getState();

    public MultiblockEntrodynamicallyPhaseChanger(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RecipeMap[] recipeMapArray = new RecipeMap[]{GTLiteRecipeMaps.TOPOLOGICAL_ORDER_CHANGING_RECIPES, GTLiteRecipeMaps.ALLOY_BLAST_RECIPES};
        super(id, recipeMapArray);
        this.recipeMapWorkable = (MultiblockRecipeLogic)new EntrodynamicallyPhaseChangerRecipeLogic((RecipeMapMultiblockController)this);
    }

    @NotNull
    public MultiblockEntrodynamicallyPhaseChanger createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockEntrodynamicallyPhaseChanger(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.tier = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getTier();
        this.level = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getLevel();
        this.temperature = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getCoilTemperature();
        this.temperature += 1000 * Math.max(0, GTUtility.getTierByVoltage((long)this.energyContainer.getInputVoltage()) - 1);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.tier = 0;
        this.level = 0;
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        this.energyContainer = (IEnergyContainer)new EnergyContainerList((List)inputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"         AAAAA         ", "         AAAAA         ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "         AAAAA         ", "         AAAAA         "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"      AAAAAAAAAAA      ", "      AAAAAAAAAAA      ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "      AAAAAAAAAAA      ", "      AAAAAAAAAAA      "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"    AAAAAAAAAAAAAAA    ", "    AAAAACCCCCAAAAA    ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "    AAAAACCCCCAAAAA    ", "    AAAAAAAAAAAAAAA    "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"   AAAAAAAAAAAAAAAAA   ", "   AAACCCEEEEECCCAAA   ", "      DDDFFFFFDDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDDFFFFFDDD      ", "   AAACCCEEEEECCCAAA   ", "   AAAAAAAAAAAAAAAAA   "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"  AAAAAAAAAAAAAAAAAAA  ", "  AACCEEEEEEEEEEECCAA  ", "    DDFFF     FFFDD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DDFFF     FFFDD    ", "  AACCEEEEEEEEEEECCAA  ", "  AAAAAAAAAAAAAAAAAAA  "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"  AAAAAAAAAAAAAAAAAAA  ", "  AACEEEEEEEEEEEEECAA  ", "    DF   GGGGG   FD    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    DF   GGGGG   FD    ", "  AACEEEEEEEEEEEEECAA  ", "  AAAAAAAAAAAAAAAAAAA  "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{" AAAAAAAAAAAAAAAAAAAAA ", " AACEEEEECCCCCEEEEECAA ", "   DF  GG     GG  FD   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   DF  GG     GG  FD   ", " AACEEEEECCCCCEEEEECAA ", " AAAAAAAAAAAAAAAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{" AAAAAAAAAAAAAAAAAAAAA ", " AACEEECCAAAAACCEEECAA ", "   DF G         G FD   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   DF G         G FD   ", " AACEEECCAAAAACCEEECAA ", " AAAAAAAAAAAAAAAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{" AAAAAAAAAAAAAAAAAAAAA ", " AACEEECAAAAAAACEEECAA ", "   DF G   CCC   G FD   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   DF G   CCC   G FD   ", " AACEEECAAAAAAACEEECAA ", " AAAAAAAAAAAAAAAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"AAAAAAAAAAAAAAAAAAAAAAA", "AACEEECAAAAAAAAACEEECAA", "  DF G   CAAAC   G FD  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  DF G   CAAAC   G FD  ", "AACEEECAAAAAAAAACEEECAA", "AAAAAAAAAAAAAAAAAAAAAAA"};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{"AAAAAAAAAAAAAAAAAAAAAAA", "AACEEECAAAAAAAAACEEECAA", "  DF G  CAAAAAC  G FD  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  DF G  CAAAAAC  G FD  ", "AACEEECAAAAAAAAACEEECAA", "AAAAAAAAAAAAAAAAAAAAAAA"};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{"AAAAAAAAAAAAAAAAAAAAAAA", "AACEEECAAAAAAAAACEEECAA", "  DF G  CAAAAAC  G FD  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  DF G  CAAAAAC  G FD  ", "AACEEECAAAAAAAAACEEECAA", "AAAAAAAAAAAAAAAAAAAAAAA"};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"AAAAAAAAAAAAAAAAAAAAAAA", "AACEEECAAAAAAAAACEEECAA", "  DF G  CAAAAAC  G FD  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  D  G  CAAAAAC  G  D  ", "  DF G  CAAAAAC  G FD  ", "AACEEECAAAAAAAAACEEECAA", "AAAAAAAAAAAAAAAAAAAAAAA"};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"AAAAAAAAAAAAAAAAAAAAAAA", "AACEEECAAAAAAAAACEEECAA", "  DF G   CAAAC   G FD  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  D  G   CAAAC   G  D  ", "  DF G   CAAAC   G FD  ", "AACEEECAAAAAAAAACEEECAA", "AAAAAAAAAAAAAAAAAAAAAAA"};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{" AAAAAAAAAAAAAAAAAAAAA ", " AACEEECAAAAAAACEEECAA ", "   DF G   CCC   G FD   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   D  G   CCC   G  D   ", "   DF G   CCC   G FD   ", " AACEEECAAAAAAACEEECAA ", " AAAAAAAAAAAAAAAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray);
        stringArray = new String[]{" AAAAAAAAAAAAAAAAAAAAA ", " AACEEECCAAAAACCEEECAA ", "   DF G         G FD   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   D  G         G  D   ", "   DF G         G FD   ", " AACEEECCAAAAACCEEECAA ", " AAAAAAAAAAAAAAAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.aisle(stringArray);
        stringArray = new String[]{" AAAAAAAAAAAAAAAAAAAAA ", " AACEEEEECCCCCEEEEECAA ", "   DF  GG     GG  FD   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   D   GG     GG   D   ", "   DF  GG     GG  FD   ", " AACEEEEECCCCCEEEEECAA ", " AAAAAAAAAAAAAAAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern17 = factoryBlockPattern16.aisle(stringArray);
        stringArray = new String[]{"  AAAAAAAAAAAAAAAAAAA  ", "  AACEEEEEEEEEEEEECAA  ", "    DF   GGGGG   FD    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    D    GGGGG    D    ", "    DF   GGGGG   FD    ", "  AACEEEEEEEEEEEEECAA  ", "  AAAAAAAAAAAAAAAAAAA  "};
        FactoryBlockPattern factoryBlockPattern18 = factoryBlockPattern17.aisle(stringArray);
        stringArray = new String[]{"  AAAAAAAAAAAAAAAAAAA  ", "  AACCEEEEEEEEEEECCAA  ", "    DDFFF     FFFDD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DD           DD    ", "    DDFFF     FFFDD    ", "  AACCEEEEEEEEEEECCAA  ", "  AAAAAAAAAAAAAAAAAAA  "};
        FactoryBlockPattern factoryBlockPattern19 = factoryBlockPattern18.aisle(stringArray);
        stringArray = new String[]{"   AAAAAAAAAAAAAAAAA   ", "   AAACCCEEEEECCCAAA   ", "      DDDFFFFFDDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDD     DDD      ", "      DDDFFFFFDDD      ", "   AAACCCEEEEECCCAAA   ", "   AAAAAAAAAAAAAAAAA   "};
        FactoryBlockPattern factoryBlockPattern20 = factoryBlockPattern19.aisle(stringArray);
        stringArray = new String[]{"    AAAAAAAAAAAAAAA    ", "    AAAAACCCCCAAAAA    ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "         DDDDD         ", "    AAAAACCCCCAAAAA    ", "    AAAAAAAAAAAAAAA    "};
        FactoryBlockPattern factoryBlockPattern21 = factoryBlockPattern20.aisle(stringArray);
        stringArray = new String[]{"      AAAAAAAAAAA      ", "      AAAAAAAAAAA      ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "      AAAAAAAAAAA      ", "      AAAAAAAAAAA      "};
        FactoryBlockPattern factoryBlockPattern22 = factoryBlockPattern21.aisle(stringArray);
        stringArray = new String[]{"         AAAAA         ", "         AASAA         ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "         AAAAA         ", "         AAAAA         "};
        FactoryBlockPattern factoryBlockPattern23 = factoryBlockPattern22.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(1200);
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_LASER};
        FactoryBlockPattern factoryBlockPattern24 = factoryBlockPattern23.where('A', traceabilityPredicate2.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(0)).or(this.autoAbilities(false, false, true, true, true, true, false)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern25 = factoryBlockPattern24.where('C', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{thirdCasingState};
        FactoryBlockPattern factoryBlockPattern26 = factoryBlockPattern25.where('E', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{fourthCasingState};
        FactoryBlockPattern factoryBlockPattern27 = factoryBlockPattern26.where('F', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{glassState};
        BlockPattern blockPattern = factoryBlockPattern27.where('D', MultiMapMultiblockController.states((IBlockState[])stringArray)).where('G', TraceabilityPredicates.coils()).where(' ', MultiMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.LATTICE_QCD_THERMAL_SHIELDING_CASING;
    }

    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.ENTRODYNAMICALLY_PHASE_CHANGER_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.4", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.5", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.6", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.7", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.8", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.entrodynamically_phase_changer.tooltip.9", (Object[])new Object[0]));
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.energyContainer).addCustom(this::addHeatCapacity).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    private final void addHeatCapacity(KeyManager keyManager, UISyncer syncer) {
        if (this.isStructureFormed()) {
            IKey heatKey = KeyUtil.number((TextFormatting)TextFormatting.RED, (long)syncer.syncInt(this.getCurrentTemperature()), (String)"K");
            Object[] objectArray = new Object[]{heatKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])objectArray));
        }
    }

    public int getCurrentTemperature() {
        return this.temperature;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Object object = recipe.getProperty((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
        Intrinsics.checkNotNull((Object)object);
        return this.temperature >= ((Number)object).intValue();
    }

    @NotNull
    public List<ITextComponent> getDataInfo() {
        List list = super.getDataInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataInfo(...)");
        List components = list;
        Object[] objectArray = new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers((Object)this.temperature) + 'K', new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))};
        components.add(new TextComponentTranslation("gregtech.multiblock.blast_furnace.max_temperature", objectArray));
        return components;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/mega/MultiblockEntrodynamicallyPhaseChanger$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "thirdCasingState", "fourthCasingState", "glassState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\fH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u00a8\u0006\u0019"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/mega/MultiblockEntrodynamicallyPhaseChanger$EntrodynamicallyPhaseChangerRecipeLogic;", "Lgregtech/api/capability/impl/HeatingCoilRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/mega/MultiblockEntrodynamicallyPhaseChanger;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "getMaximumOverclockVoltage", "", "getMaxVoltage", "modifyOverclockPre", "", "ocParams", "Lgregtech/api/recipes/logic/OCParams;", "storage", "Lgregtech/api/recipes/properties/RecipePropertyStorage;", "completeRecipe", "getParallelLimit", "", "calculateAmountCoilEUtDiscount", "providedTemp", "requiredTemp", "applyCoilEUtDiscount", "recipeEUt", "gtlitecore"})
    private final class EntrodynamicallyPhaseChangerRecipeLogic
    extends HeatingCoilRecipeLogic {
        public EntrodynamicallyPhaseChangerRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return 0.125;
        }

        public long getMaximumOverclockVoltage() {
            return this.getMaxVoltage();
        }

        public long getMaxVoltage() {
            IEnergyContainer energyContainer = this.getEnergyContainer();
            if (energyContainer instanceof EnergyContainerList) {
                long voltage = 0L;
                long amperage = 0L;
                if (((EnergyContainerList)energyContainer).getInputVoltage() > ((EnergyContainerList)energyContainer).getOutputVoltage()) {
                    voltage = ((EnergyContainerList)energyContainer).getInputVoltage();
                    amperage = ((EnergyContainerList)energyContainer).getInputAmperage();
                } else {
                    voltage = ((EnergyContainerList)energyContainer).getOutputVoltage();
                    amperage = ((EnergyContainerList)energyContainer).getOutputAmperage();
                }
                return amperage == 1L ? GTValues.VOC[GTUtility.getFloorTierByVoltage((long)voltage)] : voltage;
            }
            return (long)Math.max((double)energyContainer.getInputVoltage(), (double)energyContainer.getOutputVoltage());
        }

        protected void modifyOverclockPre(@NotNull OCParams ocParams, @NotNull RecipePropertyStorage storage) {
            Intrinsics.checkNotNullParameter((Object)ocParams, (String)"ocParams");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            super.modifyOverclockPre(ocParams, storage);
            long l = ocParams.eut();
            MetaTileEntity metaTileEntity = this.metaTileEntity;
            Intrinsics.checkNotNull((Object)metaTileEntity, (String)"null cannot be cast to non-null type gregtech.api.capability.IHeatingCoil");
            int n = ((IHeatingCoil)metaTileEntity).getCurrentTemperature();
            Object object = storage.get((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
            Intrinsics.checkNotNull((Object)object);
            ocParams.setEut(this.applyCoilEUtDiscount(l, n, ((Number)object).intValue()));
        }

        protected void completeRecipe() {
            super.completeRecipe();
            MultiblockEntrodynamicallyPhaseChanger.this.temperature = MultiblockEntrodynamicallyPhaseChanger.this.temperature + 100;
        }

        public int getParallelLimit() {
            return Math.min(MultiblockEntrodynamicallyPhaseChanger.this.level * 256 * MultiblockEntrodynamicallyPhaseChanger.this.getCurrentTemperature(), Integer.MAX_VALUE);
        }

        private final int calculateAmountCoilEUtDiscount(int providedTemp, int requiredTemp) {
            return Math.max(0, (providedTemp - requiredTemp) / 450);
        }

        private final long applyCoilEUtDiscount(long recipeEUt, int providedTemp, int requiredTemp) {
            if (requiredTemp < 450) {
                return recipeEUt;
            }
            int amountEUtDiscount = this.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp);
            return amountEUtDiscount < 1 ? recipeEUt : (long)((double)recipeEUt * Math.min(1.0, Math.pow(0.5, amountEUtDiscount)));
        }
    }
}

