/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.generator;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.sync.FixedIntArraySyncValue;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.gui.GTLiteMuiTextures;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000245B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0013H\u0015J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u0018H\u0002J0\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\bH\u0016J$\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0%2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\b\u00102\u001a\u000200H\u0002J\b\u00103\u001a\u000200H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockRocketEngine;", "Lgregtech/api/metatileentity/multiblock/FuelMultiblockController;", "Lgregtech/api/metatileentity/multiblock/ProgressBarMultiblock;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "size", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "hasMufflerMechanics", "", "shouldShowVoidingModeButton", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "configureWarningText", "isDynamoFull", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "getProgressBarCount", "registerBars", "templateBars", "Ljava/util/function/UnaryOperator;", "Lgregtech/api/metatileentity/multiblock/ui/TemplateBarBuilder;", "guiSyncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "getFuelAmount", "", "getLiquidAirAmount", "getCarbonDioxideAmount", "getHydrogenAmount", "Companion", "LargeRocketEngineWorkableHandler", "gtlitecore"})
public final class MultiblockRocketEngine
extends FuelMultiblockController
implements ProgressBarMultiblock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    @NotNull
    private static final IBlockState casingState = MetalCasing.NITINOL_60.getState();

    public MultiblockRocketEngine(@Nullable ResourceLocation id) {
        super(id, GTLiteRecipeMaps.ROCKET_ENGINE_FUELS, 5);
        this.recipeMapWorkable = (MultiblockRecipeLogic)new LargeRocketEngineWorkableHandler((RecipeMapMultiblockController)this);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[9]);
    }

    @NotNull
    public MultiblockRocketEngine createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        return new MultiblockRocketEngine(this.metaTileEntityId);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.size = ((Number)context.getOrDefault("length", (Object)1)).intValue();
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCC", "CCC", "CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"DDD", "O*O", "DDD"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray).setRepeatable(2, 16);
        stringArray = new String[]{"CCC", "CSC", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = FuelMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(8);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(FuelMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(4));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('C', traceabilityPredicate2.or(FuelMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1)).or(TraceabilityPredicates.energyOutputPredicate(5).setExactLimit(1)));
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.where('D', FuelMultiblockController.states((IBlockState[])stringArray));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern5.where('O', FuelMultiblockController.abilities((MultiblockAbility[])stringArray)).where('*', TraceabilityPredicates.airCounter()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.NITINOL_60_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.LARGE_ROCKET_ENGINE_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MultiblockRecipeLogic multiblockRecipeLogic = this.recipeMapWorkable;
        Intrinsics.checkNotNull((Object)multiblockRecipeLogic, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.generator.MultiblockRocketEngine.LargeRocketEngineWorkableHandler");
        LargeRocketEngineWorkableHandler recipeLogic = (LargeRocketEngineWorkableHandler)multiblockRecipeLogic;
        builder.setWorkingStatus(recipeLogic.isWorkingEnabled(), recipeLogic.isActive() && !this.isDynamoFull()).addEnergyProductionLine(GTValues.V[6], recipeLogic.getRecipeEUt()).addFuelNeededLine(recipeLogic.getRecipeFluidInputInfo(), recipeLogic.getPreviousRecipeDuration()).addCustom((arg_0, arg_1) -> MultiblockRocketEngine.configureDisplayText$lambda$0(this, recipeLogic, arg_0, arg_1)).addWorkingStatusLine();
    }

    protected void configureWarningText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.configureWarningText(builder);
        builder.addCustom((arg_0, arg_1) -> MultiblockRocketEngine.configureWarningText$lambda$1(this, arg_0, arg_1));
    }

    private final boolean isDynamoFull() {
        return this.energyContainer.getEnergyCanBeInserted() < this.recipeMapWorkable.getRecipeEUt();
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        Object[] objectArray = new Object[]{GTValues.V[5]};
        String string = I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.large_rocket_engine.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.large_rocket_engine.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.large_rocket_engine.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
    }

    public int getProgressBarCount() {
        return 4;
    }

    public void registerBars(@NotNull List<UnaryOperator<TemplateBarBuilder>> templateBars, @NotNull PanelSyncManager guiSyncManager) {
        Intrinsics.checkNotNullParameter(templateBars, (String)"templateBars");
        Intrinsics.checkNotNullParameter((Object)guiSyncManager, (String)"guiSyncManager");
        FixedIntArraySyncValue fuelValue = new FixedIntArraySyncValue(this::getFuelAmount, null);
        guiSyncManager.syncValue("fuel_amount", (SyncHandler)fuelValue);
        StringSyncValue fuelNameValue = new StringSyncValue(() -> MultiblockRocketEngine.registerBars$lambda$2(this));
        guiSyncManager.syncValue("fuel_name", (SyncHandler)fuelNameValue);
        FixedIntArraySyncValue liquidAirValue = new FixedIntArraySyncValue(this::getLiquidAirAmount, null);
        guiSyncManager.syncValue("liquid_air_amount", (SyncHandler)liquidAirValue);
        FixedIntArraySyncValue carbonDioxideValue = new FixedIntArraySyncValue(this::getCarbonDioxideAmount, null);
        guiSyncManager.syncValue("carbon_dioxide_amount", (SyncHandler)carbonDioxideValue);
        FixedIntArraySyncValue hydrogenValue = new FixedIntArraySyncValue(this::getHydrogenAmount, null);
        guiSyncManager.syncValue("hydrogen_amount", (SyncHandler)hydrogenValue);
        templateBars.add(arg_0 -> MultiblockRocketEngine.registerBars$lambda$5(fuelValue, this, fuelNameValue, arg_0));
        templateBars.add(arg_0 -> MultiblockRocketEngine.registerBars$lambda$8(hydrogenValue, this, arg_0));
        templateBars.add(arg_0 -> MultiblockRocketEngine.registerBars$lambda$11(liquidAirValue, this, arg_0));
        templateBars.add(arg_0 -> MultiblockRocketEngine.registerBars$lambda$14(carbonDioxideValue, this, arg_0));
    }

    private final int[] getFuelAmount() {
        if (this.getFluidInventory() != null) {
            MultiblockRecipeLogic multiblockRecipeLogic = this.recipeMapWorkable;
            Intrinsics.checkNotNull((Object)multiblockRecipeLogic, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.MultiblockFuelRecipeLogic");
            MultiblockFuelRecipeLogic recipeLogic = (MultiblockFuelRecipeLogic)multiblockRecipeLogic;
            if (recipeLogic.getInputFluidStack() != null) {
                FluidStack testStack = recipeLogic.getInputFluidStack().copy();
                testStack.amount = Integer.MAX_VALUE;
                int[] nArray = this.getTotalFluidAmount(testStack, this.getInputFluidInventory());
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTotalFluidAmount(...)");
                return nArray;
            }
        }
        return new int[2];
    }

    private final int[] getLiquidAirAmount() {
        if (this.getInputFluidInventory() != null) {
            int[] nArray = this.getTotalFluidAmount(Materials.LiquidAir.getFluid(Integer.MAX_VALUE), this.getInputFluidInventory());
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTotalFluidAmount(...)");
            return nArray;
        }
        return new int[2];
    }

    private final int[] getCarbonDioxideAmount() {
        if (this.getInputFluidInventory() != null) {
            int[] nArray = this.getTotalFluidAmount(Materials.CarbonDioxide.getFluid(Integer.MAX_VALUE), this.getInputFluidInventory());
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTotalFluidAmount(...)");
            return nArray;
        }
        return new int[2];
    }

    private final int[] getHydrogenAmount() {
        if (this.getInputFluidInventory() != null) {
            int[] nArray = this.getTotalFluidAmount(Materials.Hydrogen.getFluid(Integer.MAX_VALUE), this.getInputFluidInventory());
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTotalFluidAmount(...)");
            return nArray;
        }
        return new int[2];
    }

    private static final void configureDisplayText$lambda$0(MultiblockRocketEngine this$0, LargeRocketEngineWorkableHandler $recipeLogic, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed() && syncer.syncBoolean($recipeLogic.isHydrogenBoosted())) {
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.AQUA, (String)"gtlitecore.machine.large_rocket_engine.hydrogen_boosted", (Object[])new Object[0]));
        }
    }

    private static final void configureWarningText$lambda$1(MultiblockRocketEngine this$0, KeyManager keyManager, UISyncer syncer) {
        if (syncer.syncBoolean(this$0::isDynamoFull)) {
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.YELLOW, (String)"gtlitecore.tooltip.multiblock.dynamo_hatch_full", (Object[])new Object[0]));
        }
    }

    private static final String registerBars$lambda$2(MultiblockRocketEngine this$0) {
        MultiblockRecipeLogic multiblockRecipeLogic = this$0.recipeMapWorkable;
        Intrinsics.checkNotNull((Object)multiblockRecipeLogic, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.MultiblockFuelRecipeLogic");
        FluidStack stack = ((MultiblockFuelRecipeLogic)multiblockRecipeLogic).getInputFluidStack();
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return null;
        }
        return fluid.getName();
    }

    private static final double registerBars$lambda$5$lambda$3(FixedIntArraySyncValue $fuelValue) {
        if ($fuelValue.getValue(1) == 0) {
            return 0.0;
        }
        return 1.0 * (double)$fuelValue.getValue(0) / (double)$fuelValue.getValue(1);
    }

    private static final void registerBars$lambda$5$lambda$4(MultiblockRocketEngine this$0, FixedIntArraySyncValue $fuelValue, StringSyncValue $fuelNameValue, RichTooltip tooltip) {
        this$0.createFuelTooltip(tooltip, $fuelValue, $fuelNameValue);
    }

    private static final TemplateBarBuilder registerBars$lambda$5(FixedIntArraySyncValue $fuelValue, MultiblockRocketEngine this$0, StringSyncValue $fuelNameValue, TemplateBarBuilder templateBar) {
        Intrinsics.checkNotNullParameter((Object)templateBar, (String)"templateBar");
        return templateBar.progress(() -> MultiblockRocketEngine.registerBars$lambda$5$lambda$3($fuelValue)).texture(GTGuiTextures.PROGRESS_BAR_LCE_FUEL).tooltipBuilder(arg_0 -> MultiblockRocketEngine.registerBars$lambda$5$lambda$4(this$0, $fuelValue, $fuelNameValue, arg_0));
    }

    private static final double registerBars$lambda$8$lambda$6(FixedIntArraySyncValue $hydrogenValue) {
        if ($hydrogenValue.getValue(1) == 0) {
            return 0.0;
        }
        return 1.0 * (double)$hydrogenValue.getValue(0) / (double)$hydrogenValue.getValue(1);
    }

    private static final void registerBars$lambda$8$lambda$7(MultiblockRocketEngine this$0, FixedIntArraySyncValue $hydrogenValue, RichTooltip tooltip) {
        if (this$0.isStructureFormed()) {
            AbstractRecipeLogic abstractRecipeLogic = this$0.getRecipeLogic();
            Intrinsics.checkNotNull((Object)abstractRecipeLogic, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.generator.MultiblockRocketEngine.LargeRocketEngineWorkableHandler");
            if (((LargeRocketEngineWorkableHandler)abstractRecipeLogic).isHydrogenBoosted()) {
                RichTooltip richTooltip;
                if ($hydrogenValue.getValue(0) == 0) {
                    richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.RED, (String)"gtlitecore.machine.large_rocket_engine.hydrogen_none", (Object[])new Object[0]));
                } else {
                    Object[] objectArray = new Object[]{$hydrogenValue.getValue(0), $hydrogenValue.getValue(1)};
                    richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((String)"gtlitecore.machine.large_rocket_engine.hydrogen_amount", (Object[])objectArray));
                }
            }
        } else {
            tooltip.addLine((IDrawable)KeyUtil.lang((String)"gregtech.multiblock.invalid_structure", (Object[])new Object[0]));
        }
    }

    private static final TemplateBarBuilder registerBars$lambda$8(FixedIntArraySyncValue $hydrogenValue, MultiblockRocketEngine this$0, TemplateBarBuilder templateBar) {
        Intrinsics.checkNotNullParameter((Object)templateBar, (String)"templateBar");
        return templateBar.progress(() -> MultiblockRocketEngine.registerBars$lambda$8$lambda$6($hydrogenValue)).texture(GTLiteMuiTextures.PROGRESS_BAR_LRE_HYDROGEN).tooltipBuilder(arg_0 -> MultiblockRocketEngine.registerBars$lambda$8$lambda$7(this$0, $hydrogenValue, arg_0));
    }

    private static final double registerBars$lambda$11$lambda$9(FixedIntArraySyncValue $liquidAirValue) {
        if ($liquidAirValue.getValue(1) == 0) {
            return 0.0;
        }
        return 1.0 * (double)$liquidAirValue.getValue(0) / (double)$liquidAirValue.getValue(1);
    }

    private static final void registerBars$lambda$11$lambda$10(MultiblockRocketEngine this$0, FixedIntArraySyncValue $liquidAirValue, RichTooltip tooltip) {
        RichTooltip richTooltip;
        if (this$0.isStructureFormed()) {
            if ($liquidAirValue.getValue(0) == 0) {
                richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.RED, (String)"gtlitecore.machine.large_rocket_engine.liquid_air_none", (Object[])new Object[0]));
            } else {
                Object[] objectArray = new Object[]{$liquidAirValue.getValue(0), $liquidAirValue.getValue(1)};
                richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((String)"gtlitecore.machine.large_rocket_engine.liquid_air_amount", (Object[])objectArray));
            }
        } else {
            richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((String)"gregtech.multiblock.invalid_structure", (Object[])new Object[0]));
        }
    }

    private static final TemplateBarBuilder registerBars$lambda$11(FixedIntArraySyncValue $liquidAirValue, MultiblockRocketEngine this$0, TemplateBarBuilder templateBar) {
        Intrinsics.checkNotNullParameter((Object)templateBar, (String)"templateBar");
        return templateBar.progress(() -> MultiblockRocketEngine.registerBars$lambda$11$lambda$9($liquidAirValue)).texture(GTLiteMuiTextures.PROGRESS_BAR_LRE_LIQUID_AIR).tooltipBuilder(arg_0 -> MultiblockRocketEngine.registerBars$lambda$11$lambda$10(this$0, $liquidAirValue, arg_0));
    }

    private static final double registerBars$lambda$14$lambda$12(FixedIntArraySyncValue $carbonDioxideValue) {
        if ($carbonDioxideValue.getValue(1) == 0) {
            return 0.0;
        }
        return 1.0 * (double)$carbonDioxideValue.getValue(0) / (double)$carbonDioxideValue.getValue(1);
    }

    private static final void registerBars$lambda$14$lambda$13(MultiblockRocketEngine this$0, FixedIntArraySyncValue $carbonDioxideValue, RichTooltip tooltip) {
        RichTooltip richTooltip;
        if (this$0.isStructureFormed()) {
            if ($carbonDioxideValue.getValue(0) == 0) {
                richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.RED, (String)"gtlitecore.machine.large_rocket_engine.carbon_dioxide_none", (Object[])new Object[0]));
            } else {
                Object[] objectArray = new Object[]{$carbonDioxideValue.getValue(0), $carbonDioxideValue.getValue(1)};
                richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((String)"gtlitecore.machine.large_rocket_engine.carbon_dioxide_amount", (Object[])objectArray));
            }
        } else {
            richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((String)"gregtech.multiblock.invalid_structure", (Object[])new Object[0]));
        }
    }

    private static final TemplateBarBuilder registerBars$lambda$14(FixedIntArraySyncValue $carbonDioxideValue, MultiblockRocketEngine this$0, TemplateBarBuilder templateBar) {
        Intrinsics.checkNotNullParameter((Object)templateBar, (String)"templateBar");
        return templateBar.progress(() -> MultiblockRocketEngine.registerBars$lambda$14$lambda$12($carbonDioxideValue)).texture(GTLiteMuiTextures.PROGRESS_BAR_LRE_CARBON_DIOXIDE).tooltipBuilder(arg_0 -> MultiblockRocketEngine.registerBars$lambda$14$lambda$13(this$0, $carbonDioxideValue, arg_0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockRocketEngine$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\tH\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\tH\u0014J\b\u0010\u001a\u001a\u00020\tH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\tH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockRocketEngine$LargeRocketEngineWorkableHandler;", "Lgregtech/api/capability/impl/MultiblockFuelRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockRocketEngine;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "rocketEngine", "Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockRocketEngine;", "isHydrogenBoosted", "", "()Z", "setHydrogenBoosted", "(Z)V", "hydrogenStack", "Lnet/minecraftforge/fluids/FluidStack;", "liquidAirStack", "carbonDioxideStack", "updateRecipeProgress", "", "checkHydrogen", "drainHydrogen", "checkLiquidAir", "drainLiquidAir", "checkCarbonDioxide", "drainCarbonDioxide", "shouldSearchForRecipes", "canProgressRecipe", "getMaxVoltage", "", "boostProduction", "production", "invalidate", "isAllowOverclocking", "gtlitecore"})
    public final class LargeRocketEngineWorkableHandler
    extends MultiblockFuelRecipeLogic {
        @Nullable
        private MultiblockRocketEngine rocketEngine;
        private boolean isHydrogenBoosted;
        @NotNull
        private final FluidStack hydrogenStack;
        @NotNull
        private final FluidStack liquidAirStack;
        @NotNull
        private final FluidStack carbonDioxideStack;

        public LargeRocketEngineWorkableHandler(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity);
            FluidStack fluidStack = Materials.Hydrogen.getFluid(80);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
            this.hydrogenStack = fluidStack;
            FluidStack fluidStack2 = Materials.LiquidAir.getFluid(8000);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack2, (String)"getFluid(...)");
            this.liquidAirStack = fluidStack2;
            FluidStack fluidStack3 = Materials.CarbonDioxide.getFluid(200);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack3, (String)"getFluid(...)");
            this.carbonDioxideStack = fluidStack3;
            Intrinsics.checkNotNull((Object)metaTileEntity, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.generator.MultiblockRocketEngine");
            this.rocketEngine = (MultiblockRocketEngine)metaTileEntity;
        }

        public final boolean isHydrogenBoosted() {
            return this.isHydrogenBoosted;
        }

        public final void setHydrogenBoosted(boolean bl) {
            this.isHydrogenBoosted = bl;
        }

        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                this.drainLiquidAir();
                this.drainCarbonDioxide();
                this.drainHydrogen();
                this.drawEnergy(this.recipeEUt, false);
                ++this.progressTime;
                if (this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
            }
        }

        private final void checkHydrogen() {
            MultiblockRocketEngine multiblockRocketEngine = this.rocketEngine;
            Intrinsics.checkNotNull((Object)((Object)multiblockRocketEngine));
            IMultipleTankHandler iMultipleTankHandler = multiblockRocketEngine.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
            this.isHydrogenBoosted = this.hydrogenStack.isFluidStackIdentical(((IFluidHandler)iMultipleTankHandler).drain(this.hydrogenStack, false));
        }

        private final void drainHydrogen() {
            if (this.isHydrogenBoosted && this.totalContinuousRunningTime % (long)20 == 0L) {
                MultiblockRocketEngine multiblockRocketEngine = this.rocketEngine;
                Intrinsics.checkNotNull((Object)((Object)multiblockRocketEngine));
                IMultipleTankHandler iMultipleTankHandler = multiblockRocketEngine.inputFluidInventory;
                Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
                ((IFluidHandler)iMultipleTankHandler).drain(this.hydrogenStack, true);
            }
        }

        private final boolean checkLiquidAir() {
            MultiblockRocketEngine multiblockRocketEngine = this.rocketEngine;
            Intrinsics.checkNotNull((Object)((Object)multiblockRocketEngine));
            IMultipleTankHandler iMultipleTankHandler = multiblockRocketEngine.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
            if (this.liquidAirStack.isFluidStackIdentical(((IFluidHandler)iMultipleTankHandler).drain(this.liquidAirStack, false))) {
                return true;
            }
            this.invalidate();
            return false;
        }

        private final void drainLiquidAir() {
            if (this.totalContinuousRunningTime % (long)20 == 0L) {
                MultiblockRocketEngine multiblockRocketEngine = this.rocketEngine;
                Intrinsics.checkNotNull((Object)((Object)multiblockRocketEngine));
                IMultipleTankHandler iMultipleTankHandler = multiblockRocketEngine.inputFluidInventory;
                Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
                ((IFluidHandler)iMultipleTankHandler).drain(this.liquidAirStack, true);
            }
        }

        private final boolean checkCarbonDioxide() {
            MultiblockRocketEngine multiblockRocketEngine = this.rocketEngine;
            Intrinsics.checkNotNull((Object)((Object)multiblockRocketEngine));
            IMultipleTankHandler iMultipleTankHandler = multiblockRocketEngine.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
            if (this.carbonDioxideStack.isFluidStackIdentical(((IFluidHandler)iMultipleTankHandler).drain(this.carbonDioxideStack, false))) {
                return true;
            }
            this.invalidate();
            return false;
        }

        private final void drainCarbonDioxide() {
            if (this.totalContinuousRunningTime % (long)20 == 0L) {
                MultiblockRocketEngine multiblockRocketEngine = this.rocketEngine;
                Intrinsics.checkNotNull((Object)((Object)multiblockRocketEngine));
                IMultipleTankHandler iMultipleTankHandler = multiblockRocketEngine.inputFluidInventory;
                Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
                ((IFluidHandler)iMultipleTankHandler).drain(this.carbonDioxideStack, true);
            }
        }

        protected boolean shouldSearchForRecipes() {
            this.checkHydrogen();
            return super.shouldSearchForRecipes() && this.checkLiquidAir() && this.checkCarbonDioxide();
        }

        protected boolean canProgressRecipe() {
            return super.canProgressRecipe() && this.checkLiquidAir() && this.checkCarbonDioxide();
        }

        public long getMaxVoltage() {
            return this.isHydrogenBoosted ? GTValues.V[5] * (long)3 : GTValues.V[5];
        }

        protected long boostProduction(long production) {
            if (this.isHydrogenBoosted) {
                return production * (long)2;
            }
            return production;
        }

        public void invalidate() {
            super.invalidate();
            this.isHydrogenBoosted = false;
        }

        public boolean isAllowOverclocking() {
            return MultiblockRocketEngine.this.size >= 10;
        }
    }
}

