/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.ActiveUniqueCasing;
import gregtechlite.gtlitecore.common.block.variant.GlassCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0013H\u0015J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNuclearReactor;", "Lgregtech/api/metatileentity/multiblock/FuelMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "coreTier", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "hasMufflerMechanics", "getMufflerParticle", "Lnet/minecraft/util/EnumParticleTypes;", "getBoostedFromCoreTier", "", "tier", "Companion", "NuclearReactorWorkableHandler", "gtlitecore"})
public final class MultiblockNuclearReactor
extends FuelMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int coreTier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.INCONEL_718.getState();
    @NotNull
    private static final IBlockState secondCasingState = ActiveUniqueCasing.TEMPERATURE_CONTROLLER.getState();
    @NotNull
    private static final IBlockState glassState = GlassCasing.LEAD_SILICON.getState();

    public MultiblockNuclearReactor(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.NUCLEAR_FUELS, 4);
        this.recipeMapWorkable = (MultiblockRecipeLogic)new NuclearReactorWorkableHandler((RecipeMapMultiblockController)this);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[14]);
    }

    @NotNull
    public MultiblockNuclearReactor createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockNuclearReactor(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.coreTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.NUCLEAR_REACTOR_CORE_TIER, 0)).intValue();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.coreTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCC", "DDD", "CGC", "CGC", "CGC", "CGC", "CGC", "CGC", "CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCC", "DDD", "GXG", "GXG", "GXG", "GXG", "GXG", "GXG", "COC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CSC", "DDD", "CGC", "CGC", "CGC", "CGC", "CGC", "CGC", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = FuelMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(30);
        stringArray = new MultiblockAbility[]{MultiblockAbility.OUTPUT_ENERGY};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('C', traceabilityPredicate.or(FuelMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1).setPreviewCount(1)).or(this.autoAbilities(false, true, true, true, true, true, false)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.where('D', FuelMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{glassState};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('G', FuelMultiblockController.states((IBlockState[])stringArray));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern6.where('O', FuelMultiblockController.abilities((MultiblockAbility[])stringArray)).where('X', TraceabilityPredicates.nuclearReactorCores()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.INCONEL_718_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.NUCLEAR_REACTOR_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
        String string5 = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.5", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        tooltip.add(string5);
        String string6 = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.6", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        tooltip.add(string6);
        String string7 = I18n.func_135052_a((String)"gtlitecore.machine.nuclear_reactor.tooltip.7", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        tooltip.add(string7);
    }

    public boolean canBeDistinct() {
        return false;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    @NotNull
    public EnumParticleTypes getMufflerParticle() {
        return EnumParticleTypes.CLOUD;
    }

    public final double getBoostedFromCoreTier(int tier) {
        double d;
        switch (tier) {
            case 1: {
                d = 1.05;
                break;
            }
            case 2: {
                d = 1.1;
                break;
            }
            case 3: {
                d = 1.3;
                break;
            }
            case 4: {
                d = 1.4;
                break;
            }
            case 5: {
                d = 1.5;
                break;
            }
            case 6: {
                d = 1.8;
                break;
            }
            case 7: {
                d = 1.85;
                break;
            }
            case 8: {
                d = 1.9;
                break;
            }
            case 9: {
                d = 2.0;
                break;
            }
            case 10: {
                d = 2.5;
                break;
            }
            case 11: {
                d = 3.0;
                break;
            }
            case 12: {
                d = 3.2;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNuclearReactor$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "glassState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNuclearReactor$NuclearReactorWorkableHandler;", "Lgregtech/api/capability/impl/MultiblockFuelRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNuclearReactor;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getMaxVoltage", "", "getParallelLimit", "", "gtlitecore"})
    private final class NuclearReactorWorkableHandler
    extends MultiblockFuelRecipeLogic {
        public NuclearReactorWorkableHandler(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte);
        }

        public long getMaxVoltage() {
            return (long)Math.max((double)super.getMaxVoltage(), (double)super.getMaxVoltage() * MultiblockNuclearReactor.this.getBoostedFromCoreTier(MultiblockNuclearReactor.this.coreTier));
        }

        public int getParallelLimit() {
            return Integer.MAX_VALUE;
        }
    }
}

