/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.generator;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.sync.FixedIntArraySyncValue;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtechlite.gtlitecore.api.gui.GTLiteMuiTextures;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTMultiblockCasing;
import gregtechlite.gtlitecore.common.block.variant.ActiveUniqueCasing;
import gregtechlite.gtlitecore.common.block.variant.BoilerCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000212B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u000fH\u0015J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u0016H\u0002J0\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020'H\u0016J$\u0010(\u001a\u00020\u000b2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0#2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020/H\u0002\u00a8\u00063"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNaquadahReactor;", "Lgregtech/api/metatileentity/multiblock/FuelMultiblockController;", "Lgregtech/api/metatileentity/multiblock/ProgressBarMultiblock;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "initializeAbilities", "", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "getMufflerParticle", "Lnet/minecraft/util/EnumParticleTypes;", "hasMufflerMechanics", "", "shouldShowVoidingModeButton", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "configureWarningText", "isDynamoFull", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "getProgressBarCount", "", "registerBars", "templateBars", "Ljava/util/function/UnaryOperator;", "Lgregtech/api/metatileentity/multiblock/ui/TemplateBarBuilder;", "guiSyncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "getFuelAmount", "", "getPlasmaOxygenAmount", "Companion", "LargeNaquadahReactorWorkableHandler", "gtlitecore"})
public final class MultiblockNaquadahReactor
extends FuelMultiblockController
implements ProgressBarMultiblock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IBlockState casingState = MetalCasing.NAQUADAH_ALLOY.getState();
    @NotNull
    private static final IBlockState secondCasingState = GTMultiblockCasing.GRATE_CASING.getState();
    @NotNull
    private static final IBlockState uniqueCasingState = ActiveUniqueCasing.HEAT_VENT.getState();
    @NotNull
    private static final IBlockState pipeCasingState = BoilerCasing.POLYBENZIMIDAZOLE.getState();

    public MultiblockNaquadahReactor(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.NAQUADAH_REACTOR_FUELS, 8);
        this.recipeMapWorkable = (MultiblockRecipeLogic)new LargeNaquadahReactorWorkableHandler((RecipeMapMultiblockController)this);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.VOC[30]);
    }

    @NotNull
    public MultiblockNaquadahReactor createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockNaquadahReactor(resourceLocation);
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList outputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
        outputEnergy.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_OUTPUT_ENERGY));
        outputEnergy.addAll(this.getAbilities(MultiblockAbility.OUTPUT_LASER));
        this.energyContainer = (IEnergyContainer)new EnergyContainerList((List)outputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{" CCC ", " CUC ", " CCC ", "  C  ", "  C  ", " CCC ", " CUC ", " CCC "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCCCC", "CP#PC", "CG#GC", " P#P ", " P#P ", "CG#GC", "CP#PC", " CCC "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "U#F#U", "C#F#C", "C#F#C", "C#F#C", "C#F#C", "U#F#U", " COC "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "CP#PC", "CG#GC", " P#P ", " P#P ", "CG#GC", "CP#PC", " CCC "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{" CCC ", " CSC ", " CCC ", "  C  ", "  C  ", " CCC ", " CUC ", " CCC "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = FuelMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(70);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(FuelMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(2));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH};
        TraceabilityPredicate traceabilityPredicate3 = traceabilityPredicate2.or(FuelMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.OUTPUT_ENERGY, MultiblockAbility.OUTPUT_LASER};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('C', traceabilityPredicate3.or(FuelMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1)));
        stringArray = new IBlockState[]{uniqueCasingState};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.where('U', FuelMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('G', FuelMultiblockController.states((IBlockState[])stringArray));
        stringArray = new Material[]{Materials.Naquadria};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.where('F', FuelMultiblockController.frames((Material[])stringArray));
        stringArray = new IBlockState[]{pipeCasingState};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.where('P', FuelMultiblockController.states((IBlockState[])stringArray));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern10.where('O', FuelMultiblockController.abilities((MultiblockAbility[])stringArray)).where('#', FuelMultiblockController.air()).where(' ', FuelMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.NAQUADAH_ALLOY_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.POWER_SUBSTATION_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"POWER_SUBSTATION_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    @NotNull
    public EnumParticleTypes getMufflerParticle() {
        return EnumParticleTypes.SPELL_WITCH;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MultiblockRecipeLogic multiblockRecipeLogic = this.recipeMapWorkable;
        Intrinsics.checkNotNull((Object)multiblockRecipeLogic, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.generator.MultiblockNaquadahReactor.LargeNaquadahReactorWorkableHandler");
        LargeNaquadahReactorWorkableHandler recipeLogic = (LargeNaquadahReactorWorkableHandler)multiblockRecipeLogic;
        builder.setWorkingStatus(recipeLogic.isWorkingEnabled(), recipeLogic.isActive() && !this.isDynamoFull()).addEnergyProductionLine(GTValues.V[9], recipeLogic.getRecipeEUt()).addFuelNeededLine(recipeLogic.getRecipeFluidInputInfo(), recipeLogic.getPreviousRecipeDuration()).addCustom((arg_0, arg_1) -> MultiblockNaquadahReactor.configureDisplayText$lambda$0(this, recipeLogic, arg_0, arg_1)).addWorkingStatusLine();
    }

    protected void configureWarningText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.configureWarningText(builder);
        builder.addCustom((arg_0, arg_1) -> MultiblockNaquadahReactor.configureWarningText$lambda$1(this, arg_0, arg_1));
    }

    private final boolean isDynamoFull() {
        return this.energyContainer.getEnergyCanBeInserted() < this.recipeMapWorkable.getRecipeEUt();
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        Object[] objectArray = new Object[]{GTValues.V[9]};
        String string = I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.large_naquadah_reactor.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.large_naquadah_reactor.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.large_naquadah_reactor.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
        String string5 = I18n.func_135052_a((String)"gtlitecore.machine.large_naquadah_reactor.tooltip.4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        tooltip.add(string5);
    }

    public int getProgressBarCount() {
        return 2;
    }

    public void registerBars(@NotNull List<UnaryOperator<TemplateBarBuilder>> templateBars, @NotNull PanelSyncManager guiSyncManager) {
        Intrinsics.checkNotNullParameter(templateBars, (String)"templateBars");
        Intrinsics.checkNotNullParameter((Object)guiSyncManager, (String)"guiSyncManager");
        FixedIntArraySyncValue fuelValue = new FixedIntArraySyncValue(this::getFuelAmount, null);
        guiSyncManager.syncValue("fuel_amount", (SyncHandler)fuelValue);
        StringSyncValue fuelNameValue = new StringSyncValue(() -> MultiblockNaquadahReactor.registerBars$lambda$2(this));
        guiSyncManager.syncValue("fuel_name", (SyncHandler)fuelNameValue);
        FixedIntArraySyncValue boostedValue = new FixedIntArraySyncValue(this::getPlasmaOxygenAmount, null);
        guiSyncManager.syncValue("plasma_oxygen_amount", (SyncHandler)boostedValue);
        templateBars.add(arg_0 -> MultiblockNaquadahReactor.registerBars$lambda$5(fuelValue, this, fuelNameValue, arg_0));
        templateBars.add(arg_0 -> MultiblockNaquadahReactor.registerBars$lambda$8(boostedValue, this, arg_0));
    }

    private final int[] getFuelAmount() {
        if (this.getInputFluidInventory() != null) {
            MultiblockRecipeLogic multiblockRecipeLogic = this.recipeMapWorkable;
            Intrinsics.checkNotNull((Object)multiblockRecipeLogic, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.MultiblockFuelRecipeLogic");
            MultiblockFuelRecipeLogic recipeLogic = (MultiblockFuelRecipeLogic)multiblockRecipeLogic;
            if (recipeLogic.getInputFluidStack() != null) {
                FluidStack testStack = recipeLogic.getInputFluidStack().copy();
                testStack.amount = Integer.MAX_VALUE;
                int[] nArray = this.getTotalFluidAmount(testStack, this.getInputFluidInventory());
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTotalFluidAmount(...)");
                return nArray;
            }
        }
        return new int[2];
    }

    private final int[] getPlasmaOxygenAmount() {
        if (this.getInputFluidInventory() != null) {
            FluidStack boostedStack = Materials.Oxygen.getPlasma(Integer.MAX_VALUE);
            int[] nArray = this.getTotalFluidAmount(boostedStack, this.getInputFluidInventory());
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getTotalFluidAmount(...)");
            return nArray;
        }
        return new int[2];
    }

    private static final void configureDisplayText$lambda$0(MultiblockNaquadahReactor this$0, LargeNaquadahReactorWorkableHandler $recipeLogic, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed() && syncer.syncBoolean($recipeLogic.isPlasmaOxygenBoosted())) {
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.AQUA, (String)"gtlitecore.machine.large_naquadah_reactor.plasma_oxygen_boosted", (Object[])new Object[0]));
        }
    }

    private static final void configureWarningText$lambda$1(MultiblockNaquadahReactor this$0, KeyManager keyManager, UISyncer syncer) {
        if (syncer.syncBoolean(this$0::isDynamoFull)) {
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.YELLOW, (String)"gtlitecore.tooltip.multiblock.dynamo_hatch_full", (Object[])new Object[0]));
        }
    }

    private static final String registerBars$lambda$2(MultiblockNaquadahReactor this$0) {
        MultiblockRecipeLogic multiblockRecipeLogic = this$0.recipeMapWorkable;
        Intrinsics.checkNotNull((Object)multiblockRecipeLogic, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.MultiblockFuelRecipeLogic");
        FluidStack stack = ((MultiblockFuelRecipeLogic)multiblockRecipeLogic).getInputFluidStack();
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return null;
        }
        return fluid.getName();
    }

    private static final double registerBars$lambda$5$lambda$3(FixedIntArraySyncValue $fuelValue) {
        if ($fuelValue.getValue(1) == 0) {
            return 0.0;
        }
        return 1.0 * (double)$fuelValue.getValue(0) / (double)$fuelValue.getValue(1);
    }

    private static final void registerBars$lambda$5$lambda$4(MultiblockNaquadahReactor this$0, FixedIntArraySyncValue $fuelValue, StringSyncValue $fuelNameValue, RichTooltip tooltip) {
        this$0.createFuelTooltip(tooltip, $fuelValue, $fuelNameValue);
    }

    private static final TemplateBarBuilder registerBars$lambda$5(FixedIntArraySyncValue $fuelValue, MultiblockNaquadahReactor this$0, StringSyncValue $fuelNameValue, TemplateBarBuilder templateBar) {
        Intrinsics.checkNotNullParameter((Object)templateBar, (String)"templateBar");
        return templateBar.progress(() -> MultiblockNaquadahReactor.registerBars$lambda$5$lambda$3($fuelValue)).texture(GTGuiTextures.PROGRESS_BAR_LCE_FUEL).tooltipBuilder(arg_0 -> MultiblockNaquadahReactor.registerBars$lambda$5$lambda$4(this$0, $fuelValue, $fuelNameValue, arg_0));
    }

    private static final double registerBars$lambda$8$lambda$6(FixedIntArraySyncValue $boostedValue) {
        if ($boostedValue.getValue(1) == 0) {
            return 0.0;
        }
        return 1.0 * (double)$boostedValue.getValue(0) / (double)$boostedValue.getValue(1);
    }

    private static final void registerBars$lambda$8$lambda$7(MultiblockNaquadahReactor this$0, FixedIntArraySyncValue $boostedValue, RichTooltip tooltip) {
        if (this$0.isStructureFormed()) {
            AbstractRecipeLogic abstractRecipeLogic = this$0.getRecipeLogic();
            Intrinsics.checkNotNull((Object)abstractRecipeLogic, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.generator.MultiblockNaquadahReactor.LargeNaquadahReactorWorkableHandler");
            if (((LargeNaquadahReactorWorkableHandler)abstractRecipeLogic).isPlasmaOxygenBoosted()) {
                RichTooltip richTooltip;
                if ($boostedValue.getValue(0) == 0) {
                    richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.RED, (String)"gtlitecore.machine.large_naquadah_reactor.plasma_oxygen_none", (Object[])new Object[0]));
                } else {
                    Object[] objectArray = new Object[]{$boostedValue.getValue(0), $boostedValue.getValue(1)};
                    richTooltip = (RichTooltip)tooltip.addLine((IDrawable)KeyUtil.lang((String)"gtlitecore.machine.large_naquadah_reactor.plasma_oxygen_amount", (Object[])objectArray));
                }
            }
        } else {
            tooltip.addLine((IDrawable)KeyUtil.lang((String)"gregtech.multiblock.invalid_structure", (Object[])new Object[0]));
        }
    }

    private static final TemplateBarBuilder registerBars$lambda$8(FixedIntArraySyncValue $boostedValue, MultiblockNaquadahReactor this$0, TemplateBarBuilder templateBar) {
        Intrinsics.checkNotNullParameter((Object)templateBar, (String)"templateBar");
        return templateBar.progress(() -> MultiblockNaquadahReactor.registerBars$lambda$8$lambda$6($boostedValue)).texture(GTLiteMuiTextures.PROGRESS_BAR_LNR_PLASMA_OXYGEN).tooltipBuilder(arg_0 -> MultiblockNaquadahReactor.registerBars$lambda$8$lambda$7(this$0, $boostedValue, arg_0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNaquadahReactor$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "uniqueCasingState", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\tH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0014J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNaquadahReactor$LargeNaquadahReactorWorkableHandler;", "Lgregtech/api/capability/impl/MultiblockFuelRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNaquadahReactor;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "naquadahReactor", "Lgregtechlite/gtlitecore/common/metatileentity/multiblock/generator/MultiblockNaquadahReactor;", "isPlasmaOxygenBoosted", "", "()Z", "setPlasmaOxygenBoosted", "(Z)V", "PLASMA_OXYGEN_STACK", "Lnet/minecraftforge/fluids/FluidStack;", "updateRecipeProgress", "", "checkPlasmaOxygen", "drainPlasmaOxygen", "shouldSearchForRecipes", "getMaxVoltage", "", "boostProduction", "production", "invalidate", "isAllowOverclocking", "gtlitecore"})
    private final class LargeNaquadahReactorWorkableHandler
    extends MultiblockFuelRecipeLogic {
        @Nullable
        private MultiblockNaquadahReactor naquadahReactor;
        private boolean isPlasmaOxygenBoosted;
        @NotNull
        private final FluidStack PLASMA_OXYGEN_STACK;

        public LargeNaquadahReactorWorkableHandler(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity);
            FluidStack fluidStack = Materials.Oxygen.getPlasma(50);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getPlasma(...)");
            this.PLASMA_OXYGEN_STACK = fluidStack;
            Intrinsics.checkNotNull((Object)metaTileEntity, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.generator.MultiblockNaquadahReactor");
            this.naquadahReactor = (MultiblockNaquadahReactor)metaTileEntity;
        }

        public final boolean isPlasmaOxygenBoosted() {
            return this.isPlasmaOxygenBoosted;
        }

        public final void setPlasmaOxygenBoosted(boolean bl) {
            this.isPlasmaOxygenBoosted = bl;
        }

        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                this.drainPlasmaOxygen();
                this.drawEnergy(this.recipeEUt, false);
                ++this.progressTime;
                if (this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
            }
        }

        private final void checkPlasmaOxygen() {
            MultiblockNaquadahReactor multiblockNaquadahReactor = this.naquadahReactor;
            Intrinsics.checkNotNull((Object)((Object)multiblockNaquadahReactor));
            IMultipleTankHandler iMultipleTankHandler = multiblockNaquadahReactor.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
            this.isPlasmaOxygenBoosted = this.PLASMA_OXYGEN_STACK.isFluidStackIdentical(((IFluidHandler)iMultipleTankHandler).drain(this.PLASMA_OXYGEN_STACK, false));
        }

        private final void drainPlasmaOxygen() {
            if (this.isPlasmaOxygenBoosted && this.totalContinuousRunningTime % (long)20 == 0L) {
                MultiblockNaquadahReactor multiblockNaquadahReactor = this.naquadahReactor;
                Intrinsics.checkNotNull((Object)((Object)multiblockNaquadahReactor));
                IMultipleTankHandler iMultipleTankHandler = multiblockNaquadahReactor.inputFluidInventory;
                Intrinsics.checkNotNull((Object)iMultipleTankHandler, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.capability.IFluidHandler");
                ((IFluidHandler)iMultipleTankHandler).drain(this.PLASMA_OXYGEN_STACK, true);
            }
        }

        protected boolean shouldSearchForRecipes() {
            this.checkPlasmaOxygen();
            return super.shouldSearchForRecipes();
        }

        public long getMaxVoltage() {
            return this.isPlasmaOxygenBoosted ? GTValues.V[8] * (long)16 : GTValues.V[8] * (long)4;
        }

        protected long boostProduction(long production) {
            if (this.isPlasmaOxygenBoosted) {
                return production * (long)2;
            }
            return production;
        }

        public void invalidate() {
            super.invalidate();
            this.isPlasmaOxygenBoosted = false;
        }

        public boolean isAllowOverclocking() {
            return true;
        }
    }
}

