/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.GTValues;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.HeatingCoilRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.recipes.properties.impl.TemperatureProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.core.sound.GTSoundEvents;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 52\u00020\u00012\u00020\u0002:\u000256B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0015J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0014J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\b\u0010,\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\bH\u0016J\u0018\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020$H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockVolcanus;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "Lgregtech/api/capability/IHeatingCoil;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "motorCasingTier", "", "coilTier", "temperature", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "configureWarningText", "getDataInfo", "", "Lnet/minecraft/util/text/ITextComponent;", "canBeDistinct", "hasMufflerMechanics", "getBreakdownSound", "Lnet/minecraft/util/SoundEvent;", "getCurrentTemperature", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "consumeIfSuccess", "Companion", "VolcanusRecipeLogic", "gtlitecore"})
public final class MultiblockVolcanus
extends RecipeMapMultiblockController
implements IHeatingCoil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int motorCasingTier;
    private int coilTier;
    private int temperature;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.HASTELLOY_C276.getState();

    public MultiblockVolcanus(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, RecipeMaps.BLAST_RECIPES);
        this.recipeMapWorkable = (MultiblockRecipeLogic)new VolcanusRecipeLogic(this);
    }

    @NotNull
    public MultiblockVolcanus createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockVolcanus(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.motorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MOTOR_CASING_TIER, 0)).intValue();
        this.coilTier = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getTier();
        this.tier = Math.min(this.motorCasingTier, this.coilTier);
        this.temperature = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getCoilTemperature();
        this.temperature += 100 * Math.max(0, GTUtility.getTierByVoltage((long)this.getEnergyContainer().getInputVoltage()) - 2);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.motorCasingTier = 0;
        this.coilTier = 0;
        this.temperature = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"DDD", "CCC", "CCC", "DDD"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"DDD", "CMC", "CMC", "DOD"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"DSD", "CCC", "CCC", "DDD"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('D', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(9).or(this.autoAbilities(true, true, true, true, true, true, false)));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern4.where('O', RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray)).where('M', TraceabilityPredicates.motorCasings()).where('C', TraceabilityPredicates.coils()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.HASTELLOY_C276_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.BLAST_FURNACE_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"BLAST_FURNACE_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockVolcanus::addInformation$lambda$0));
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.energyContainer).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom((arg_0, arg_1) -> MultiblockVolcanus.configureDisplayText$lambda$1(this, arg_0, arg_1)).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    protected void configureWarningText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.configureWarningText(builder);
        builder.addCustom((arg_0, arg_1) -> MultiblockVolcanus.configureWarningText$lambda$2(this, arg_0, arg_1));
    }

    @NotNull
    public List<ITextComponent> getDataInfo() {
        List list = super.getDataInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataInfo(...)");
        List textList = list;
        TextComponentTranslation temperatureInfo = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((Object)this.temperature) + " K"), (Object[])new Object[0]);
        Object[] objectArray = new Object[]{temperatureInfo};
        textList.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])objectArray));
        return textList;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    @NotNull
    public SoundEvent getBreakdownSound() {
        SoundEvent soundEvent = GTSoundEvents.BREAKDOWN_ELECTRICAL;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BREAKDOWN_ELECTRICAL");
        return soundEvent;
    }

    public int getCurrentTemperature() {
        return this.temperature;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Object object = recipe.getProperty((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
        Intrinsics.checkNotNull((Object)object);
        return this.temperature >= ((Number)object).intValue();
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("Vol, AEBF");
        String[] stringArray = new String[]{"gtlitecore.machine.volcanus.tooltip.1", "gtlitecore.machine.volcanus.tooltip.2"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.overclockInfo(8);
        $this$addTooltip.durationInfo(UpgradeType.WIRE_COIL, 80);
        $this$addTooltip.parallelInfo(UpgradeType.MOTOR_CASING, 16);
        stringArray = new String[]{"gregtech.machine.electric_blast_furnace.tooltip.1", "gregtech.machine.electric_blast_furnace.tooltip.2", "gregtech.machine.electric_blast_furnace.tooltip.3"};
        $this$addTooltip.description(false, stringArray);
        return Unit.INSTANCE;
    }

    private static final void configureDisplayText$lambda$1(MultiblockVolcanus this$0, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed()) {
            IKey temperatureKey = KeyUtil.number((TextFormatting)TextFormatting.RED, (long)syncer.syncInt(this$0.getCurrentTemperature()), (String)"K");
            Object[] objectArray = new Object[]{temperatureKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])objectArray));
            if (this$0.getInputFluidInventory() != null) {
                FluidStack promoterStack;
                FluidStack fluidStack = promoterStack = this$0.getInputFluidInventory().drain(GTLiteMaterials.INSTANCE.getBlazingPyrotheum().getFluid(Integer.MAX_VALUE), false);
                int promoterAmount = fluidStack != null ? fluidStack.amount : 0;
                IKey amountKey = KeyUtil.number((TextFormatting)TextFormatting.GREEN, (long)promoterAmount, (String)"L");
                Object[] objectArray2 = new Object[]{amountKey};
                keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gtlitecore.machine.volcanus.pyrotheum_amount", (Object[])objectArray2));
            }
        }
    }

    private static final void configureWarningText$lambda$2(MultiblockVolcanus this$0, KeyManager keyManager, UISyncer syncer) {
        FluidStack promoterStack = this$0.getInputFluidInventory().drain(GTLiteMaterials.INSTANCE.getBlazingPyrotheum().getFluid(Integer.MAX_VALUE), false);
        if (promoterStack == null || promoterStack.amount == 0) {
            IKey warnKey = KeyUtil.lang((TextFormatting)TextFormatting.YELLOW, (String)"gtlitecore.machine.volcanus.pyrotheum_warning", (Object[])new Object[0]);
            keyManager.add((IDrawable)warnKey);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockVolcanus$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockVolcanus$VolcanusRecipeLogic;", "Lgregtech/api/capability/impl/HeatingCoilRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockVolcanus;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "mte", "Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockVolcanus;", "updateRecipeProgress", "", "getOverclockingDurationFactor", "", "setMaxProgress", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class VolcanusRecipeLogic
    extends HeatingCoilRecipeLogic {
        @NotNull
        private final MultiblockVolcanus mte;

        public VolcanusRecipeLogic(RecipeMapMultiblockController metaTileEntity) {
            Intrinsics.checkNotNullParameter((Object)metaTileEntity, (String)"metaTileEntity");
            super(metaTileEntity);
            this.mte = (MultiblockVolcanus)metaTileEntity;
        }

        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                IMultipleTankHandler inputTank = this.mte.getInputFluidInventory();
                FluidStack pyrotheumStack = GTLiteMaterials.INSTANCE.getBlazingPyrotheum().getFluid(2);
                if (pyrotheumStack.isFluidStackIdentical(inputTank.drain(pyrotheumStack, false))) {
                    inputTank.drain(pyrotheumStack, true);
                    ++this.progressTime;
                    if (this.progressTime > this.maxProgressTime) {
                        this.completeRecipe();
                    }
                } else {
                    return;
                }
                this.drawEnergy(this.recipeEUt, false);
            }
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.8, MultiblockVolcanus.this.motorCasingTier)));
        }

        public int getParallelLimit() {
            return 16 * MultiblockVolcanus.this.coilTier;
        }
    }
}

