/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0014J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J5\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010$\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010&\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020\bH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\bJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020\u00142\u0006\u00103\u001a\u000202H\u0016J\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00142\u0006\u00106\u001a\u000207H\u0016J\u0018\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;2\u0006\u00106\u001a\u000207H\u0016J3\u0010<\u001a\u0004\u0018\u0001H=\"\n\b\u0000\u0010=*\u0004\u0018\u00010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H=0@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016\u00a2\u0006\u0002\u0010CJ0\u0010D\u001a\u00020\u00142\u0006\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockTransformer;", "Lgregtech/api/metatileentity/multiblock/MultiblockWithDisplayBase;", "Lgregtech/api/capability/IControllable;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "isWorkingEnabled", "", "isActive", "inputEnergy", "Lgregtech/api/capability/IEnergyContainer;", "outputEnergy", "averageIOLastSec", "", "netIOLastSec", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "updateFormedValid", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "hasMaintenanceMechanics", "shouldShowVoidingModeButton", "setWorkingEnabled", "workingStatus", "setActive", "active", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "", "getCapability", "T", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "Companion", "gtlitecore"})
public final class MultiblockTransformer
extends MultiblockWithDisplayBase
implements IControllable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isWorkingEnabled;
    private boolean isActive;
    @NotNull
    private IEnergyContainer inputEnergy;
    @NotNull
    private IEnergyContainer outputEnergy;
    private long averageIOLastSec;
    private long netIOLastSec;
    @NotNull
    private static final IBlockState casingState = GTMetalCasing.ALUMINIUM_FROSTPROOF.getState();

    public MultiblockTransformer(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id);
        this.inputEnergy = (IEnergyContainer)new EnergyContainerList((List)new ArrayList());
        this.outputEnergy = (IEnergyContainer)new EnergyContainerList((List)new ArrayList());
    }

    @NotNull
    public MultiblockTransformer createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockTransformer(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        List inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        List list = this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAbilities(...)");
        inputEnergy.addAll(list);
        List outputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
        List list2 = this.getAbilities(MultiblockAbility.SUBSTATION_OUTPUT_ENERGY);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAbilities(...)");
        outputEnergy.addAll(list2);
        if (inputEnergy.isEmpty() || outputEnergy.isEmpty()) {
            this.invalidateStructure();
        }
        this.inputEnergy = (IEnergyContainer)new EnergyContainerList(inputEnergy);
        this.outputEnergy = (IEnergyContainer)new EnergyContainerList(outputEnergy);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.inputEnergy = (IEnergyContainer)new EnergyContainerList((List)new ArrayList());
        this.outputEnergy = (IEnergyContainer)new EnergyContainerList((List)new ArrayList());
        this.setActive(false);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CSC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiblockWithDisplayBase.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.OUTPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate3 = traceabilityPredicate2.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.SUBSTATION_INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate4 = traceabilityPredicate3.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(0));
        stringArray = new MultiblockAbility[]{MultiblockAbility.SUBSTATION_OUTPUT_ENERGY};
        BlockPattern blockPattern = factoryBlockPattern.where('C', traceabilityPredicate4.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(0))).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            if (this.getOffsetTimer() % (long)20 == 0L) {
                this.averageIOLastSec = this.netIOLastSec / (long)20;
                this.netIOLastSec = 0L;
            }
            if (this.isWorkingEnabled()) {
                long drainableEnergy = this.inputEnergy.getEnergyStored();
                long totalDrainedEnergy = this.outputEnergy.changeEnergy(drainableEnergy);
                this.inputEnergy.removeEnergy(totalDrainedEnergy);
                this.netIOLastSec += totalDrainedEnergy;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        SimpleOverlayRenderer simpleOverlayRenderer = Textures.FROST_PROOF_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"FROST_PROOF_CASING");
        return (ICubeRenderer)simpleOverlayRenderer;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.frontFacing, this.isActive, this.isWorkingEnabled);
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(true, this.isActive).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.machine.active_transformer.routing").addCustom((arg_0, arg_1) -> MultiblockTransformer.configureDisplayText$lambda$0(this, arg_0, arg_1)).addWorkingStatusLine();
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean workingStatus) {
        this.isWorkingEnabled = workingStatus;
        this.markDirty();
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> MultiblockTransformer.setWorkingEnabled$lambda$1(this, arg_0));
        }
    }

    public boolean isActive() {
        return super.isActive() && this.isWorkingEnabled;
    }

    public final void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, arg_0 -> MultiblockTransformer.setActive$lambda$2(active, arg_0));
            }
        }
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        String string = I18n.func_135052_a((String)"gtlitecore.machine.large_transformer.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.large_transformer.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
    }

    private static final void configureDisplayText$lambda$0(MultiblockTransformer this$0, KeyManager tooltip, UISyncer syncer) {
        if (this$0.isStructureFormed()) {
            IKey maxInputKey = KeyUtil.number((TextFormatting)TextFormatting.WHITE, (long)syncer.syncLong(this$0.inputEnergy.getInputVoltage() * this$0.inputEnergy.getInputAmperage()), (String)" EU/t");
            Object[] objectArray = new Object[]{maxInputKey};
            tooltip.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GREEN, (String)"gregtech.multiblock.active_transformer.max_in", (Object[])objectArray));
            IKey maxOutputKey = KeyUtil.number((TextFormatting)TextFormatting.WHITE, (long)syncer.syncLong(this$0.outputEnergy.getOutputVoltage() * this$0.outputEnergy.getOutputAmperage()), (String)" EU/t");
            Object[] objectArray2 = new Object[]{maxOutputKey};
            tooltip.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.RED, (String)"gregtech.multiblock.active_transformer.max_out", (Object[])objectArray2));
            IKey avgIOKey = KeyUtil.number((TextFormatting)TextFormatting.WHITE, (long)syncer.syncLong(this$0.averageIOLastSec), (String)" EU/t");
            Object[] objectArray3 = new Object[]{avgIOKey};
            tooltip.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.AQUA, (String)"gregtech.multiblock.active_transformer.average_io", (Object[])objectArray3));
        }
    }

    private static final void setWorkingEnabled$lambda$1(MultiblockTransformer this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isWorkingEnabled);
    }

    private static final void setActive$lambda$2(boolean $active, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean($active);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockTransformer$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

