/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTFusionCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002&'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0015J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockReplicator;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "fieldGenCasingTier", "", "emitterCasingTier", "sensorCasingTier", "processorCasingTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "Companion", "LargeReplicatorRecipeLogic", "gtlitecore"})
public final class MultiblockReplicator
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int fieldGenCasingTier;
    private int emitterCasingTier;
    private int sensorCasingTier;
    private int processorCasingTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.RENE_N5.getState();
    @NotNull
    private static final IBlockState coilState = GTFusionCasing.SUPERCONDUCTOR_COIL.getState();

    public MultiblockReplicator(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, RecipeMaps.REPLICATOR_RECIPES);
        this.recipeMapWorkable = new LargeReplicatorRecipeLogic(this);
    }

    @NotNull
    public MultiblockReplicator createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockReplicator(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.fieldGenCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.FIELD_GEN_CASING_TIER, 0)).intValue();
        this.emitterCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.EMITTER_CASING_TIER, 0)).intValue();
        this.sensorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.SENSOR_CASING_TIER, 0)).intValue();
        this.processorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PROCESSOR_CASING_TIER, 0)).intValue();
        int[] nArray = new int[]{this.emitterCasingTier, this.sensorCasingTier, this.processorCasingTier};
        this.tier = ComparisonsKt.minOf((int)this.fieldGenCasingTier, (int[])nArray);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.fieldGenCasingTier = 0;
        this.emitterCasingTier = 0;
        this.sensorCasingTier = 0;
        this.processorCasingTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"     XXEXX     ", "     XXEXX     ", "       X       "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"   XXXXXXXXX   ", "   XXCCCCCXX   ", "     XPXPX     "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"  XXXXXEXXXXX  ", "  XCCCXSXCCCX  ", "   XXF s FXX   "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{" XXXXX   XXXXX ", " XCCXX   XXCCX ", "  XF       FX  "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{" XXX       XXX ", " XCX       XCX ", "  X         X  "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"XXXX       XXXX", "XCCX       XCCX", " XF         FX "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"XXX         XXX", "XCX         XCX", " P           P "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{"EXE         EXE", "ECE         ECE", "XXs         sXX"};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{"XXX         XXX", "XCX         XCX", " P           P "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"XXXX       XXXX", "XCCX       XCCX", " XF         FX "};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{" XXX       XXX ", " XCX       XCX ", "  X         X  "};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{" XXXXX   XXXXX ", " XCCXX   XXCCX ", "  XF       FX  "};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"  XXXXXEXXXXX  ", "  XCCCXEXCCCX  ", "   XXF s FXX   "};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"   XXXXXXXXX   ", "   XXCCCCCXX   ", "     XPXPX     "};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{"     XXEXX     ", "     XXEXX     ", "       X       "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.where('X', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(30).or(this.autoAbilities(true, true, true, true, true, true, false)));
        stringArray = new IBlockState[]{coilState};
        BlockPattern blockPattern = factoryBlockPattern16.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray)).where('F', TraceabilityPredicates.fieldGenCasings()).where('P', TraceabilityPredicates.processorCasings()).where('s', TraceabilityPredicates.sensorCasings()).where('E', TraceabilityPredicates.emitterCasings()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.RENE_N5_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.REPLICATOR_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"REPLICATOR_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockReplicator::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return false;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("LRep");
        $this$addTooltip.description(true, new String[0]);
        $this$addTooltip.overclockInfo(8);
        String[] stringArray = new String[]{"gtlitecore.machine.large_replicator.tooltip.1", "gtlitecore.machine.large_replicator.tooltip.2"};
        $this$addTooltip.description(false, stringArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockReplicator$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "coilState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockReplicator$LargeReplicatorRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockReplicator;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class LargeReplicatorRecipeLogic
    extends MultiblockRecipeLogic {
        public LargeReplicatorRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, Math.min(MultiblockReplicator.this.emitterCasingTier, MultiblockReplicator.this.sensorCasingTier))));
        }

        public int getParallelLimit() {
            return 4 * Math.min(MultiblockReplicator.this.fieldGenCasingTier, MultiblockReplicator.this.processorCasingTier);
        }
    }
}

