/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0015J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockExtractor;", "Lgregtech/api/metatileentity/multiblock/MultiMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "pumpCasingTier", "", "motorCasingTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "Companion", "LargeExtractorRecipeLogic", "gtlitecore"})
public final class MultiblockExtractor
extends MultiMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pumpCasingTier;
    private int motorCasingTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.TALONITE.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.STEEL_PIPE.getState();

    public MultiblockExtractor(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RecipeMap[] recipeMapArray = new RecipeMap[]{RecipeMaps.EXTRACTOR_RECIPES, RecipeMaps.CANNER_RECIPES};
        super(id, recipeMapArray);
        this.recipeMapWorkable = new LargeExtractorRecipeLogic((RecipeMapMultiblockController)this);
    }

    @NotNull
    public MultiblockExtractor createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockExtractor(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.pumpCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PUMP_CASING_TIER, 0)).intValue();
        this.motorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MOTOR_CASING_TIER, 0)).intValue();
        this.tier = Math.min(this.pumpCasingTier, this.motorCasingTier);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.pumpCasingTier = 0;
        this.motorCasingTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCCCC", "C   C", "C   C", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCCCC", " CCC ", " CCC ", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CCCCC", " PQM ", " CQC ", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"CCCCC", " CSC ", " CCC ", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "C   C", "C   C", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('C', MultiMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(16).or(this.autoAbilities(true, true, true, true, true, true, false)));
        stringArray = new IBlockState[]{pipeCasingState};
        BlockPattern blockPattern = factoryBlockPattern6.where('Q', MultiMapMultiblockController.states((IBlockState[])stringArray)).where('P', TraceabilityPredicates.pumpCasings()).where('M', TraceabilityPredicates.motorCasings()).where(' ', MultiMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.TALONITE_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.PROCESSING_ARRAY_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"PROCESSING_ARRAY_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockExtractor::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return true;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("LEa");
        $this$addTooltip.description(true, new String[0]);
        $this$addTooltip.overclockInfo(8);
        $this$addTooltip.durationInfo(UpgradeType.MOTOR_CASING, 50);
        $this$addTooltip.parallelInfo(UpgradeType.PUMP_CASING, 16);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockExtractor$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockExtractor$LargeExtractorRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockExtractor;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class LargeExtractorRecipeLogic
    extends MultiblockRecipeLogic {
        public LargeExtractorRecipeLogic(RecipeMapMultiblockController mte) {
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.8, MultiblockExtractor.this.motorCasingTier)));
        }

        public int getParallelLimit() {
            return 16 * MultiblockExtractor.this.pumpCasingTier;
        }
    }
}

