/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import gregtech.api.GTValues;
import gregtech.api.capability.IDistillationTower;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.DistillationTowerLogicHandler;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0002,-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0017J\b\u0010 \u001a\u00020\u001dH\u0015J\b\u0010!\u001a\u00020\u0019H\u0002J0\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0019H\u0016J\b\u0010+\u001a\u00020\u0019H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockDistillery;", "Lgregtech/api/metatileentity/multiblock/MultiMapMultiblockController;", "Lgregtech/api/capability/IDistillationTower;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "workableHandler", "Lgregtech/api/capability/impl/DistillationTowerLogicHandler;", "casingTier", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "multiblockPartSorter", "Ljava/util/function/Function;", "Lnet/minecraft/util/math/BlockPos;", "allowsExtendedFacing", "", "allowSameFluidFillForOutputs", "getFluidOutputLimit", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "usesAdvancedHatchLogic", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "canBeDistinct", "Companion", "LargeDistilleryRecipeLogic", "gtlitecore"})
public final class MultiblockDistillery
extends MultiMapMultiblockController
implements IDistillationTower {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DistillationTowerLogicHandler workableHandler;
    private int casingTier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.SILICON_CARBIDE.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.TUNGSTENSTEEL_PIPE.getState();

    public MultiblockDistillery(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RecipeMap[] recipeMapArray = new RecipeMap[]{RecipeMaps.DISTILLERY_RECIPES, RecipeMaps.DISTILLATION_RECIPES};
        super(id, recipeMapArray);
        this.recipeMapWorkable = new LargeDistilleryRecipeLogic((RecipeMapMultiblockController)this);
        this.workableHandler = new DistillationTowerLogicHandler((IDistillationTower)this);
    }

    @NotNull
    public MultiblockDistillery createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockDistillery(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        if (this.structurePattern == null) {
            return;
        }
        if (this.usesAdvancedHatchLogic()) {
            DistillationTowerLogicHandler distillationTowerLogicHandler = this.workableHandler;
            if (distillationTowerLogicHandler != null) {
                BlockPattern blockPattern = this.structurePattern;
                Intrinsics.checkNotNull((Object)blockPattern);
                distillationTowerLogicHandler.determineLayerCount(blockPattern);
            }
            DistillationTowerLogicHandler distillationTowerLogicHandler2 = this.workableHandler;
            if (distillationTowerLogicHandler2 != null) {
                distillationTowerLogicHandler2.determineOrderedFluidOutputs();
            }
        }
        this.casingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PUMP_CASING_TIER, 0)).intValue();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        if (this.workableHandler != null) {
            DistillationTowerLogicHandler distillationTowerLogicHandler = this.workableHandler;
            Intrinsics.checkNotNull((Object)distillationTowerLogicHandler);
            distillationTowerLogicHandler.invalidate();
        }
        this.casingTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"DSD", "DQD", "DDD"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP).aisle(stringArray);
        stringArray = new String[]{"CCC", "CPC", "CCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray).setRepeatable(1, 11);
        stringArray = new String[]{"CCC", "CCC", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(1).setPreviewCount(0));
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS};
        TraceabilityPredicate traceabilityPredicate3 = traceabilityPredicate2.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate4 = traceabilityPredicate3.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1).setMaxGlobalLimited(4));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('D', traceabilityPredicate4.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1)));
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate5 = MultiMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.where('C', traceabilityPredicate5.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxLayerLimited(1, 1)).or(this.autoAbilities(true, false)));
        stringArray = new IBlockState[]{pipeCasingState};
        BlockPattern blockPattern = factoryBlockPattern5.where('P', MultiMapMultiblockController.states((IBlockState[])stringArray)).where('Q', TraceabilityPredicates.pumpCasings()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @NotNull
    protected Function<BlockPos, Integer> multiblockPartSorter() {
        Function function = RelativeDirection.UP.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        Intrinsics.checkNotNullExpressionValue((Object)function, (String)"getSorter(...)");
        return function;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public boolean allowSameFluidFillForOutputs() {
        return !this.usesAdvancedHatchLogic();
    }

    public int getFluidOutputLimit() {
        int n;
        if (this.workableHandler != null && this.usesAdvancedHatchLogic()) {
            DistillationTowerLogicHandler distillationTowerLogicHandler = this.workableHandler;
            Intrinsics.checkNotNull((Object)distillationTowerLogicHandler);
            n = distillationTowerLogicHandler.getLayerCount();
        } else {
            n = super.getFluidOutputLimit();
        }
        return n;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.SILICON_CARBIDE_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.DISTILLATION_TOWER_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"DISTILLATION_TOWER_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    private final boolean usesAdvancedHatchLogic() {
        return this.getCurrentRecipeMap() == RecipeMaps.DISTILLATION_RECIPES;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockDistillery::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return false;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("LDis");
        String[] stringArray = new String[]{I18n.func_135052_a((String)"gtlitecore.machine.large_distillery.tooltip.1", (Object[])new Object[0]) + TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]), I18n.func_135052_a((String)"gtlitecore.machine.large_distillery.tooltip.2", (Object[])new Object[0]) + TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gtlitecore.machine.large_distillery.tooltip.3", (Object[])new Object[0])};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.durationInfo(UpgradeType.VOLTAGE_TIER, 50);
        $this$addTooltip.parallelInfo(UpgradeType.PUMP_CASING, 16);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockDistillery$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockDistillery$LargeDistilleryRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockDistillery;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "outputRecipeOutputs", "", "checkOutputSpaceFluids", "", "recipe", "Lgregtech/api/recipes/Recipe;", "exportFluids", "Lgregtech/api/capability/IMultipleTankHandler;", "getOutputTank", "getOverclockingDurationFactor", "", "setMaxProgress", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class LargeDistilleryRecipeLogic
    extends MultiblockRecipeLogic {
        public LargeDistilleryRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte);
        }

        protected void outputRecipeOutputs() {
            if (MultiblockDistillery.this.usesAdvancedHatchLogic()) {
                GTTransferUtils.addItemsToItemHandler((IItemHandler)((IItemHandler)this.getOutputInventory()), (boolean)false, (List)this.itemOutputs);
                DistillationTowerLogicHandler distillationTowerLogicHandler = MultiblockDistillery.this.workableHandler;
                if (distillationTowerLogicHandler != null) {
                    distillationTowerLogicHandler.applyFluidToOutputs(this.fluidOutputs, true);
                }
            } else {
                super.outputRecipeOutputs();
            }
        }

        protected boolean checkOutputSpaceFluids(@NotNull Recipe recipe, @NotNull IMultipleTankHandler exportFluids) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)exportFluids, (String)"exportFluids");
            if (MultiblockDistillery.this.usesAdvancedHatchLogic()) {
                if (!this.metaTileEntity.canVoidRecipeFluidOutputs()) {
                    DistillationTowerLogicHandler distillationTowerLogicHandler = MultiblockDistillery.this.workableHandler;
                    Intrinsics.checkNotNull((Object)distillationTowerLogicHandler);
                    if (!distillationTowerLogicHandler.applyFluidToOutputs(recipe.getAllFluidOutputs(), false)) {
                        this.isOutputsFull = true;
                        return false;
                    }
                }
                return true;
            }
            return super.checkOutputSpaceFluids(recipe, exportFluids);
        }

        @Nullable
        protected IMultipleTankHandler getOutputTank() {
            if (MultiblockDistillery.this.usesAdvancedHatchLogic()) {
                DistillationTowerLogicHandler distillationTowerLogicHandler = MultiblockDistillery.this.workableHandler;
                return distillationTowerLogicHandler != null ? distillationTowerLogicHandler.getFluidTanks() : null;
            }
            return super.getOutputTank();
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] && MultiblockDistillery.this.usesAdvancedHatchLogic() || !MultiblockDistillery.this.usesAdvancedHatchLogic() ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, GTUtility.getTierByVoltage((long)this.getMaxVoltage()))));
        }

        public int getParallelLimit() {
            return 16 * MultiblockDistillery.this.casingTier;
        }
    }
}

