/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0015J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010'\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCryogenicFreezer;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "pumpCasingTier", "", "motorCasingTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "configureWarningText", "canBeDistinct", "Companion", "CryogenicFreezerRecipeLogic", "gtlitecore"})
public final class MultiblockCryogenicFreezer
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pumpCasingTier;
    private int motorCasingTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.HASTELLOY_X.getState();

    public MultiblockCryogenicFreezer(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, RecipeMaps.VACUUM_RECIPES);
        this.recipeMapWorkable = new CryogenicFreezerRecipeLogic(this);
    }

    @NotNull
    public MultiblockCryogenicFreezer createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockCryogenicFreezer(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.pumpCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PUMP_CASING_TIER, 0)).intValue();
        this.motorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MOTOR_CASING_TIER, 0)).intValue();
        this.tier = Math.min(this.pumpCasingTier, this.motorCasingTier);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.pumpCasingTier = 0;
        this.motorCasingTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCC", "CCC", "CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CMC", "CPC", "CCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CCC", "CSC", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        BlockPattern blockPattern = factoryBlockPattern3.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(4).or(this.autoAbilities(true, true, true, true, true, true, false))).where('P', TraceabilityPredicates.pumpCasings()).where('M', TraceabilityPredicates.motorCasings()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.HASTELLOY_X_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.VACUUM_FREEZER_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"VACUUM_FREEZER_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockCryogenicFreezer::addInformation$lambda$0));
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.energyContainer).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom((arg_0, arg_1) -> MultiblockCryogenicFreezer.configureDisplayText$lambda$1(this, arg_0, arg_1)).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    protected void configureWarningText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.configureWarningText(builder);
        builder.addCustom((arg_0, arg_1) -> MultiblockCryogenicFreezer.configureWarningText$lambda$2(this, arg_0, arg_1));
    }

    public boolean canBeDistinct() {
        return true;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("LCryF");
        String[] stringArray = new String[]{"gtlitecore.machine.cryogenic_freezer.tooltip.1", "gtlitecore.machine.cryogenic_freezer.tooltip.2"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.durationInfo(UpgradeType.PUMP_CASING, 50);
        $this$addTooltip.parallelInfo(UpgradeType.MOTOR_CASING, 16);
        return Unit.INSTANCE;
    }

    private static final void configureDisplayText$lambda$1(MultiblockCryogenicFreezer this$0, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed() && this$0.getInputFluidInventory() != null) {
            FluidStack coolantStack;
            FluidStack fluidStack = coolantStack = this$0.getInputFluidInventory().drain(GTLiteMaterials.INSTANCE.getGelidCryotheum().getFluid(Integer.MAX_VALUE), false);
            int coolantAmount = fluidStack != null ? fluidStack.amount : 0;
            IKey amountKey = KeyUtil.number((TextFormatting)TextFormatting.GREEN, (long)coolantAmount, (String)"L");
            Object[] objectArray = new Object[]{amountKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gtlitecore.machine.cryogenic_freezer.cryotheum_amount", (Object[])objectArray));
        }
    }

    private static final void configureWarningText$lambda$2(MultiblockCryogenicFreezer this$0, KeyManager keyManager, UISyncer syncer) {
        FluidStack coolantStack;
        if (this$0.isStructureFormed() && ((coolantStack = this$0.getInputFluidInventory().drain(GTLiteMaterials.INSTANCE.getGelidCryotheum().getFluid(Integer.MAX_VALUE), false)) == null || coolantStack.amount == 0)) {
            IKey warnKey = KeyUtil.lang((TextFormatting)TextFormatting.YELLOW, (String)"gtlitecore.machine.cryogenic_freezer_cryotheum_warning", (Object[])new Object[0]);
            keyManager.add((IDrawable)warnKey);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCryogenicFreezer$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCryogenicFreezer$CryogenicFreezerRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCryogenicFreezer;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCryogenicFreezer;", "updateRecipeProgress", "", "getOverclockingDurationFactor", "", "setMaxProgress", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class CryogenicFreezerRecipeLogic
    extends MultiblockRecipeLogic {
        @NotNull
        private final MultiblockCryogenicFreezer mte;

        public CryogenicFreezerRecipeLogic(RecipeMapMultiblockController mte) {
            super(mte);
            Intrinsics.checkNotNull((Object)mte, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced.MultiblockCryogenicFreezer");
            this.mte = (MultiblockCryogenicFreezer)mte;
        }

        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                IMultipleTankHandler inputTank = this.mte.getInputFluidInventory();
                FluidStack cryotheumStack = GTLiteMaterials.INSTANCE.getGelidCryotheum().getFluid(2);
                if (cryotheumStack.isFluidStackIdentical(inputTank.drain(cryotheumStack, false))) {
                    inputTank.drain(cryotheumStack, true);
                    ++this.progressTime;
                    if (this.progressTime > this.maxProgressTime) {
                        this.completeRecipe();
                    }
                } else {
                    return;
                }
                this.drawEnergy(this.recipeEUt, false);
            }
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, MultiblockCryogenicFreezer.this.pumpCasingTier)));
        }

        public int getParallelLimit() {
            return 16 * MultiblockCryogenicFreezer.this.motorCasingTier;
        }
    }
}

