/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityEnergyHatch;
import gregtech.core.sound.GTSoundEvents;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.property.CircuitPatternProperty;
import gregtechlite.gtlitecore.common.block.adapter.GTGlassCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMultiblockCasing;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0006\u0010!\u001a\u00020\"\u00a8\u0006%"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCircuitAssemblyLine;", "Lgregtech/api/metatileentity/multiblock/MultiMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "getBreakdownSound", "Lnet/minecraft/util/SoundEvent;", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "consumeIfSuccess", "getInputInventorySize", "", "Companion", "CircuitAssemblyLineRecipeLogic", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMultiblockCircuitAssemblyLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockCircuitAssemblyLine.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCircuitAssemblyLine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1755#2,3:150\n*S KotlinDebug\n*F\n+ 1 MultiblockCircuitAssemblyLine.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCircuitAssemblyLine\n*L\n125#1:150,3\n*E\n"})
public final class MultiblockCircuitAssemblyLine
extends MultiMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IBlockState casingState = GTMetalCasing.STEEL_SOLID.getState();
    @NotNull
    private static final IBlockState secondCasingState = GTMultiblockCasing.GRATE_CASING.getState();
    @NotNull
    private static final IBlockState thirdCasingState = GTMultiblockCasing.ASSEMBLY_LINE_CASING.getState();
    @NotNull
    private static final IBlockState glassState = GTGlassCasing.LAMINATED_GLASS.getState();

    public MultiblockCircuitAssemblyLine(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RecipeMap[] recipeMapArray = new RecipeMap[]{RecipeMaps.CIRCUIT_ASSEMBLER_RECIPES, GTLiteRecipeMaps.CIRCUIT_ASSEMBLY_LINE_RECIPES};
        super(id, recipeMapArray);
        this.recipeMapWorkable = new CircuitAssemblyLineRecipeLogic((RecipeMapMultiblockController)this);
    }

    @NotNull
    public MultiblockCircuitAssemblyLine createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockCircuitAssemblyLine(resourceLocation);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"FIF", "RTR", "SYG"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start((RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.RIGHT).aisle(stringArray);
        stringArray = new String[]{"FIF", "RTR", "GYG"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray).setRepeatable(3, 15);
        stringArray = new String[]{"FOF", "RTR", "GYG"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('F', traceabilityPredicate2.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(4).setPreviewCount(1)));
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS};
        TraceabilityPredicate traceabilityPredicate3 = MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1);
        stringArray = new String[]{"gregtech.multiblock.pattern.location_end"};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.where('O', traceabilityPredicate3.addTooltips(stringArray));
        stringArray = new IBlockState[]{secondCasingState};
        TraceabilityPredicate traceabilityPredicate4 = MultiMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('Y', traceabilityPredicate4.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1).setMaxGlobalLimited(3)));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.where('I', MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('G', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{glassState};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.where('R', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{thirdCasingState};
        BlockPattern blockPattern = factoryBlockPattern9.where('T', MultiMapMultiblockController.states((IBlockState[])stringArray)).where(' ', MultiMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        ICubeRenderer iCubeRenderer;
        if (sourcePart == null || sourcePart instanceof MetaTileEntityEnergyHatch) {
            ICubeRenderer iCubeRenderer2 = this.isStructureFormed() ? (ICubeRenderer)Textures.GRATE_CASING_STEEL_FRONT : (ICubeRenderer)Textures.SOLID_STEEL_CASING;
            Intrinsics.checkNotNull((Object)iCubeRenderer2);
            iCubeRenderer = iCubeRenderer2;
        } else {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.SOLID_STEEL_CASING;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"SOLID_STEEL_CASING");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        }
        return iCubeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
        String string = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
        String string5 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.5", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        tooltip.add(string5);
        String string6 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.6", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        tooltip.add(string6);
        String string7 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.7", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        tooltip.add(string7);
        String string8 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.8", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
        tooltip.add(string8);
        String string9 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.9", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        tooltip.add(string9);
        String string10 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.10", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(...)");
        tooltip.add(string10);
        String string11 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.11", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
        tooltip.add(string11);
        String string12 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.12", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
        tooltip.add(string12);
        String string13 = I18n.func_135052_a((String)"gtlitecore.machine.circuit_assembly_line.tooltip.13", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
        tooltip.add(string13);
    }

    public boolean canBeDistinct() {
        return true;
    }

    @NotNull
    public SoundEvent getBreakdownSound() {
        SoundEvent soundEvent = GTSoundEvents.BREAKDOWN_ELECTRICAL;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BREAKDOWN_ELECTRICAL");
        return soundEvent;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        if (Intrinsics.areEqual((Object)this.getRecipeMap(), GTLiteRecipeMaps.CIRCUIT_ASSEMBLY_LINE_RECIPES)) {
            boolean hasTargetCircuitPattern;
            block7: {
                boolean bl2;
                ItemStack targetStack;
                ItemHandlerList itemInputs = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
                ItemStack itemStack = targetStack = (ItemStack)recipe.getProperty((RecipeProperty)CircuitPatternProperty.INSTANCE, null);
                if (itemStack != null) {
                    ItemStack stack = itemStack;
                    boolean bl3 = false;
                    Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)itemInputs.getSlots());
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            ItemStack currentStack;
                            int element$iv;
                            int i = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)itemInputs.getStackInSlot(i), (String)"getStackInSlot(...)");
                            if (!currentStack.func_77969_a(stack)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                } else {
                    bl2 = hasTargetCircuitPattern = false;
                }
            }
            bl = super.checkRecipe(recipe, consumeIfSuccess) && hasTargetCircuitPattern;
        } else {
            bl = super.checkRecipe(recipe, consumeIfSuccess);
        }
        return bl;
    }

    public final int getInputInventorySize() {
        return this.getAbilities(MultiblockAbility.IMPORT_ITEMS).size();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCircuitAssemblyLine$CircuitAssemblyLineRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCircuitAssemblyLine;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class CircuitAssemblyLineRecipeLogic
    extends MultiblockRecipeLogic {
        public CircuitAssemblyLineRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte, true);
        }

        public void setMaxProgress(int maxProgress) {
            this.maxProgressTime = Intrinsics.areEqual((Object)this.getRecipeMap(), (Object)RecipeMaps.CIRCUIT_ASSEMBLER_RECIPES) ? maxProgress / 2 : maxProgress;
        }

        public int getParallelLimit() {
            return (MultiblockCircuitAssemblyLine.this.getInputInventorySize() - 4) * 4;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockCircuitAssemblyLine$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "thirdCasingState", "glassState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

