/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTFireboxCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0014H\u0015J0\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockBurnerReactor;", "Lgregtech/api/metatileentity/multiblock/MultiMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "casingTier", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "onRemoval", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "disableFireboxAsActive", "Companion", "LargeBurnerReactorRecipeLogic", "gtlitecore"})
public final class MultiblockBurnerReactor
extends MultiMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int casingTier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.INCOLOY_MA813.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.TITANIUM_PIPE.getState();
    @NotNull
    private static final IBlockState fireboxCasingState = GTFireboxCasing.TITANIUM_FIREBOX.getState();

    public MultiblockBurnerReactor(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RecipeMap[] recipeMapArray = new RecipeMap[]{GTLiteRecipeMaps.BURNER_REACTOR_RECIPES, GTLiteRecipeMaps.ROASTER_RECIPES};
        super(id, recipeMapArray);
        this.recipeMapWorkable = new LargeBurnerReactorRecipeLogic((RecipeMapMultiblockController)this);
    }

    @NotNull
    public MultiblockBurnerReactor createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockBurnerReactor(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.casingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MOTOR_CASING_TIER, 0)).intValue();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.casingTier = 0;
        this.disableFireboxAsActive();
    }

    public void onRemoval() {
        super.onRemoval();
        if (!this.getWorld().field_72995_K && this.isStructureFormed()) {
            this.disableFireboxAsActive();
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"     ", "     ", " P P ", " P P ", " P P "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"F   F", "FBBBF", "XPXPX", "XXXXX", " P P "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"     ", "XBBBX", "XPNPX", "XPMPX", " P P "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"F   F", "FBBBF", "XXSXX", "XXXXX", "     "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.where('X', MultiMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(14).or(this.autoAbilities(true, true, true, true, true, true, false)));
        stringArray = new IBlockState[]{pipeCasingState};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('P', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{fireboxCasingState};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.where('B', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new Material[]{GTLiteMaterials.INSTANCE.getIncoloyMA813()};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('F', MultiMapMultiblockController.frames((Material[])stringArray));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern8.where('M', MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray)).where('N', TraceabilityPredicates.motorCasings()).where(' ', MultiMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.INCOLOY_MA813_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.LARGE_BURNER_REACTOR_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockBurnerReactor::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return true;
    }

    private final void disableFireboxAsActive() {
        BlockPos centerPos = this.getPos().func_177972_a(this.getFrontFacing().func_176734_d()).func_177977_b();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos blockPos = centerPos.func_177982_a(x, 0, z);
                IBlockState blockState = this.getWorld().func_180495_p(blockPos);
                if (!(blockState.func_177230_c() instanceof BlockFireboxCasing)) continue;
                IBlockState iBlockState = blockState;
                Intrinsics.checkNotNull((Object)iBlockState, (String)"null cannot be cast to non-null type net.minecraftforge.common.property.IExtendedBlockState");
                blockState = (IBlockState)((IExtendedBlockState)iBlockState).withProperty((IUnlistedProperty)BlockFireboxCasing.ACTIVE, (Object)false);
                this.getWorld().func_175656_a(blockPos, blockState);
            }
        }
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("LBuR");
        $this$addTooltip.description(true, new String[0]);
        $this$addTooltip.overclockInfo(8);
        $this$addTooltip.durationInfo(UpgradeType.VOLTAGE_TIER, 50);
        $this$addTooltip.parallelInfo(UpgradeType.MOTOR_CASING, 16);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockBurnerReactor$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "pipeCasingState", "fireboxCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockBurnerReactor$LargeBurnerReactorRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockBurnerReactor;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class LargeBurnerReactorRecipeLogic
    extends MultiblockRecipeLogic {
        public LargeBurnerReactorRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, GTUtility.getTierByVoltage((long)this.getMaxVoltage()))));
        }

        public int getParallelLimit() {
            return 16 * MultiblockBurnerReactor.this.casingTier;
        }
    }
}

