/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.GTValues;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.HeatingCoilRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.recipes.properties.impl.TemperatureProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockWireCoil;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.variant.ActiveUniqueCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 22\u00020\u00012\u00020\u0002:\u000223B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0015J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\b\u0010+\u001a\u00020$H\u0016J\b\u0010,\u001a\u00020$H\u0016J\u0018\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$H\u0016J\b\u00101\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAlloyBlastSmelter;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "Lgregtech/api/capability/IHeatingCoil;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "pumpCasingTier", "", "coilTier", "tier", "temperature", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "getDataInfo", "", "Lnet/minecraft/util/text/ITextComponent;", "canBeDistinct", "hasMufflerMechanics", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "consumeIfSuccess", "getCurrentTemperature", "Companion", "AlloyBlastSmelterRecipeLogic", "gtlitecore"})
public final class MultiblockAlloyBlastSmelter
extends RecipeMapMultiblockController
implements IHeatingCoil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pumpCasingTier;
    private int coilTier;
    private int tier;
    private int temperature;
    @NotNull
    private static final IBlockState casingState = MetalCasing.ZIRCONIUM_CARBIDE.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.TUNGSTENSTEEL_PIPE.getState();
    @NotNull
    private static final IBlockState uniqueCasingState = ActiveUniqueCasing.HEAT_VENT.getState();

    public MultiblockAlloyBlastSmelter(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.ALLOY_BLAST_RECIPES);
        this.recipeMapWorkable = (MultiblockRecipeLogic)new AlloyBlastSmelterRecipeLogic(this);
    }

    @NotNull
    public MultiblockAlloyBlastSmelter createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockAlloyBlastSmelter(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.pumpCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PUMP_CASING_TIER, 0)).intValue();
        this.coilTier = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getTier();
        this.tier = Math.min(this.pumpCasingTier, this.coilTier);
        this.temperature = ((IHeatingCoilBlockStats)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.COIL_TIER, BlockWireCoil.CoilType.CUPRONICKEL)).getCoilTemperature();
        this.temperature += 100 * Math.max(0, GTUtility.getTierByVoltage((long)this.energyContainer.getInputVoltage()) - 2);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.pumpCasingTier = 0;
        this.temperature = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{" CCC ", " HHH ", " UUU ", " HHH ", " CCC "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCCCC", "H###H", "U###U", "H###H", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "H#P#H", "U#Q#U", "H#P#H", "CCOCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "H###H", "U###U", "H###H", "CCCCC"};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{" CSC ", " HHH ", " UUU ", " HHH ", " CCC "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(10).or(this.autoAbilities(true, true, true, false, true, true, false)));
        stringArray = new IBlockState[]{pipeCasingState};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.where('Q', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{uniqueCasingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('U', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern8.where('O', RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray)).where('H', TraceabilityPredicates.coils()).where('P', TraceabilityPredicates.pumpCasings()).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.ZIRCONIUM_CARBIDE_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.ALLOY_BLAST_SMELTER_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockAlloyBlastSmelter::addInformation$lambda$0));
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.energyContainer).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom((arg_0, arg_1) -> MultiblockAlloyBlastSmelter.configureDisplayText$lambda$1(this, arg_0, arg_1)).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    @NotNull
    public List<ITextComponent> getDataInfo() {
        List list = super.getDataInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataInfo(...)");
        List textList = list;
        TextComponentTranslation temperatureInfo = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((long)this.temperature) + " K"), (Object[])new Object[0]);
        Object[] objectArray = new Object[]{temperatureInfo};
        textList.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])objectArray));
        return textList;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Object object = recipe.getProperty((RecipeProperty)TemperatureProperty.getInstance(), (Object)0);
        Intrinsics.checkNotNull((Object)object);
        return this.temperature >= ((Number)object).intValue();
    }

    public int getCurrentTemperature() {
        return this.temperature;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("ABS");
        $this$addTooltip.description(true, new String[0]);
        $this$addTooltip.overclockInfo(8);
        $this$addTooltip.durationInfo(UpgradeType.WIRE_COIL, 80);
        $this$addTooltip.parallelInfo(UpgradeType.PUMP_CASING, 16);
        String[] stringArray = new String[]{"gregtech.machine.electric_blast_furnace.tooltip.1", "gregtech.machine.electric_blast_furnace.tooltip.2", "gregtech.machine.electric_blast_furnace.tooltip.3"};
        $this$addTooltip.description(true, stringArray);
        return Unit.INSTANCE;
    }

    private static final void configureDisplayText$lambda$1(MultiblockAlloyBlastSmelter this$0, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed()) {
            IKey temperatureKey = KeyUtil.number((TextFormatting)TextFormatting.RED, (long)syncer.syncInt(this$0.getCurrentTemperature()), (String)"K");
            Object[] objectArray = new Object[]{temperatureKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])objectArray));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAlloyBlastSmelter$AlloyBlastSmelterRecipeLogic;", "Lgregtech/api/capability/impl/HeatingCoilRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAlloyBlastSmelter;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class AlloyBlastSmelterRecipeLogic
    extends HeatingCoilRecipeLogic {
        public AlloyBlastSmelterRecipeLogic(RecipeMapMultiblockController mte) {
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return this.getMaxVoltage() >= GTValues.V[8] ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.8, MultiblockAlloyBlastSmelter.this.coilTier)));
        }

        public int getParallelLimit() {
            return 16 * MultiblockAlloyBlastSmelter.this.pumpCasingTier;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAlloyBlastSmelter$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "pipeCasingState", "uniqueCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

