/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock.advanced;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.core.sound.GTSoundEvents;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeProperties;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017J\b\u0010\u001c\u001a\u00020\u0019H\u0015J0\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020&H\u0016J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020&H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAdvancedFusionReactor;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "fusionCasingTier", "", "fusionCoilTier", "cryostatTier", "divertorTier", "vacuumTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "hasMaintenanceMechanics", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "consumeIfSuccess", "getBreakdownSound", "Lnet/minecraft/util/SoundEvent;", "AdvancedFusionRecipeLogic", "gtlitecore"})
public final class MultiblockAdvancedFusionReactor
extends RecipeMapMultiblockController {
    private int fusionCasingTier;
    private int fusionCoilTier;
    private int cryostatTier;
    private int divertorTier;
    private int vacuumTier;
    private int tier;

    public MultiblockAdvancedFusionReactor(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.ADVANCED_FUSION_RECIPES);
        this.recipeMapWorkable = new AdvancedFusionRecipeLogic(this);
    }

    @NotNull
    public MultiblockAdvancedFusionReactor createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockAdvancedFusionReactor(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.fusionCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.FUSION_CASING_TIER, 0)).intValue();
        this.fusionCoilTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.FUSION_COIL_TIER, 0)).intValue();
        this.cryostatTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.CRYOSTAT_TIER, 0)).intValue();
        this.divertorTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.DIVERTOR_TIER, 0)).intValue();
        this.vacuumTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.VACUUM_TIER, 0)).intValue();
        int[] nArray = new int[]{this.fusionCoilTier, this.cryostatTier, this.divertorTier, this.vacuumTier};
        this.tier = ComparisonsKt.minOf((int)this.fusionCasingTier, (int[])nArray);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.fusionCasingTier = 0;
        this.fusionCoilTier = 0;
        this.cryostatTier = 0;
        this.divertorTier = 0;
        this.vacuumTier = 0;
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        this.energyContainer = (IEnergyContainer)new EnergyContainerList((List)inputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"               ", "               ", "     cECEc     ", "     cECEc     ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"               ", "       C       ", "   icvvvvvci   ", "   icvvvvvci   ", "       C       ", "               "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"       C       ", "  C  ddddd  C  ", "  Cvv#####vvC  ", "  Cvv#####vvC  ", "  C  bbbbb  C  ", "       C       "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"   C   C   C   ", "   ddddddddd   ", " Iv#########vI ", " Iv#########vI ", "   bbbbbbbbb   ", "   C   C   C   "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"    C     C    ", "   ddd#C#ddd   ", " cv###vvv###vc ", " cv###vvv###vc ", "   bbb#C#bbb   ", "    C     C    "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"               ", "  dddC###Cddd  ", "cv###v#C#v###vc", "cv###v#C#v###vc", "  bbbC###Cbbb  ", "               "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"               ", "  dd##CCC##dd  ", "Ev##v#CXC#v##vE", "Ev##v#CXC#v##vE", "  bb##CCC##bb  ", "               "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{"  CC       CC  ", " CddC#CCC#CddC ", "Cv##vCXXXCv##vC", "Cv##vCXXXCv##vC", " CbbC#CCC#CbbC ", "  CC       CC  "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{"               ", "  dd##CCC##dd  ", "Ev##v#CXC#v##vE", "Ev##v#CXC#v##vE", "  bb##CCC##bb  ", "               "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"               ", "  dddC###Cddd  ", "cv###v#C#v###vc", "cv###v#C#v###vc", "  bbbC###Cbbb  ", "               "};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{"    C     C    ", "   ddd#C#ddd   ", " cv###vvv###vc ", " cv###vvv###vc ", "   bbb#C#bbb   ", "    C     C    "};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{"   C   C   C   ", "   ddddddddd   ", " Iv#########vI ", " Iv#########vI ", "   bbbbbbbbb   ", "   C   C   C   "};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"       C       ", "  C  ddddd  C  ", "  Cvv#####vvC  ", "  Cvv#####vvC  ", "  C  bbbbb  C  ", "       C       "};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"               ", "       C       ", "   icvvvvvci   ", "   icvvvvvci   ", "       S       ", "               "};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "     cECEc     ", "     cECEc     ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray).where('S', this.selfPredicate()).where('c', TraceabilityPredicates.fusionCasings());
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate = TraceabilityPredicates.fusionCasings().or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(16));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_LASER};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.where('E', traceabilityPredicate.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(16)));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern17 = factoryBlockPattern16.where('I', TraceabilityPredicates.fusionCasings().or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1).setPreviewCount(8)));
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS};
        BlockPattern blockPattern = factoryBlockPattern17.where('i', TraceabilityPredicates.fusionCasings().or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(2).setPreviewCount(8))).where('b', TraceabilityPredicates.fusionCasings()).where('X', TraceabilityPredicates.fusionCoils()).where('C', TraceabilityPredicates.cryostats()).where('d', TraceabilityPredicates.divertors()).where('v', TraceabilityPredicates.fusionVacuums()).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        ICubeRenderer iCubeRenderer;
        if (this.recipeMapWorkable.isActive()) {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.ACTIVE_FUSION_TEXTURE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"ACTIVE_FUSION_TEXTURE");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        } else {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.FUSION_TEXTURE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"FUSION_TEXTURE");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        }
        return iCubeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.ADVANCED_FUSION_REACTOR_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
        String string5 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.5", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        tooltip.add(string5);
        String string6 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.6", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        tooltip.add(string6);
        String string7 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.7", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        tooltip.add(string7);
        String string8 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.8", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
        tooltip.add(string8);
        String string9 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.9", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        tooltip.add(string9);
        String string10 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.10", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(...)");
        tooltip.add(string10);
        String string11 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.11", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
        tooltip.add(string11);
        String string12 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.12", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
        tooltip.add(string12);
        String string13 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.13", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
        tooltip.add(string13);
        String string14 = I18n.func_135052_a((String)"gtlitecore.machine.advanced_fusion_reactor.tooltip.14", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"format(...)");
        tooltip.add(string14);
    }

    public boolean canBeDistinct() {
        return false;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Object object = recipe.getProperty(GTLiteRecipeProperties.INSTANCE.getADVANCED_FUSION_TIER(), (Object)0);
        Intrinsics.checkNotNull((Object)object);
        int recipeTier = ((Number)object).intValue();
        return super.checkRecipe(recipe, consumeIfSuccess) && this.fusionCasingTier >= recipeTier && this.fusionCoilTier >= recipeTier && this.cryostatTier >= recipeTier && this.divertorTier >= recipeTier && this.vacuumTier >= recipeTier;
    }

    @NotNull
    public SoundEvent getBreakdownSound() {
        SoundEvent soundEvent = GTSoundEvents.BREAKDOWN_ELECTRICAL;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BREAKDOWN_ELECTRICAL");
        return soundEvent;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAdvancedFusionReactor$AdvancedFusionRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/advanced/MultiblockAdvancedFusionReactor;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class AdvancedFusionRecipeLogic
    extends MultiblockRecipeLogic {
        public AdvancedFusionRecipeLogic(RecipeMapMultiblockController mte) {
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return 0.125;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, Math.min(MultiblockAdvancedFusionReactor.this.fusionCasingTier, Math.min(MultiblockAdvancedFusionReactor.this.vacuumTier, MultiblockAdvancedFusionReactor.this.cryostatTier)))));
        }

        public int getParallelLimit() {
            return 64 * Math.min(MultiblockAdvancedFusionReactor.this.fusionCoilTier, MultiblockAdvancedFusionReactor.this.divertorTier);
        }
    }
}

