/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Material;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0002%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0014J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockStellarForge;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "emitterCasingTier", "", "fieldGenCasingTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "texture", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "hasMaintenanceMechanics", "Companion", "StellarForgeRecipeLogic", "gtlitecore"})
public final class MultiblockStellarForge
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int emitterCasingTier;
    private int fieldGenCasingTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.QUANTUM_ALLOY.getState();
    @NotNull
    private static final IBlockState secondCasingState = MultiblockCasing.STELLAR_CONTAINMENT_CASING.getState();
    private static final IBlockState glassState = MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS);
    @NotNull
    private static final IBlockState coilState = MultiblockCasing.THERMAL_ENERGY_TRANSMISSION_CASING.getState();

    public MultiblockStellarForge(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.STELLAR_FORGE_RECIPES);
        this.recipeMapWorkable = new StellarForgeRecipeLogic(this);
    }

    @NotNull
    public MultiblockStellarForge createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockStellarForge(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.emitterCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.EMITTER_CASING_TIER, 0)).intValue();
        this.fieldGenCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.FIELD_GEN_CASING_TIER, 0)).intValue();
        this.tier = Math.min(this.emitterCasingTier, this.fieldGenCasingTier);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.emitterCasingTier = 0;
        this.fieldGenCasingTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"                   ", "       AQQQA       ", "        Q Q        ", "       AQQQA       ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "       AQQQA       ", "        Q Q        ", "       AQQQA       ", "                   "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"        A A        ", "     AA     AA     ", "       CCCCC       ", "     AA     AA     ", "        AAA        ", "        D D        ", "        D D        ", "        D D        ", "        D D        ", "        D D        ", "        D D        ", "        AAA        ", "     AA     AA     ", "       CCCCC       ", "     AA     AA     ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "    A  AAAAA  A    ", "     CC     CC     ", "    A  AAAAA  A    ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "    A  AAAAA  A    ", "     CC     CC     ", "    A  AAAAA  A    ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "   A AA     AA A   ", "    C  CCCCC  C    ", "   A AA     AA A   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "   A AA     AA A   ", "    C  CCCCC  C    ", "   A AA     AA A   ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "  A A         A A  ", "   C CC     CC C   ", "  A A         A A  ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "  A A         A A  ", "   C CC     CC C   ", "  A A         A A  ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"        A A        ", " A A           A A ", "  C C   EEE   C C  ", " A A    EFE    A A ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", " A A    EFE    A A ", "  C C   EEE   C C  ", " A A           A A ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"        A A        ", " A A    EEE    A A ", "  C C  E   E  C C  ", " A A   E   E   A A ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", " A A   E   E   A A ", "  C C  E   E  C C  ", " A A    EEE    A A ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "A A    EEEEE    A A", " C C  E     E  C C ", "A A   E     E   A A", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "A A   E     E   A A", " C C  E     E  C C ", "A A    EEEEE    A A", "        A A        "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{" AAAAAAA   AAAAAAA ", "Q A   EEEEEEE   A Q", "QC C E       E C CQ", "Q A  E       E  A Q", " A   E       E   A ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " A   E       E   A ", "Q A  E       E  A Q", "QC C E       E C CQ", "Q A   EEEEEEE   A Q", " AAAAAAAA AAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"         G         ", "Q A   EEEHEEE   A Q", " C C E       E C C ", "Q A  F       F  A Q", " A   F       F   A ", "     F       F     ", "     F       F     ", "     F       F     ", "     F       F     ", "     F       F     ", "     F       F     ", " A   F       F   A ", "Q A  F       F  A Q", " C C E       E C C ", "Q A   EEEHEEE   A Q", "         G         "};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{" AAAAAAA   AAAAAAA ", "Q A   EEEEEEE   A Q", "QC C E       E C CQ", "Q A  E       E  A Q", " A   E       E   A ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " D   E       E   D ", " A   E       E   A ", "Q A  E       E  A Q", "QC C E       E C CQ", "Q A   EEEEEEE   A Q", " AAAAAAAA AAAAAAAA "};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "A A    EEEEE    A A", " C C  E     E  C C ", "A A   E     E   A A", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "      E     E      ", "A A   E     E   A A", " C C  E     E  C C ", "A A    EEEEE    A A", "        A A        "};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"        A A        ", " A A    EEE    A A ", "  C C  E   E  C C  ", " A A   E   E   A A ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", "       E   E       ", " A A   E   E   A A ", "  C C  E   E  C C  ", " A A    EEE    A A ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"        A A        ", " A A           A A ", "  C C   EEE   C C  ", " A A    EFE    A A ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", "        EFE        ", " A A    EFE    A A ", "  C C   EEE   C C  ", " A A           A A ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "  A A         A A  ", "   C CC     CC C   ", "  A A         A A  ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "  A A         A A  ", "   C CC     CC C   ", "  A A         A A  ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "   A AA     AA A   ", "    C  CCCCC  C    ", "   A AA     AA A   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "   A AA     AA A   ", "    C  CCCCC  C    ", "   A AA     AA A   ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "    A  AAAAA  A    ", "     CC     CC     ", "    A  AAAAA  A    ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "    A  AAAAA  A    ", "     CC     CC     ", "    A  AAAAA  A    ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern17 = factoryBlockPattern16.aisle(stringArray);
        stringArray = new String[]{"        A A        ", "     AA     AA     ", "       CCCCC       ", "     AA     AA     ", "        AAA        ", "        D D        ", "        D D        ", "        D D        ", "        D D        ", "        D D        ", "        D D        ", "        AAA        ", "     AA     AA     ", "       CCCCC       ", "     AA     AA     ", "        A A        "};
        FactoryBlockPattern factoryBlockPattern18 = factoryBlockPattern17.aisle(stringArray);
        stringArray = new String[]{"                   ", "       AQQQA       ", "        QSQ        ", "       AQQQA       ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "       AQQQA       ", "        Q Q        ", "       AQQQA       ", "                   "};
        FactoryBlockPattern factoryBlockPattern19 = factoryBlockPattern18.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.EXPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern20 = factoryBlockPattern19.where('A', traceabilityPredicate.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray)));
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate2 = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate3 = traceabilityPredicate2.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1).setMaxGlobalLimited(3).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.EXPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern21 = factoryBlockPattern20.where('Q', traceabilityPredicate3.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray)));
        stringArray = new Material[]{GTLiteMaterials.INSTANCE.getBedrockium()};
        FactoryBlockPattern factoryBlockPattern22 = factoryBlockPattern21.where('D', RecipeMapMultiblockController.frames((Material[])stringArray));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern23 = factoryBlockPattern22.where('E', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{glassState};
        FactoryBlockPattern factoryBlockPattern24 = factoryBlockPattern23.where('F', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{coilState};
        BlockPattern blockPattern = factoryBlockPattern24.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray)).where('G', TraceabilityPredicates.fieldGenCasings()).where('H', TraceabilityPredicates.emitterCasings()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart texture) {
        return (ICubeRenderer)GTLiteOverlays.QUANTUM_ALLOY_CASING;
    }

    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.STELLAR_FORGE_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockStellarForge::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("SF");
        String[] stringArray = new String[]{"gtlitecore.machine.stellar_forge.tooltip.1", "gtlitecore.machine.stellar_forge.tooltip.2"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.overclockInfo(-1);
        $this$addTooltip.durationInfo(UpgradeType.EMITTER_CASING, 50);
        $this$addTooltip.parallelInfo(UpgradeType.FIELD_GEN_CASING, 32);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockStellarForge$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "glassState", "kotlin.jvm.PlatformType", "Lnet/minecraft/block/state/IBlockState;", "coilState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockStellarForge$StellarForgeRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockStellarForge;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class StellarForgeRecipeLogic
    extends MultiblockRecipeLogic {
        public StellarForgeRecipeLogic(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity, true);
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, MultiblockStellarForge.this.emitterCasingTier)));
        }

        public int getParallelLimit() {
            return 32 * MultiblockStellarForge.this.fieldGenCasingTier;
        }
    }
}

