/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0002%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u0016H\u0015J0\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockSonicator;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "motorCasingTier", "", "pumpCasingTier", "glassTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "Companion", "SonicatorRecipeLogic", "gtlitecore"})
public final class MultiblockSonicator
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int motorCasingTier;
    private int pumpCasingTier;
    private int glassTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.COBALT_BRASS.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.TITANIUM_PIPE.getState();

    public MultiblockSonicator(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.SONICATION_RECIPES);
        this.recipeMapWorkable = new SonicatorRecipeLogic(this);
    }

    @NotNull
    public MultiblockSonicator createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockSonicator(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.motorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MOTOR_CASING_TIER, 0)).intValue();
        this.pumpCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PUMP_CASING_TIER, 0)).intValue();
        this.glassTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.BOROSILICATE_GLASS_TIER, 0)).intValue();
        this.tier = Math.min(this.motorCasingTier, Math.min(this.pumpCasingTier, this.glassTier));
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.motorCasingTier = 0;
        this.pumpCasingTier = 0;
        this.glassTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCCCC", "CCCCC", "CCCCC", "     "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCCCC", "C###C", "CGGGC", "     "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "C#M#C", "CGQGC", "  P  "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "C###C", "CGGGC", "  P  "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"CCCCC", "CCCCC", "CCCCC", "  P  "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{" CCC ", " CPC ", " CQC ", "  P  "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{" CCC ", " CSC ", " CCC ", "     "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(46).or(this.autoAbilities()));
        stringArray = new IBlockState[]{pipeCasingState};
        BlockPattern blockPattern = factoryBlockPattern8.where('P', RecipeMapMultiblockController.states((IBlockState[])stringArray)).where('M', TraceabilityPredicates.motorCasings()).where('Q', TraceabilityPredicates.pumpCasings()).where('G', TraceabilityPredicates.borosilicateGlasses()).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.COBALT_BRASS_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.SONICATOR_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockSonicator::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return true;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("Son");
        $this$addTooltip.description(true, new String[0]);
        $this$addTooltip.overclockInfo(8);
        String[] stringArray = new String[]{"gtlitecore.machine.sonicator.tooltip.1"};
        $this$addTooltip.description(false, stringArray);
        $this$addTooltip.parallelInfo(UpgradeType.VOLTAGE_TIER, 4);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockSonicator$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockSonicator$SonicatorRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockSonicator;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getOverclockingDurationFactor", "", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class SonicatorRecipeLogic
    extends MultiblockRecipeLogic {
        public SonicatorRecipeLogic(RecipeMapMultiblockController mte) {
            super(mte);
        }

        protected double getOverclockingDurationFactor() {
            return MultiblockSonicator.this.glassTier >= 5 ? 0.25 : 0.5;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.8, Math.min(MultiblockSonicator.this.motorCasingTier, MultiblockSonicator.this.pumpCasingTier))));
        }

        public int getParallelLimit() {
            return 4 * GTUtility.getTierByVoltage((long)this.getMaxVoltage());
        }
    }
}

