/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.core.sound.GTSoundEvents;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeProperties;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.GlassCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0002./B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u0016H\u0015J0\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockQuantumForceTransformer;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "manipulatorTier", "", "shieldingCoreTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "canBeDistinct", "getBreakdownSound", "Lnet/minecraft/util/SoundEvent;", "checkRecipe", "recipe", "Lgregtech/api/recipes/Recipe;", "consumeIfSuccess", "Companion", "QuantumForceTransformerRecipeLogic", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMultiblockQuantumForceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockQuantumForceTransformer.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockQuantumForceTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1863#2,2:311\n1863#2,2:313\n*S KotlinDebug\n*F\n+ 1 MultiblockQuantumForceTransformer.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockQuantumForceTransformer\n*L\n181#1:311,2\n184#1:313,2\n*E\n"})
public final class MultiblockQuantumForceTransformer
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int manipulatorTier;
    private int shieldingCoreTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MultiblockCasing.PARTICLE_CONTAINMENT_CASING.getState();
    @NotNull
    private static final IBlockState coilState = MultiblockCasing.PARTICLE_EXCITATION_WIRE_COIL.getState();
    @NotNull
    private static final IBlockState glassState = GlassCasing.FORCE_FIELD.getState();

    public MultiblockQuantumForceTransformer(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.QUANTUM_FORCE_TRANSFORMER_RECIPES);
        this.recipeMapWorkable = new QuantumForceTransformerRecipeLogic(this);
    }

    @NotNull
    public MultiblockQuantumForceTransformer createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockQuantumForceTransformer(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.manipulatorTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MANIPULATOR_TIER, 0)).intValue();
        this.shieldingCoreTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.SHIELDING_CORE_TIER, 0)).intValue();
        this.tier = Math.min(this.manipulatorTier, this.shieldingCoreTier);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.manipulatorTier = 0;
        this.shieldingCoreTier = 0;
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        this.energyContainer = (IEnergyContainer)new EnergyContainerList((List)inputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"    A     A    ", "    A     A    ", "    A     A    ", "   BA     AB   ", "   BABBABBAB   ", "   BAAAAAAAB   ", "   BBBBABBBB   ", "      BAB      ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "  A         A  ", "  A         A  ", "  B         B  ", "  BAAAAAAAAAB  ", "   AAABBBAAA   ", "      BAB      ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", " A           A ", " A           A ", " B           B ", " BAA       AAB ", "  AA       AA  ", "    AA   AA    ", "      BAB      ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"A             A", "A             A", "A             A", "A             A", "A             A", "B             B", "BAA         AAB", " AA         AA ", "   AA     AA   ", "     BAAAB     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"      HHH      ", "      EEE      ", "      EEE      ", "      EEE      ", "B     DDD     B", "B     EEE     B", "BA    DDD    AB", " A    EEE    A ", "  AA  EEE  AA  ", "    BAEEEAB    ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "      EEE      ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      FFF      "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"     HHHHH     ", "     ECCCE     ", "     ECCCE     ", "B    ECCCE    B", "B    D###D    B", "B    ECCCE    B", "BA   D###D   AB", " A   ECCCE   A ", "  A  ECCCE  A  ", "   BAECCCEAB   ", "     D###D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D###D     ", "     ECCCE     ", "     D###D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     FFFFF     "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"    HHHHHHH    ", "    EC###CE    ", "A   EC###CE   A", "A   EC###CE   A", "A   D#####D   A", "A   EC###CE   A", "BA  D#####D  AB", "BB  EC###CE  BB", " B  EC###CE  B ", "  BAEC###CEAB  ", "    D#####D    ", "    EC###CE    ", "    EC###CE    ", "    EC###CE    ", "    D#####D    ", "    EC###CE    ", "    D#####D    ", "    EC###CE    ", "    EC###CE    ", "    ECCCCCE    ", "    FFFFFFF    "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{"    HHHHHHH    ", "    EC###CE    ", "    EC###CE    ", "    EC###CE    ", "A   D#####D   A", "A   EC###CE   A", "AA  D#####D  AA", "AB  EC###CE  BA", " A  EC###CE  A ", "  AAEC###CEAA  ", "    D#####D    ", "    EC###CE    ", "    EC###CE    ", "    EC###CE    ", "    D#####D    ", "    EC###CE    ", "    D#####D    ", "    EC###CE    ", "    EC###CE    ", "    ECCCCCE    ", "    FFFFFFF    "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{"    HHHHHHH    ", "    EC###CE    ", "    EC###CE    ", "A   EC###CE   A", "A   D#####D   A", "A   EC###CE   A", "BA  D#####D  AB", "BB  EC###CE  BB", " B  EC###CE  B ", "  BAEC###CEAB  ", "    D#####D    ", "    EC###CE    ", "    EC###CE    ", "    EC###CE    ", "    D#####D    ", "    EC###CE    ", "    D#####D    ", "    EC###CE    ", "    EC###CE    ", "    ECCCCCE    ", "    FFFFFFF    "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"     HHHHH     ", "     ECCCE     ", "     ECCCE     ", "B    ECCCE    B", "B    D###D    B", "B    ECCCE    B", "BA   D###D   AB", " A   ECCCE   A ", "  A  ECCCE  A  ", "   BAECCCEAB   ", "     D###D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D###D     ", "     ECCCE     ", "     D###D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     FFFFF     "};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{"      HSH      ", "      EEE      ", "      EEE      ", "      EEE      ", "B     DDD     B", "B     EEE     B", "BA    DDD    AB", " A    EEE    A ", "  AA  EEE  AA  ", "    BAEEEAB    ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "      EEE      ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      FFF      "};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{"A             A", "A             A", "A             A", "A             A", "A             A", "B             B", "BAA          AB", " AA         AA ", "   AA     AA   ", "     BAAAB     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", " A           A ", " A           A ", " B           B ", " BA         AB ", "  AA       AA  ", "    AA   AA    ", "      BAB      ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "  A         A  ", "  A         A  ", "  B         B  ", "  BAAAAAAAAAB  ", "   AAABBBAAA   ", "      BAB      ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{"    A     A    ", "    A     A    ", "    A     A    ", "   BA     AB   ", "   BABBABBAB   ", "   BAAAAAAAB   ", "   BBBBABBBB   ", "      BAB      ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(16);
        stringArray = new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setExactLimit(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate3 = traceabilityPredicate2.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(2));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_LASER};
        TraceabilityPredicate traceabilityPredicate4 = traceabilityPredicate3.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.where('H', traceabilityPredicate4.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(1)));
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate5 = RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(16);
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.EXPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern17 = factoryBlockPattern16.where('F', traceabilityPredicate5.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setPreviewCount(1))).where('A', TraceabilityPredicates.manipulators()).where('B', TraceabilityPredicates.shieldingCores());
        stringArray = new IBlockState[]{coilState};
        FactoryBlockPattern factoryBlockPattern18 = factoryBlockPattern17.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern19 = factoryBlockPattern18.where('D', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{glassState};
        BlockPattern blockPattern = factoryBlockPattern19.where('E', RecipeMapMultiblockController.states((IBlockState[])stringArray)).where(' ', RecipeMapMultiblockController.any()).where('#', RecipeMapMultiblockController.air()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.PARTICLE_CONTAINMENT_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.QUANTUM_FORCE_TRANSFORMER_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
        String string5 = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.5", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        tooltip.add(string5);
        String string6 = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.6", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        tooltip.add(string6);
        String string7 = I18n.func_135052_a((String)"gtlitecore.machine.quantum_force_transformer.tooltip.7", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        tooltip.add(string7);
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.energyContainer).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom((arg_0, arg_1) -> MultiblockQuantumForceTransformer.configureDisplayText$lambda$0(this, arg_0, arg_1)).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    public boolean canBeDistinct() {
        return true;
    }

    @NotNull
    public SoundEvent getBreakdownSound() {
        SoundEvent soundEvent = GTSoundEvents.BREAKDOWN_ELECTRICAL;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BREAKDOWN_ELECTRICAL");
        return soundEvent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        ChancedItemOutput chanceEntry;
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        List list = recipe.getChancedOutputs().getChancedEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChancedEntries(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            chanceEntry = (ChancedItemOutput)element$iv;
            boolean bl = false;
            Math.min(chanceEntry.getChance() * this.shieldingCoreTier, 10000);
        }
        List list2 = recipe.getChancedFluidOutputs().getChancedEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChancedEntries(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            chanceEntry = (ChancedFluidOutput)element$iv;
            boolean bl = false;
            Math.min(chanceEntry.getChance() * this.shieldingCoreTier, 10000);
        }
        if (!super.checkRecipe(recipe, consumeIfSuccess)) return false;
        Object object = recipe.getProperty(GTLiteRecipeProperties.INSTANCE.getQUANTUM_FORCE_TRANSFORMER_TIER(), (Object)0);
        Intrinsics.checkNotNull((Object)object);
        if (((Number)object).intValue() > this.manipulatorTier) return false;
        return true;
    }

    private static final void configureDisplayText$lambda$0(MultiblockQuantumForceTransformer this$0, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed()) {
            IKey manipulatorTierKey = KeyUtil.number((TextFormatting)TextFormatting.GREEN, (long)syncer.syncInt(this$0.manipulatorTier));
            IKey shieldingCoreTierKey = KeyUtil.number((TextFormatting)TextFormatting.GREEN, (long)syncer.syncInt(this$0.shieldingCoreTier));
            Object[] objectArray = new Object[]{manipulatorTierKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gtlitecore.machine.quantum_force_transformer.manipulator_info", (Object[])objectArray));
            objectArray = new Object[]{shieldingCoreTierKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gtlitecore.machine.quantum_force_transformer.shielding_core_info", (Object[])objectArray));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockQuantumForceTransformer$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "coilState", "glassState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockQuantumForceTransformer$QuantumForceTransformerRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockQuantumForceTransformer;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class QuantumForceTransformerRecipeLogic
    extends MultiblockRecipeLogic {
        public QuantumForceTransformerRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte);
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.75, MultiblockQuantumForceTransformer.this.manipulatorTier)));
        }

        public int getParallelLimit() {
            return 16 * MultiblockQuantumForceTransformer.this.shieldingCoreTier;
        }
    }
}

