/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.variant.ActiveUniqueCasing;
import gregtechlite.gtlitecore.common.block.variant.GlassCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u0018H\u0015J0\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockPlasmaEnhancedCVDUnit;", "Lgregtech/api/metatileentity/multiblock/MultiMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "emitterCasingTier", "", "sensorCasingTier", "fieldGenCasingTier", "pumpCasingTier", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "Companion", "PlasmaEnhancedCVDRecipeLogic", "gtlitecore"})
public final class MultiblockPlasmaEnhancedCVDUnit
extends MultiMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int emitterCasingTier;
    private int sensorCasingTier;
    private int fieldGenCasingTier;
    private int pumpCasingTier;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.TRINAQUADALLOY.getState();
    @NotNull
    private static final IBlockState secondCasingState = MultiblockCasing.ADVANCED_SUBSTRATE_CASING.getState();
    @NotNull
    private static final IBlockState uniqueCasingState = ActiveUniqueCasing.HEAT_VENT.getState();
    @NotNull
    private static final IBlockState glassState = GlassCasing.PMMA.getState();

    public MultiblockPlasmaEnhancedCVDUnit(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RecipeMap[] recipeMapArray = new RecipeMap[]{GTLiteRecipeMaps.PLASMA_CVD_RECIPES, GTLiteRecipeMaps.CRYSTALLIZATION_RECIPES, GTLiteRecipeMaps.MOLECULAR_BEAM_RECIPES, GTLiteRecipeMaps.SONICATION_RECIPES};
        super(id, recipeMapArray);
        this.recipeMapWorkable = new PlasmaEnhancedCVDRecipeLogic((RecipeMapMultiblockController)this);
    }

    @NotNull
    public MultiblockPlasmaEnhancedCVDUnit createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockPlasmaEnhancedCVDUnit(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.emitterCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.EMITTER_CASING_TIER, 0)).intValue();
        this.sensorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.SENSOR_CASING_TIER, 0)).intValue();
        this.fieldGenCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.FIELD_GEN_CASING_TIER, 0)).intValue();
        this.pumpCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PUMP_CASING_TIER, 0)).intValue();
        int[] nArray = new int[]{this.sensorCasingTier, this.fieldGenCasingTier, this.pumpCasingTier};
        this.tier = ComparisonsKt.minOf((int)this.emitterCasingTier, (int[])nArray);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.emitterCasingTier = 0;
        this.sensorCasingTier = 0;
        this.fieldGenCasingTier = 0;
        this.pumpCasingTier = 0;
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        ArrayList inputEnergy = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        inputEnergy.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        this.energyContainer = (IEnergyContainer)new EnergyContainerList((List)inputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCCCCCC", " CRRRC ", " CTTTC ", "  CCC  "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCCCCCC", "CDDDDDC", "C#####C", " CGGGC "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"PCCCCCP", "HDDDDDH", "F#####F", " CGGGC "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"CCCCCCC", "CDDDDDC", "C#####C", " CGGGC "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"CCCCCCC", " SGGGC ", " CGGGC ", "       "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(25).or(this.autoAbilities(false, true, true, true, true, true, false));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(3));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_LASER};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.where('C', traceabilityPredicate2.or(MultiMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(1)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.where('D', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{uniqueCasingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('H', MultiMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{glassState};
        BlockPattern blockPattern = factoryBlockPattern8.where('G', MultiMapMultiblockController.states((IBlockState[])stringArray)).where('R', TraceabilityPredicates.emitterCasings()).where('T', TraceabilityPredicates.sensorCasings()).where('F', TraceabilityPredicates.fieldGenCasings()).where('P', TraceabilityPredicates.pumpCasings()).where('#', MultiMapMultiblockController.air()).where(' ', MultiMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.TRINAQUADALLOY_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.CVD_UNIT_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockPlasmaEnhancedCVDUnit::addInformation$lambda$0));
    }

    public boolean canBeDistinct() {
        return true;
    }

    private static final Unit addInformation$lambda$0(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("PECVD");
        String[] stringArray = new String[]{"gtlitecore.machine.plasma_enhanced_cvd_unit.tooltip.1", "gtlitecore.machine.plasma_enhanced_cvd_unit.tooltip.2"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.overclockInfo(-1);
        stringArray = new String[]{"gtlitecore.machine.plasma_enhanced_cvd_unit.tooltip.3", "gtlitecore.machine.plasma_enhanced_cvd_unit.tooltip.4"};
        $this$addTooltip.description(false, stringArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockPlasmaEnhancedCVDUnit$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "uniqueCasingState", "glassState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockPlasmaEnhancedCVDUnit$PlasmaEnhancedCVDRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockPlasmaEnhancedCVDUnit;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class PlasmaEnhancedCVDRecipeLogic
    extends MultiblockRecipeLogic {
        public PlasmaEnhancedCVDRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte, true);
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, Math.min(MultiblockPlasmaEnhancedCVDUnit.this.emitterCasingTier, MultiblockPlasmaEnhancedCVDUnit.this.sensorCasingTier))));
        }

        public int getParallelLimit() {
            return 32 * Math.min(MultiblockPlasmaEnhancedCVDUnit.this.pumpCasingTier, MultiblockPlasmaEnhancedCVDUnit.this.fieldGenCasingTier);
        }
    }
}

