/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.block.VariantBlock;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityItemBus;
import gregtech.core.sound.GTSoundEvents;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeProperties;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.block.adapter.GTGlassCasing;
import gregtechlite.gtlitecore.common.block.variant.Crucible;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u0018H\u0015J0\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockNanoscaleFabricator;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "emitterCasingTier", "", "robotArmCasingTier", "temperature", "tier", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "cruciblePredicate", "Lgregtech/api/pattern/TraceabilityPredicate;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "canBeDistinct", "getBreakdownSound", "Lnet/minecraft/util/SoundEvent;", "Companion", "NanoscaleFabricatorRecipeLogic", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMultiblockNanoscaleFabricator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockNanoscaleFabricator.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockNanoscaleFabricator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,227:1\n1053#2:228\n1557#2:229\n1628#2,3:230\n37#3:233\n36#3,3:234\n*S KotlinDebug\n*F\n+ 1 MultiblockNanoscaleFabricator.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockNanoscaleFabricator\n*L\n143#1:228\n144#1:229\n144#1:230,3\n145#1:233\n145#1:234,3\n*E\n"})
public final class MultiblockNanoscaleFabricator
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int emitterCasingTier;
    private int robotArmCasingTier;
    private int temperature;
    private int tier;
    @NotNull
    private static final IBlockState casingState = MetalCasing.TITANIUM_TUNGSTEN_CARBIDE.getState();
    @NotNull
    private static final IBlockState secondCasingState = MetalCasing.HSLA_STEEL.getState();
    @NotNull
    private static final IBlockState thirdCasingState = MultiblockCasing.SUBSTRATE_CASING.getState();
    @NotNull
    private static final IBlockState glassState = GTGlassCasing.LAMINATED_GLASS.getState();

    public MultiblockNanoscaleFabricator(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.MOLECULAR_BEAM_RECIPES);
        this.recipeMapWorkable = new NanoscaleFabricatorRecipeLogic(this);
    }

    @NotNull
    public MultiblockNanoscaleFabricator createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockNanoscaleFabricator(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.emitterCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.EMITTER_CASING_TIER, 0)).intValue();
        this.robotArmCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.ROBOT_ARM_CASING_TIER, 0)).intValue();
        int pseudoCrucibleTier = TraceabilityPredicates.getTierOrDefault(context, GTLiteAPI.CRUCIBLE_STATS, 0);
        this.tier = Math.min(this.emitterCasingTier, Math.min(this.robotArmCasingTier, pseudoCrucibleTier));
        int crucibleAmount = context.getInt("CrucibleAmount");
        this.temperature = crucibleAmount != 0 ? context.getInt("Temperature") / crucibleAmount : 0;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.emitterCasingTier = 0;
        this.robotArmCasingTier = 0;
        this.temperature = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"   TTT   ", "   TIT   ", "   TCT   ", "         "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"  XXXXX  ", "  XXRXX  ", "  XXXXX  ", "  XXXXX  "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{" XXXXXXX ", " X#####X ", " X#####X ", " XXGGGXX "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"TXXTTTXXT", "TX##Z##XT", "TX#####XT", " XGGGGGX "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"TXXTITXXT", "IR#ZAZ#RI", "CX#####XC", " XGGGGGX "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"TXXTTTXXT", "TX##Z##XT", "TX#####XT", " XGGGGGX "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{" XXXXXXX ", " X#####X ", " X#####X ", " XXGGGXX "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{"  XXXXX  ", "  XXRXX  ", "  XXXXX  ", "  XXSXX  "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{"   TTT   ", "   TIT   ", "   TCT   ", "         "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.where('X', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(84).or(this.autoAbilities(true, true, false, true, true, false, false)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.where('T', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(36));
        stringArray = new IBlockState[]{glassState};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.where('G', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new MetaTileEntity[]{MetaTileEntities.ITEM_IMPORT_BUS[0]};
        TraceabilityPredicate traceabilityPredicate = RecipeMapMultiblockController.metaTileEntities((MetaTileEntity[])stringArray);
        stringArray = new MetaTileEntity[]{GTLiteMetaTileEntities.INSTANCE.getHUGE_ITEM_IMPORT_BUS()[0]};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(RecipeMapMultiblockController.metaTileEntities((MetaTileEntity[])stringArray));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.where('I', traceabilityPredicate2.or(RecipeMapMultiblockController.states((IBlockState[])stringArray)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray).or(this.cruciblePredicate()));
        stringArray = new IBlockState[]{thirdCasingState};
        BlockPattern blockPattern = factoryBlockPattern14.where('A', RecipeMapMultiblockController.states((IBlockState[])stringArray)).where('Z', TraceabilityPredicates.emitterCasings()).where('R', TraceabilityPredicates.robotArmCasings()).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    private final TraceabilityPredicate cruciblePredicate() {
        return new TraceabilityPredicate(MultiblockNanoscaleFabricator::cruciblePredicate$lambda$0, MultiblockNanoscaleFabricator::cruciblePredicate$lambda$3);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        if (sourcePart instanceof MetaTileEntityItemBus && ((MetaTileEntityItemBus)sourcePart).getExportItems().getSlots() == 0) {
            return (ICubeRenderer)GTLiteOverlays.HSLA_STEEL_CASING;
        }
        return (ICubeRenderer)GTLiteOverlays.TITANIUM_TUNGSTEN_CARBIDE_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.NANOSCALE_FABRICATOR_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockNanoscaleFabricator::addInformation$lambda$4));
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.energyContainer).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom((arg_0, arg_1) -> MultiblockNanoscaleFabricator.configureDisplayText$lambda$5(this, arg_0, arg_1)).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine((AbstractRecipeLogic)this.recipeMapWorkable);
    }

    public boolean canBeDistinct() {
        return false;
    }

    @NotNull
    public SoundEvent getBreakdownSound() {
        SoundEvent soundEvent = GTSoundEvents.BREAKDOWN_ELECTRICAL;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BREAKDOWN_ELECTRICAL");
        return soundEvent;
    }

    private static final boolean cruciblePredicate$lambda$0(BlockWorldState blockWorldState) {
        Intrinsics.checkNotNullParameter((Object)blockWorldState, (String)"blockWorldState");
        IBlockState iBlockState = blockWorldState.getBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
        IBlockState state = iBlockState;
        Block block = state.func_177230_c();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = block;
        if (block2 instanceof VariantBlock) {
            Integer storedTemperature = (Integer)blockWorldState.getMatchContext().getOrPut("Temperature", (Object)0);
            PatternMatchContext patternMatchContext = blockWorldState.getMatchContext();
            int n = ((Crucible)GTLiteBlocks.INSTANCE.getCRUCIBLE().getState(state)).getTemperature();
            Intrinsics.checkNotNull((Object)storedTemperature);
            patternMatchContext.set("Temperature", (Object)(n + storedTemperature));
            Integer storedCrucibleAmount = (Integer)blockWorldState.getMatchContext().getOrPut("CrucibleAmount", (Object)0);
            PatternMatchContext patternMatchContext2 = blockWorldState.getMatchContext();
            Intrinsics.checkNotNull((Object)storedCrucibleAmount);
            patternMatchContext2.set("CrucibleAmount", (Object)(1 + storedCrucibleAmount));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final BlockInfo[] cruciblePredicate$lambda$3() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = (Iterable)Crucible.getEntries();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Crucible it = (Crucible)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTemperature());
                it = (Crucible)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTemperature()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Crucible crucible = (Crucible)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BlockInfo(GTLiteBlocks.INSTANCE.getCRUCIBLE().getState((Enum)it), null));
        }
        Collection $this$toTypedArray$iv = (List)var3_3;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new BlockInfo[0]);
    }

    private static final Unit addInformation$lambda$4(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("NFab");
        String[] stringArray = new String[]{"gtlitecore.machine.nanoscale_fabricator.tooltip.1", "gtlitecore.machine.nanoscale_fabricator.tooltip.2", "gtlitecore.machine.nanoscale_fabricator.tooltip.3"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.overclockInfo(-1);
        $this$addTooltip.durationInfo(UpgradeType.EMITTER_CASING, 80);
        $this$addTooltip.parallelInfo(UpgradeType.ROBOT_ARM_CASING, 4);
        return Unit.INSTANCE;
    }

    private static final void configureDisplayText$lambda$5(MultiblockNanoscaleFabricator this$0, KeyManager keyManager, UISyncer syncer) {
        if (this$0.isStructureFormed()) {
            IKey temperatureKey = KeyUtil.number((TextFormatting)TextFormatting.RED, (long)syncer.syncInt(this$0.temperature), (String)"K");
            Object[] objectArray = new Object[]{temperatureKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gtlitecore.machine.nanoscale_fabricator.average_temperature", (Object[])objectArray));
            IKey lowerTemperatureKey = KeyUtil.number((TextFormatting)TextFormatting.RED, (long)((long)syncer.syncInt(this$0.temperature) - 250L), (String)"K");
            IKey upperTemperatureKey = KeyUtil.number((TextFormatting)TextFormatting.RED, (long)((long)syncer.syncInt(this$0.temperature) + 250L), (String)"K");
            Object[] objectArray2 = new Object[]{lowerTemperatureKey, upperTemperatureKey};
            keyManager.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.GRAY, (String)"gtlitecore.machine.nanoscale_fabricator.temperature_range", (Object[])objectArray2));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockNanoscaleFabricator$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "thirdCasingState", "glassState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockNanoscaleFabricator$NanoscaleFabricatorRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "metaTileEntity", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockNanoscaleFabricator;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "checkRecipe", "", "recipe", "Lgregtech/api/recipes/Recipe;", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class NanoscaleFabricatorRecipeLogic
    extends MultiblockRecipeLogic {
        public NanoscaleFabricatorRecipeLogic(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity, true);
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            int n = MultiblockNanoscaleFabricator.this.temperature;
            Object object = recipe.getProperty(GTLiteRecipeProperties.INSTANCE.getNO_COIL_TEMPERATURE(), (Object)0);
            Intrinsics.checkNotNull((Object)object);
            int delta = n - ((Number)object).intValue();
            return 1 <= delta ? delta < 250 : false;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.8, MultiblockNanoscaleFabricator.this.emitterCasingTier)));
        }

        public int getParallelLimit() {
            return 4 * MultiblockNanoscaleFabricator.this.robotArmCasingTier;
        }
    }
}

