/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTCleanroomCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTTurbineCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTWarningSignBlock;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\b\u0010\u000f\u001a\u00020\fH\u0015J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016\u00a8\u0006 "}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockMiningDroneAirport;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "getMatchingShapes", "", "Lgregtech/api/pattern/MultiblockShapeInfo;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "advanced", "", "hasMufflerMechanics", "canBeDistinct", "Companion", "gtlitecore"})
public final class MultiblockMiningDroneAirport
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IBlockState casingState = GTWarningSignBlock.YELLOW_STRIPES.getState();
    @NotNull
    private static final IBlockState anotherCasingState = GTWarningSignBlock.SMALL_YELLOW_STRIPES.getState();
    @NotNull
    private static final IBlockState secondCasingState = GTCleanroomCasing.PLASCRETE.getState();
    @NotNull
    private static final IBlockState thirdCasingState = GTMetalCasing.STEEL_SOLID.getState();
    @NotNull
    private static final IBlockState gearboxCasingState = GTTurbineCasing.STEEL_GEARBOX.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.STEEL_PIPE.getState();

    public MultiblockMiningDroneAirport(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.MINING_DRONE_RECIPES);
    }

    @NotNull
    public MultiblockMiningDroneAirport createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockMiningDroneAirport(resourceLocation);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"    F     F", "    F     F", "     FCCCF ", "     F   F ", "           ", "           "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"F          ", "F          ", "FFFFFCXXXCF", " AAAF     F", " AAA       ", "           "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"           ", "           ", "FAAACXXXXXC", "P###P      ", "P###P      ", " AAA       "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"           ", "           ", "FAAACXXXXXC", "A#G#A      ", "A#G#A      ", " AMA       "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"           ", "           ", "FAAACXXXXXC", "P###P      ", "P###P      ", " AAA       "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"F          ", "F          ", "FFFFFCXXXCF", " AAAF     F", " ASA       ", "           "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"    F     F", "    F     F", "     FCCCF ", "     F   F ", "           ", "           "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new IBlockState[]{anotherCasingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('C', traceabilityPredicate.or(RecipeMapMultiblockController.states((IBlockState[])stringArray)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.where('X', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{thirdCasingState};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.where('A', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(25).or(this.autoAbilities(true, true, true, true, true, false, false)));
        stringArray = new IBlockState[]{gearboxCasingState};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.where('G', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{pipeCasingState};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.where('P', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new Material[]{Materials.Steel};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.where('F', RecipeMapMultiblockController.frames((Material[])stringArray));
        stringArray = new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH};
        BlockPattern blockPattern = factoryBlockPattern13.where('M', RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray)).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        SimpleOverlayRenderer simpleOverlayRenderer = Textures.SOLID_STEEL_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"SOLID_STEEL_CASING");
        return (ICubeRenderer)simpleOverlayRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.MINING_DRONE_AIRPORT_OVERLAY;
    }

    @NotNull
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        Object[] objectArray = new RelativeDirection[]{RelativeDirection.LEFT, RelativeDirection.DOWN, RelativeDirection.FRONT};
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder((RelativeDirection[])objectArray);
        objectArray = new String[]{"    F     F", "    F     F", "     FCCCF ", "     F   F ", "           ", "           "};
        MultiblockShapeInfo.Builder builder2 = builder.aisle((String[])objectArray);
        objectArray = new String[]{"F          ", "F          ", "FFFFFCXXXCF", " AEAF     F", " AAA       ", "           "};
        MultiblockShapeInfo.Builder builder3 = builder2.aisle((String[])objectArray);
        objectArray = new String[]{"           ", "           ", "FAAACXXXXXC", "P   P      ", "P   P      ", " AAA       "};
        MultiblockShapeInfo.Builder builder4 = builder3.aisle((String[])objectArray);
        objectArray = new String[]{"           ", "           ", "FAAACXXXXXC", "A G A      ", "A G A      ", " AMA       "};
        MultiblockShapeInfo.Builder builder5 = builder4.aisle((String[])objectArray);
        objectArray = new String[]{"           ", "           ", "FAAACXXXXXC", "P   P      ", "P   P      ", " AAA       "};
        MultiblockShapeInfo.Builder builder6 = builder5.aisle((String[])objectArray);
        objectArray = new String[]{"F          ", "F          ", "FFFFFCXXXCF", " IWIF     F", " JSK       ", "           "};
        MultiblockShapeInfo.Builder builder7 = builder6.aisle((String[])objectArray);
        objectArray = new String[]{"    F     F", "    F     F", "     FCCCF ", "     F   F ", "           ", "           "};
        MultiblockShapeInfo.Builder builder8 = builder7.aisle((String[])objectArray).where('S', (MetaTileEntity)GTLiteMetaTileEntities.INSTANCE.getMINING_DRONE_AIRPORT(), EnumFacing.SOUTH).where('C', anotherCasingState).where('X', secondCasingState).where('A', thirdCasingState).where('G', gearboxCasingState).where('P', pipeCasingState);
        Object v = MetaBlocks.FRAMES.get(Materials.Steel);
        Intrinsics.checkNotNull(v);
        MultiblockShapeInfo.Builder builder9 = builder8.where('F', ((BlockFrame)v).getBlock(Materials.Steel)).where('M', (MetaTileEntity)MetaTileEntities.MUFFLER_HATCH[1], EnumFacing.UP).where('W', MultiblockMiningDroneAirport::getMatchingShapes$lambda$0, EnumFacing.SOUTH).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[0], EnumFacing.NORTH).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[0], EnumFacing.SOUTH).where('J', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[0], EnumFacing.SOUTH).where('K', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[0], EnumFacing.SOUTH);
        shapeInfo.add(builder9.shallowCopy().where('C', casingState).build());
        shapeInfo.add(builder9.build());
        return shapeInfo;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.mining_drone_airport.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.mining_drone_airport.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.mining_drone_airport.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
        String string4 = I18n.func_135052_a((String)"gtlitecore.machine.mining_drone_airport.tooltip.4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        tooltip.add(string4);
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    private static final Object getMatchingShapes$lambda$0() {
        return ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : thirdCasingState;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockMiningDroneAirport$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "anotherCasingState", "secondCasingState", "thirdCasingState", "gearboxCasingState", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

